/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.ints.AbstractIntIterator;
import ch.javasoft.util.ints.AbstractSortedIntSet;
import ch.javasoft.util.ints.IntIterator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIntSet
extends AbstractSortedIntSet
implements Serializable {
    private static final long serialVersionUID = 7872346283483103840L;
    private final int start;
    private final int end;

    public RangeIntSet(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("start must be greater or equal to end: " + end + " not >= " + start);
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.end == this.start;
    }

    @Override
    public boolean containsInt(int o) {
        return o >= this.start && o < this.end;
    }

    @Override
    public IntIterator iterator() {
        return new AbstractIntIterator(){
            int next;
            {
                this.next = RangeIntSet.this.start;
            }

            public boolean hasNext() {
                return this.next < RangeIntSet.this.end;
            }

            public int nextInt() {
                if (this.next >= RangeIntSet.this.end) {
                    throw new NoSuchElementException();
                }
                int cur = this.next++;
                return cur;
            }

            public void remove() {
                throw new UnsupportedOperationException("unmodifiable set");
            }
        };
    }

    @Override
    protected <T> T[] toArrayInternal(T[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int index = 0;
        int i = this.start;
        while (i < this.end) {
            arr[index++] = i;
            ++i;
        }
        return arr;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public boolean addInt(int value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public boolean removeInt(int value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    protected int[] toIntArrayInternal(int[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = new int[size];
        }
        int index = 0;
        int i = this.start;
        while (i < this.end) {
            arr[index++] = i++;
        }
        return arr;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public int firstInt() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.start;
    }

    @Override
    public int lastInt() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.end - 1;
    }

    @Override
    public RangeIntSet subSet(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("to must be greater or equal to from: " + to + " not >= " + from);
        }
        int newStart = this.start + from;
        int newEnd = this.start + to;
        if (!this.containsInt(newStart)) {
            throw new IndexOutOfBoundsException("from index out of range: " + from);
        }
        if (!this.containsInt(newEnd)) {
            throw new IndexOutOfBoundsException("to index out of range: " + to);
        }
        return new RangeIntSet(newStart, newEnd);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RangeIntSet) {
            RangeIntSet rs = (RangeIntSet)obj;
            return this.start == rs.start && this.end == rs.end;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.start ^ this.end;
    }

    @Override
    public String toString() {
        return "[" + this.start + ".." + (this.end - 1) + "]";
    }
}

