/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.Arrays;
import ch.javasoft.util.ints.AbstractIntIntMap;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntCollections;
import ch.javasoft.util.ints.IntIntMap;
import ch.javasoft.util.ints.IntMap;
import ch.javasoft.util.ints.IntSet;
import ch.javasoft.util.ints.RangeIntSet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyRangeIntIntMap
extends AbstractIntIntMap
implements Serializable {
    private static final long serialVersionUID = -9111876887151093531L;
    private final int[] mapping;

    public KeyRangeIntIntMap(int size) {
        this.mapping = new int[size];
        int i = 0;
        while (i < size) {
            this.mapping[i] = i;
            ++i;
        }
    }

    public KeyRangeIntIntMap(int[] mapping) {
        this.mapping = mapping;
    }

    @Override
    public int getInt(int key) {
        if (this.containsKey(key)) {
            return this.mapping[key];
        }
        throw new NoSuchElementException("no such key: " + key);
    }

    @Override
    public boolean containsKey(int key) {
        return key >= 0 && key < this.mapping.length;
    }

    @Override
    public boolean containsValue(int value) {
        int i = 0;
        while (i < this.mapping.length) {
            if (this.mapping[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.mapping.length == 0;
    }

    @Override
    public int size() {
        return this.mapping.length;
    }

    @Override
    public IntSet keySet() {
        return new RangeIntSet(0, this.mapping.length);
    }

    @Override
    public Set<IntIntMap.IntIntEntry> intIntEntrySet() {
        return new AbstractSet<IntIntMap.IntIntEntry>(){

            @Override
            public Iterator<IntIntMap.IntIntEntry> iterator() {
                return new Iterator<IntIntMap.IntIntEntry>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < KeyRangeIntIntMap.this.mapping.length;
                    }

                    @Override
                    public IntIntMap.IntIntEntry next() {
                        if (this.index >= KeyRangeIntIntMap.this.mapping.length) {
                            throw new NoSuchElementException();
                        }
                        int cur = this.index++;
                        return new AbstractIntIntMap.SimpleIntIntEntry(cur, KeyRangeIntIntMap.this.mapping[cur]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return KeyRangeIntIntMap.this.mapping.length;
            }

            @Override
            public boolean isEmpty() {
                return KeyRangeIntIntMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Integer value = KeyRangeIntIntMap.this.get(entry.getKey());
                    return value != null && value.equals(entry.getValue());
                }
                return false;
            }
        };
    }

    @Override
    public IntCollection values() {
        return IntCollections.unmodifiableCollection(new DefaultIntList(this.mapping));
    }

    public int[] toArray() {
        return Arrays.copyOf(this.mapping, this.mapping.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            return java.util.Arrays.equals(this.mapping, ((KeyRangeIntIntMap)o).mapping);
        }
        return super.equals(o);
    }

    @Override
    public Integer put(int key, Integer value) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public Integer put(int key, int value) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public Integer put(Integer key, Integer value) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public void putAll(IntMap<? extends Integer> map) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public void putAll(IntIntMap map) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public Integer remove(int key) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException("unmodifiable map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("unmodifiable map");
    }
}

