/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.concurrent;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentBitSet {
    private static final int BITS_PER_UNIT = 64;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile AtomicLongArray units;

    public ConcurrentBitSet() {
        this(64);
    }

    public ConcurrentBitSet(int bitCapacity) {
        this.units = new AtomicLongArray(1 + (bitCapacity - 1) / 64);
    }

    public ConcurrentBitSet(BitSet bitSet) {
        this(bitSet.length());
        int bit = bitSet.nextSetBit(0);
        while (bit >= 0) {
            this.set(bit);
            bit = bitSet.nextSetBit(bit + 1);
        }
    }

    public ConcurrentBitSet(String bitString) {
        this(bitString.length());
        int ii = 0;
        while (ii < bitString.length()) {
            if (bitString.charAt(ii) == '1') {
                this.set(ii);
            }
            ++ii;
        }
    }

    private ConcurrentBitSet(AtomicLongArray array) {
        this.units = array;
    }

    private void ensureCapacityAndAquireReadLock(int unitLen) {
        while (true) {
            this.lock.readLock().lock();
            if (this.units.length() >= unitLen) {
                return;
            }
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.units.length() > unitLen) continue;
                AtomicLongArray newUnits = new AtomicLongArray(unitLen);
                int i = 0;
                while (i < this.units.length()) {
                    newUnits.set(i, this.units.get(i));
                    ++i;
                }
                this.units = newUnits;
                continue;
            }
            finally {
                this.lock.writeLock().unlock();
                continue;
            }
            break;
        }
    }

    public void set(int bit, boolean value) {
        if (value) {
            this.set(bit);
        } else {
            this.clear(bit);
        }
    }

    public void set(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacityAndAquireReadLock(unit + 1);
        try {
            long old = this.units.get(unit);
            long upd = old | mask;
            while (!this.units.compareAndSet(unit, old, upd)) {
                old = this.units.get(unit);
                upd = old | mask;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean compareAndSet(int bit, boolean expect, boolean update) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        if (!expect && update) {
            this.ensureCapacityAndAquireReadLock(unit + 1);
        } else {
            this.lock.readLock().lock();
        }
        try {
            if (unit >= this.units.length()) {
                if (expect) {
                    return false;
                }
                if (!update) {
                    return true;
                }
                throw new RuntimeException("internal error: should have sufficient unit length");
            }
            long old = this.units.get(unit);
            boolean cur = 0L != (old & mask);
            while (cur == expect && !this.units.compareAndSet(unit, old, old | mask)) {
                old = this.units.get(unit);
                boolean bl = cur = 0L != (old & mask);
            }
            boolean bl = cur == expect;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.lock.readLock().lock();
        try {
            long old = this.units.get(unit);
            long upd = old | mask;
            while (!this.units.compareAndSet(unit, old, upd)) {
                old = this.units.get(unit);
                upd = old & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.readLock().lock();
        try {
            int i = 0;
            while (i < this.units.length()) {
                this.units.set(i, 0L);
                ++i;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void flip(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.ensureCapacityAndAquireReadLock(unit + 1);
        try {
            long old = this.units.get(unit);
            long upd = old ^ old & mask;
            while (!this.units.compareAndSet(unit, old, upd)) {
                old = this.units.get(unit);
                upd = old ^ old & mask;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean get(int bit) {
        int unit = bit / 64;
        int index = bit % 64;
        long mask = 1L << index;
        this.lock.readLock().lock();
        try {
            if (unit >= this.units.length()) {
                return false;
            }
            boolean bl = 0L != (this.units.get(unit) & mask);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isSubSetOf(ConcurrentBitSet of) {
        if (this == of) {
            return true;
        }
        while (true) {
            this.lock.readLock().lock();
            try {
                int min;
                if (!of.lock.readLock().tryLock()) continue;
                try {
                    min = Math.min(this.units.length(), of.units.length());
                    int ii = 0;
                    while (ii < min) {
                        long myunit = this.units.get(ii);
                        long and = myunit & of.units.get(ii);
                        if (and != myunit) {
                            return false;
                        }
                        ++ii;
                    }
                }
                finally {
                    of.lock.readLock().unlock();
                }
                int i = min;
                while (i < this.units.length()) {
                    if (this.units.get(i) != 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            finally {
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public void and(ConcurrentBitSet with) {
        if (this == with) {
            return;
        }
        while (true) {
            this.lock.readLock().lock();
            try {
                int ii;
                int len;
                if (!with.lock.readLock().tryLock()) continue;
                try {
                    len = Math.min(this.units.length(), with.units.length());
                    ii = 0;
                    while (ii < len) {
                        long old = this.units.get(ii);
                        long upd = old & with.units.get(ii);
                        while (!this.units.compareAndSet(ii, old, upd)) {
                            old = this.units.get(ii);
                            upd = old & with.units.get(ii);
                        }
                        ++ii;
                    }
                }
                finally {
                    with.lock.readLock().unlock();
                }
                ii = len;
                while (ii < this.units.length()) {
                    this.units.set(ii, 0L);
                    ++ii;
                }
                return;
            }
            finally {
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public void or(ConcurrentBitSet with) {
        if (this == with) {
            return;
        }
        while (true) {
            int withLength;
            with.lock.readLock().lock();
            try {
                withLength = with.units.length();
            }
            finally {
                with.lock.readLock().lock();
            }
            this.ensureCapacityAndAquireReadLock(withLength);
            try {
                if (!with.lock.readLock().tryLock()) continue;
                try {
                    int len = with.units.length();
                    if (this.units.length() >= len) {
                        int i = 0;
                        while (i < len) {
                            long old = this.units.get(i);
                            long upd = old | with.units.get(i);
                            while (!this.units.compareAndSet(i, old, upd)) {
                                old = this.units.get(i);
                                upd = old | with.units.get(i);
                            }
                            ++i;
                        }
                        return;
                    }
                }
                finally {
                    with.lock.readLock().unlock();
                }
                {
                }
            }
            finally {
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public void xor(ConcurrentBitSet with) {
        while (true) {
            int withLength;
            with.lock.readLock().lock();
            try {
                withLength = with.units.length();
            }
            finally {
                with.lock.readLock().lock();
            }
            this.ensureCapacityAndAquireReadLock(withLength);
            try {
                if (!with.lock.readLock().tryLock()) continue;
                try {
                    int len = with.units.length();
                    if (this.units.length() >= len) {
                        int i = 0;
                        while (i < len) {
                            long old = this.units.get(i);
                            long upd = old ^ with.units.get(i);
                            while (!this.units.compareAndSet(i, old, upd)) {
                                old = this.units.get(i);
                                upd = old ^ with.units.get(i);
                            }
                            ++i;
                        }
                        return;
                    }
                }
                finally {
                    with.lock.readLock().unlock();
                }
                {
                }
            }
            finally {
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public void andNot(ConcurrentBitSet with) {
        while (true) {
            this.lock.readLock().lock();
            try {
                if (!with.lock.readLock().tryLock()) continue;
                try {
                    int len = Math.min(this.units.length(), with.units.length());
                    int ii = 0;
                    while (ii < len) {
                        long old = this.units.get(ii);
                        long upd = old & (with.units.get(ii) ^ 0xFFFFFFFFFFFFFFFFL);
                        while (!this.units.compareAndSet(ii, old, upd)) {
                            old = this.units.get(ii);
                            upd = old & (with.units.get(ii) ^ 0xFFFFFFFFFFFFFFFFL);
                        }
                        ++ii;
                    }
                    with.lock.readLock().unlock();
                    return;
                }
                catch (Throwable throwable) {
                    with.lock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public static ConcurrentBitSet getXor(ConcurrentBitSet setA, ConcurrentBitSet setB) {
        while (true) {
            setA.lock.readLock().lock();
            try {
                if (!setB.lock.readLock().tryLock()) continue;
                try {
                    int lenA = setA.units.length();
                    int lenB = setA.units.length();
                    int lMin = Math.min(lenA, lenB);
                    int lMax = Math.max(lenA, lenB);
                    AtomicLongArray arr = new AtomicLongArray(lMax);
                    int i = 0;
                    while (i < lMin) {
                        arr.set(i, setA.units.get(i) ^ setB.units.get(i));
                        ++i;
                    }
                    i = lMin;
                    while (i < lenA) {
                        arr.set(i, setA.units.get(i));
                        ++i;
                    }
                    i = lMin;
                    while (i < lenB) {
                        arr.set(i, setB.units.get(i));
                        ++i;
                    }
                    ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(arr);
                    setB.lock.readLock().unlock();
                    return concurrentBitSet;
                }
                catch (Throwable throwable) {
                    setB.lock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                setA.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public static ConcurrentBitSet getOr(ConcurrentBitSet setA, ConcurrentBitSet setB) {
        while (true) {
            setA.lock.readLock().lock();
            try {
                if (!setB.lock.readLock().tryLock()) continue;
                try {
                    int lenA = setA.units.length();
                    int lenB = setA.units.length();
                    int lMin = Math.min(lenA, lenB);
                    int lMax = Math.max(lenA, lenB);
                    AtomicLongArray arr = new AtomicLongArray(lMax);
                    int i = 0;
                    while (i < lMin) {
                        arr.set(i, setA.units.get(i) | setB.units.get(i));
                        ++i;
                    }
                    i = lMin;
                    while (i < lenA) {
                        arr.set(i, setA.units.get(i));
                        ++i;
                    }
                    i = lMin;
                    while (i < lenB) {
                        arr.set(i, setB.units.get(i));
                        ++i;
                    }
                    ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(arr);
                    setB.lock.readLock().unlock();
                    return concurrentBitSet;
                }
                catch (Throwable throwable) {
                    setB.lock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                setA.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public static ConcurrentBitSet getAnd(ConcurrentBitSet setA, ConcurrentBitSet setB) {
        while (true) {
            setA.lock.readLock().lock();
            try {
                if (!setB.lock.readLock().tryLock()) continue;
                try {
                    int lenA = setA.units.length();
                    int lenB = setA.units.length();
                    int lMin = Math.min(lenA, lenB);
                    AtomicLongArray arr = new AtomicLongArray(lMin);
                    int i = 0;
                    while (i < lMin) {
                        arr.set(i, setA.units.get(i) & setB.units.get(i));
                        ++i;
                    }
                    ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(arr);
                    setB.lock.readLock().unlock();
                    return concurrentBitSet;
                }
                catch (Throwable throwable) {
                    setB.lock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                setA.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public static ConcurrentBitSet getAndNot(ConcurrentBitSet setA, ConcurrentBitSet setB) {
        while (true) {
            setA.lock.readLock().lock();
            try {
                if (!setB.lock.readLock().tryLock()) continue;
                try {
                    int lenA = setA.units.length();
                    int lenB = setA.units.length();
                    int lMin = Math.min(lenA, lenB);
                    AtomicLongArray arr = new AtomicLongArray(lMin);
                    int i = 0;
                    while (i < lMin) {
                        arr.set(i, setA.units.get(i) & (setB.units.get(i) ^ 0xFFFFFFFFFFFFFFFFL));
                        ++i;
                    }
                    ConcurrentBitSet concurrentBitSet = new ConcurrentBitSet(arr);
                    setB.lock.readLock().unlock();
                    return concurrentBitSet;
                }
                catch (Throwable throwable) {
                    setB.lock.readLock().unlock();
                    throw throwable;
                }
            }
            finally {
                setA.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public int length() {
        int index;
        long last = 0L;
        this.lock.readLock().lock();
        try {
            index = this.units.length();
            while (--index >= 0) {
                last = this.units.get(index);
                if (0L == last) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return index < 0 ? 0 : index * 64 + ConcurrentBitSet.bitLenL(last);
    }

    private static int bitLenL(long l) {
        int high = (int)(l >>> 32);
        int low = (int)l;
        return high == 0 ? ConcurrentBitSet.bitLenI(low) : 32 + ConcurrentBitSet.bitLenI(high);
    }

    private static int bitLenI(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        int index;
        this.lock.readLock().lock();
        try {
            index = this.units.length();
            while (--index >= 0) {
                if (0L == this.units.get(index)) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return index < 0;
    }

    public ConcurrentBitSet clone() {
        AtomicLongArray arr;
        this.lock.readLock().lock();
        try {
            int len = this.units.length();
            arr = new AtomicLongArray(len);
            int i = 0;
            while (i < len) {
                arr.set(i, this.units.get(i));
                ++i;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return new ConcurrentBitSet(arr);
    }

    public int cardinality() {
        this.lock.readLock().lock();
        try {
            int card = 0;
            int len = this.units.length();
            int i = 0;
            while (i < len) {
                card += Long.bitCount(this.units.get(i));
                ++i;
            }
            int n = card;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int cardinality(int fromBit, int toBit) {
        int fromUnit = fromBit / 64;
        int toUnit = (toBit + 64 - 1) / 64;
        this.lock.readLock().lock();
        try {
            int unitStart = Math.max(0, fromUnit);
            int unitLen = Math.min(this.units.length(), toUnit);
            int card = 0;
            int ii = unitStart;
            while (ii < unitLen) {
                long unit = this.units.get(ii);
                if (unit != 0L) {
                    int bit;
                    if (ii == fromUnit) {
                        bit = fromBit % 64;
                        unit &= -1L >>> bit;
                    }
                    if (ii == toUnit - 1) {
                        bit = fromBit % 64;
                        unit &= -1L << 64 - bit;
                    }
                    card += Long.bitCount(unit);
                }
                ++ii;
            }
            int n = card;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int hashCode() {
        this.lock.readLock().lock();
        try {
            int code = 0;
            int len = this.units.length();
            int i = 0;
            while (i < len) {
                long unit = this.units.get(i);
                code = (int)((long)code ^ 0xFFFFFFFFL & unit);
                code = (int)((long)code ^ 0xFFFFFFFFL & unit >>> 32);
                ++i;
            }
            int n = code;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean equals(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.lock.readLock().lock();
        try {
            int unitLen = this.units.length();
            int ii = 0;
            while (ii < unitLen) {
                int len = ii == unitLen - 1 ? 1 + (this.length() - 1) % 64 : 64;
                long unit = this.units.get(ii);
                if (unit != 0L) {
                    long bit = 1L;
                    int jj = 0;
                    while (jj < len) {
                        if ((unit & bit) != 0L) {
                            sb.append('1');
                        } else {
                            sb.append('0');
                        }
                        ++jj;
                        bit <<= 1;
                    }
                } else {
                    sb.append("0000000000000000000000000000000000000000000000000000000000000000", 0, len);
                }
                ++ii;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        sb.append('}');
        return sb.toString();
    }

    public int nextSetBit(int from) {
        int fromBit = from % 64;
        int fromUnit = from / 64;
        this.lock.readLock().lock();
        try {
            int len = this.units.length();
            int ii = Math.max(0, fromUnit);
            while (ii < len) {
                long unit = this.units.get(ii);
                if (unit != 0L) {
                    if (ii == fromUnit) {
                        unit &= -1L << fromBit;
                    }
                    if (unit != 0L) {
                        int n = ii * 64 + Long.numberOfTrailingZeros(unit);
                        return n;
                    }
                }
                ++ii;
            }
            return -1;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int nextClearBit(int from) {
        int fromBit = from % 64;
        int fromUnit = from / 64;
        this.lock.readLock().lock();
        try {
            int len = this.units.length();
            int ii = fromUnit;
            while (ii < len) {
                long unit = this.units.get(ii);
                if (unit != -1L) {
                    if (ii == fromUnit) {
                        unit &= -1L << fromBit;
                    }
                    if (unit != 0L) {
                        int n = ii * 64 + Long.numberOfTrailingZeros(unit);
                        return n;
                    }
                }
                ++ii;
            }
            int n = Math.max(from, this.length());
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.length());
        int bit = this.nextSetBit(0);
        while (bit >= 0) {
            bitSet.set(bit);
            bit = this.nextSetBit(bit + 1);
        }
        return bitSet;
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutput dout = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
        this.lock.readLock().lock();
        try {
            int len = this.units.length();
            dout.writeInt(len);
            int i = 0;
            while (i < len) {
                dout.writeLong(this.units.get(i));
                ++i;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static ConcurrentBitSet readFrom(InputStream in) throws IOException {
        DataInput din = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        int len = din.readInt();
        AtomicLongArray arr = new AtomicLongArray(len);
        int i = 0;
        while (i < len) {
            arr.set(i, din.readLong());
            ++i;
        }
        return new ConcurrentBitSet(arr);
    }

    public long[] toLongArray() {
        return this.toLongArray(null, 0);
    }

    public long[] toLongArray(long[] arr, int offset) {
        this.lock.readLock().lock();
        try {
            int len = this.units.length();
            if (arr == null || arr.length < len + offset) {
                arr = new long[len + offset];
            }
            int i = 0;
            while (i < len) {
                arr[i] = this.units.get(i);
                ++i;
            }
            long[] lArray = arr;
            return lArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static void main(String[] args) {
        System.out.println(new ConcurrentBitSet("00001111").nextClearBit(0));
        System.out.println(new ConcurrentBitSet("00001111").nextClearBit(1));
        System.out.println(new ConcurrentBitSet("00001111").nextClearBit(2));
        System.out.println(new ConcurrentBitSet("00001111").nextClearBit(3));
        System.out.println(new ConcurrentBitSet("00001111").nextClearBit(4));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(0));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(1));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(2));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(3));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(4));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(7));
        System.out.println(new ConcurrentBitSet("00001111").nextSetBit(8));
        System.out.println(new ConcurrentBitSet("01010101010101010101"));
        System.out.println(new ConcurrentBitSet("11111111000000001111000000001111"));
        System.out.println(new ConcurrentBitSet("1111111100000000111100000000111111111111000000001111000000001111"));
        System.out.println(ConcurrentBitSet.getAnd(new ConcurrentBitSet("111100001111"), new ConcurrentBitSet("110011110101")));
        System.out.println(ConcurrentBitSet.getAnd(new ConcurrentBitSet("111100001111111100001111111100001111111100001111111100001111111100001111111100001111111100001111111100001111111100001111111100001111111100001111"), new ConcurrentBitSet("110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101110011110101")));
        ConcurrentBitSet set = new ConcurrentBitSet("1111111100000000111100000000111111111111000000001111000000001111");
        set.clear(3);
        System.out.println(set);
        set.clear(0);
        System.out.println(set);
        set = new ConcurrentBitSet("10000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000001");
        System.out.println(set);
        set.clear(63);
        System.out.println(set);
        set.clear(64);
        System.out.println(set);
        set.clear(127);
        System.out.println(set);
        set.clear(0);
        System.out.println(set);
        set.set(63);
        System.out.println(set);
        set.set(64);
        System.out.println(set);
        set.set(127);
        System.out.println(set);
        set.set(0);
        System.out.println(set);
    }
}

