/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtil {
    public static RuntimeException toRuntimeException(Throwable throwable) throws Error {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    public static <T extends Throwable> T toRuntimeExceptionOr(Class<T> exClass, Throwable throwable) throws Error, RuntimeException {
        if (exClass.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static IOException toIOException(String msg, Throwable cause) {
        IOException ex = new IOException(msg);
        ex.initCause(cause);
        return ex;
    }

    public static IOException toIOException(Throwable cause) {
        IOException ex = new IOException(cause.toString());
        ex.initCause(cause);
        return ex;
    }

    private ExceptionUtil() {
    }
}

