/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.sscc;

import ch.javasoft.smx.exception.SingularMatrixException;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.ext.ExternalOpsImpl;
import ch.javasoft.smx.ops.sscc.Convert;
import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.RealMatrix;
import ru.sscc.matrix.solve.CrautSolver;
import ru.sscc.matrix.solve.RealCommonSolver;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.matrix.solve.RotationSolver;
import ru.sscc.util.CalculatingException;

public class SsccOpsImpl
extends ExternalOpsImpl {
    public DoubleMatrix nullspace(ReadableDoubleMatrix src) {
        DenseMatrix extSrc = Convert.toExternal(src);
        DenseMatrix extNull = this.factorizeCommon(extSrc).getNullSpace();
        return extNull == null ? new DefaultDoubleMatrix(0, src.getColumnCount()) : Convert.fromExternal((RealMatrix)extNull);
    }

    public int nullity(ReadableDoubleMatrix src) {
        DenseMatrix extSrc = Convert.toExternal(src);
        return this.factorizeCommon(extSrc).getNullSpaceRange();
    }

    public int rank(ReadableDoubleMatrix src) {
        DenseMatrix extSrc = Convert.toExternal(src);
        return this.factorizeCommon(extSrc).getMatrixRange();
    }

    public DoubleMatrix invert(ReadableDoubleMatrix src) {
        DenseMatrix extSrc = Convert.toExternal(src);
        DenseMatrix extCln = (DenseMatrix)extSrc.clone();
        DenseMatrix extInv = this.factorize(extSrc).constructRefinedInverse((RealMatrix)extCln, null);
        return Convert.fromExternal((RealMatrix)extInv);
    }

    private RealCommonSolver factorizeCommon(DenseMatrix matrix) {
        RotationSolver solver = new RotationSolver(matrix);
        try {
            solver.factorize();
        }
        catch (CalculatingException calculatingException) {
            // empty catch block
        }
        return solver;
    }

    private RealSquareSolver factorize(DenseMatrix matrix) {
        CrautSolver solver = new CrautSolver(matrix);
        try {
            solver.factorize();
        }
        catch (CalculatingException ex) {
            ex.printStackTrace();
            throw new SingularMatrixException(0);
        }
        return solver;
    }
}

