/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVector<N extends Number>
implements ReadableVector<N>,
WritableVector<N> {
    private final boolean mIsColumnVector;

    public AbstractVector(boolean columnVector) {
        this.mIsColumnVector = columnVector;
    }

    @Override
    public boolean isColumnVector() {
        return this.mIsColumnVector;
    }

    @Override
    public boolean isRowVector() {
        return !this.mIsColumnVector;
    }

    protected int getIndexForMatrixAccess(int row, int col) {
        if (this.isRowVector()) {
            if (row != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + row);
            }
            return col;
        }
        if (col != 0) {
            throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + col);
        }
        return row;
    }

    @Override
    public int getColumnCount() {
        return this.isRowVector() ? this.getSize() : 1;
    }

    @Override
    public int getRowCount() {
        return this.isColumnVector() ? this.getSize() : 1;
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        if (this.isRowVector()) {
            if (rowA != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + rowA);
            }
            if (rowB != 0) {
                throw new IndexOutOfBoundsException("row vector, row index must be 0, but was " + rowB);
            }
            return;
        }
        this.swapValues(rowA, rowB);
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (this.isColumnVector()) {
            if (colA != 0) {
                throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + colA);
            }
            if (colB != 0) {
                throw new IndexOutOfBoundsException("column vector, column index must be 0, but was " + colB);
            }
            return;
        }
        this.swapValues(colA, colB);
    }

    @Override
    public abstract AbstractVector<N> transpose();

    @Override
    public abstract AbstractVector<N> clone();
}

