/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.DoubleOperations;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.matrix.DoubleMatrixOperations;
import ch.javasoft.util.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleMatrix
implements DoubleMatrix {
    private static final String NL = StringUtil.LINE_SEPARATOR;

    public DoubleOperations getNumberOperations() {
        return DoubleOperations.instance();
    }

    @Override
    public MatrixOperations<Double> getMatrixOperations() {
        return DoubleMatrixOperations.instance();
    }

    @Override
    public void setValueAt(int row, int col, long value) {
        this.setValueAt(row, col, (double)value);
    }

    @Override
    public void setValueAt(int row, int col, Double value) {
        this.setValueAt(row, col, (double)value);
    }

    @Override
    public void setValueAt(int row, int col, int value) {
        this.setValueAt(row, col, (double)value);
    }

    @Override
    public void setValueAt(int row, int col, BigInteger value) {
        this.setValueAt(row, col, value.doubleValue());
    }

    @Override
    public void setValueAt(int row, int col, BigInteger dividend, BigInteger divisor) {
        this.setValueAt(row, col, BigFraction.toDouble(dividend, divisor));
    }

    @Override
    public void setValueAt(int row, int col, BigFraction value) {
        this.setValueAt(row, col, value.getNumerator(), value.getDenominator());
    }

    @Override
    public void setValueAt(int row, int col, long dividend, long divisor) {
        this.setValueAt(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public void setValueAt(int row, int col, int dividend, int divisor) {
        this.setValueAt(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public Double getNumberValueAt(int row, int col) {
        return this.getDoubleValueAt(row, col);
    }

    @Override
    public int getSignumAt(int row, int col) {
        double val = this.getDoubleValueAt(row, col);
        return val == 0.0 ? 0 : (val < 0.0 ? -1 : 1);
    }

    @Override
    public double[] toDoubleArray() {
        double[] array = new double[this.getRowCount() * this.getColumnCount()];
        AbstractDoubleMatrix.toArray(this, array);
        return array;
    }

    @Override
    public void toArray(double[] array) {
        AbstractDoubleMatrix.toArray(this, array);
    }

    public static void toArray(ReadableDoubleMatrix mx, double[] array) {
        int cols;
        int rows = mx.getRowCount();
        if (array.length != rows * (cols = mx.getColumnCount())) {
            throw new IllegalArgumentException("expected array length " + rows * cols + " but found " + array.length);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                array[row * cols + col] = mx.getDoubleValueAt(row, col);
                ++col;
            }
            ++row;
        }
    }

    public DoubleMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toDoubleMatrix(enforceNewInstance);
    }

    public DoubleMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toDoubleMatrix(enforceNewInstance);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        return AbstractDoubleMatrix.getDoubleColumn(this, col);
    }

    public static double[] getDoubleColumn(ReadableDoubleMatrix mx, int col) {
        int rows = mx.getRowCount();
        double[] res = new double[rows];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getDoubleValueAt(row, col);
            ++row;
        }
        return res;
    }

    public Double[][] getNumberRows() {
        return AbstractDoubleMatrix.getNumberRows(this);
    }

    public static Double[][] getNumberRows(ReadableDoubleMatrix mx) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        Double[][] data = new Double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                data[row][col] = mx.getDoubleValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return data;
    }

    @Override
    public double[] getDoubleRow(int row) {
        return AbstractDoubleMatrix.getDoubleRow(this, row);
    }

    public static double[] getDoubleRow(ReadableDoubleMatrix mx, int row) {
        int cols = mx.getColumnCount();
        double[] res = new double[cols];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getDoubleValueAt(row, col);
            ++col;
        }
        return res;
    }

    @Override
    public double[][] getDoubleColumns() {
        return AbstractDoubleMatrix.getDoubleColumns(this);
    }

    public static double[][] getDoubleColumns(ReadableDoubleMatrix mx) {
        int cols = mx.getColumnCount();
        double[][] res = new double[cols][];
        int col = 0;
        while (col < cols) {
            res[col] = mx.getDoubleColumn(col);
            ++col;
        }
        return res;
    }

    @Override
    public double[][] getDoubleRows() {
        return AbstractDoubleMatrix.getDoubleRows(this);
    }

    public static double[][] getDoubleRows(ReadableDoubleMatrix mx) {
        int rows = mx.getRowCount();
        double[][] res = new double[rows][];
        int row = 0;
        while (row < rows) {
            res[row] = mx.getDoubleRow(row);
            ++row;
        }
        return res;
    }

    @Override
    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                double tmp = this.getDoubleValueAt(row, colA);
                this.setValueAt(row, colA, this.getDoubleValueAt(row, colB));
                this.setValueAt(row, colB, tmp);
                ++row;
            }
        }
    }

    @Override
    public String toString() {
        return AbstractDoubleMatrix.toString(this);
    }

    @Override
    public void writeTo(Writer writer) {
        AbstractDoubleMatrix.writeTo(writer, (ReadableDoubleMatrix)this);
    }

    @Override
    public void writeTo(OutputStream out) {
        AbstractDoubleMatrix.writeTo(out, (ReadableDoubleMatrix)this);
    }

    public static String toString(ReadableDoubleMatrix mx) {
        return AbstractDoubleMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableDoubleMatrix mx) {
        AbstractDoubleMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableDoubleMatrix mx) {
        AbstractDoubleMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    @Override
    public String toMultilineString() {
        return AbstractDoubleMatrix.toMultilineString(this);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        AbstractDoubleMatrix.writeToMultiline(writer, (ReadableDoubleMatrix)this);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        AbstractDoubleMatrix.writeToMultiline(out, (ReadableDoubleMatrix)this);
    }

    public static String toMultilineString(ReadableDoubleMatrix mx) {
        return AbstractDoubleMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableDoubleMatrix mx) {
        String sizeStr = String.valueOf(mx.getRowCount()) + "x" + mx.getColumnCount();
        AbstractDoubleMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, String.valueOf(sizeStr) + " {" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableDoubleMatrix mx) {
        String sizeStr = String.valueOf(mx.getRowCount()) + "x" + mx.getColumnCount();
        AbstractDoubleMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, String.valueOf(sizeStr) + " {" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableDoubleMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        AbstractDoubleMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableDoubleMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getDoubleValueAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    @Override
    public abstract AbstractDoubleMatrix clone();

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    @Override
    public void addRowToOtherRow(int srcRow, BigInteger srcFactor, int dstRow, BigInteger dstFactor) {
        this.addRowToOtherRow(srcRow, srcFactor.doubleValue(), dstRow, dstFactor.doubleValue());
    }

    @Override
    public void addRowToOtherRow(int srcRow, double srcFactor, int dstRow, double dstFactor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.setValueAt(dstRow, col, dstFactor * this.getDoubleValueAt(dstRow, col) + srcFactor * this.getDoubleValueAt(srcRow, col));
            ++col;
        }
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcFactor, int dstRow, long dstFactor) {
        this.addRowToOtherRow(srcRow, (double)srcFactor, dstRow, (double)dstFactor);
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        this.addRowToOtherRow(srcRow, (double)srcFactor, dstRow, (double)dstFactor);
    }

    @Override
    public void addRowToOtherRow(int srcRow, BigInteger srcDividend, BigInteger srcDivisor, int dstRow, BigInteger dstDividend, BigInteger dstDivisor) {
        double srcFactor = BigFraction.toDouble(srcDividend, srcDivisor);
        double dstFactor = BigFraction.toDouble(dstDividend, dstDivisor);
        this.addRowToOtherRow(srcRow, srcFactor, dstRow, dstFactor);
    }

    @Override
    public void addRowToOtherRow(int srcRow, long srcDividend, long srcDivisor, int dstRow, long dstDividend, long dstDivisor) {
        this.addRowToOtherRow(srcRow, (double)srcDividend / (double)srcDivisor, dstRow, (double)dstDividend / (double)dstDivisor);
    }

    @Override
    public void addRowToOtherRow(int srcRow, int srcDividend, int srcDivisor, int dstRow, int dstDividend, int dstDivisor) {
        this.addRowToOtherRow(srcRow, (double)srcDividend / (double)srcDivisor, dstRow, (double)dstDividend / (double)dstDivisor);
    }

    @Override
    public void add(int row, int col, double value) {
        this.setValueAt(row, col, this.getDoubleValueAt(row, col) + value);
    }

    @Override
    public void add(int row, int col, BigInteger value) {
        this.add(row, col, value.doubleValue());
    }

    @Override
    public void add(int row, int col, long value) {
        this.add(row, col, (double)value);
    }

    @Override
    public void add(int row, int col, int value) {
        this.add(row, col, (double)value);
    }

    @Override
    public void add(int row, int col, int dividend, int divisor) {
        this.add(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public void add(int row, int col, long dividend, long divisor) {
        this.add(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public void add(int row, int col, BigInteger dividend, BigInteger divisor) {
        this.add(row, col, BigFraction.toDouble(dividend, divisor));
    }

    @Override
    public void multiply(int row, int col, double factor) {
        this.setValueAt(row, col, factor * this.getDoubleValueAt(row, col));
    }

    @Override
    public void multiply(int row, int col, BigInteger factor) {
        this.multiply(row, col, factor.doubleValue());
    }

    @Override
    public void multiply(int row, int col, long factor) {
        this.multiply(row, col, (double)factor);
    }

    @Override
    public void multiply(int row, int col, int factor) {
        this.multiply(row, col, (double)factor);
    }

    @Override
    public void multiply(int row, int col, BigInteger dividend, BigInteger divisor) {
        this.multiply(row, col, BigFraction.toDouble(dividend, divisor));
    }

    @Override
    public void multiply(int row, int col, long dividend, long divisor) {
        this.multiply(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public void multiply(int row, int col, int dividend, int divisor) {
        this.multiply(row, col, (double)dividend / (double)divisor);
    }

    @Override
    public void multiplyRow(int row, BigInteger factor) {
        this.multiplyRow(row, factor.doubleValue());
    }

    @Override
    public void multiplyRow(int row, long factor) {
        this.multiplyRow(row, (double)factor);
    }

    @Override
    public void multiplyRow(int row, int factor) {
        this.multiplyRow(row, (double)factor);
    }

    @Override
    public void multiplyRow(int row, BigInteger dividend, BigInteger divisor) {
        this.multiplyRow(row, BigFraction.toDouble(dividend, divisor));
    }

    @Override
    public void multiplyRow(int row, long dividend, long divisor) {
        this.multiplyRow(row, (double)dividend / (double)divisor);
    }

    @Override
    public void multiplyRow(int row, int dividend, int divisor) {
        this.multiplyRow(row, (double)dividend / (double)divisor);
    }

    @Override
    public void multiplyRow(int row, double factor) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.multiply(row, col, factor);
            ++col;
        }
    }

    public int hashCode() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int value = rows ^ cols;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long bits = Double.doubleToRawLongBits(this.getDoubleValueAt(row, col));
                value ^= (int)(bits >> 32) ^ (int)(bits & 0xFFFFFFFFL);
                ++col;
            }
            ++row;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DoubleMatrix) {
            return AbstractDoubleMatrix.equals(this, (DoubleMatrix)obj, 0.0);
        }
        return false;
    }

    public boolean equals(DoubleMatrix other, double toleration) {
        return AbstractDoubleMatrix.equals(this, other, toleration);
    }

    public static boolean equals(DoubleMatrix mxA, DoubleMatrix mxB, double toleration) {
        if (mxA == mxB) {
            return true;
        }
        if (mxA == null || mxB == null) {
            return false;
        }
        int rows = mxA.getRowCount();
        if (rows != mxB.getRowCount()) {
            return false;
        }
        int cols = mxA.getColumnCount();
        if (cols != mxB.getColumnCount()) {
            return false;
        }
        toleration = Math.abs(toleration);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double delta = mxA.getDoubleValueAt(row, col) - mxB.getDoubleValueAt(row, col);
                if (Math.abs(delta) > toleration) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        DefaultDoubleMatrix res = new DefaultDoubleMatrix(rowEnd - rowStart, colEnd - colStart);
        int row = 0;
        while (row < res.getRowCount()) {
            int col = 0;
            while (col < res.getColumnCount()) {
                res.setValueAt(row, col, this.getDoubleValueAt(rowStart + row, colStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    @Override
    public void negate(int row, int col) {
        this.setValueAt(row, col, -this.getDoubleValueAt(row, col));
    }

    @Override
    public abstract AbstractDoubleMatrix transpose();
}

