/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.polco.Numeric;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.NumericFactory;
import ch.javasoft.polco.config.Phase;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.parse.InputStreamParser;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.StreamConfigParser;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import ch.javasoft.xml.factory.XmlConfiguredFactory;
import java.io.InputStream;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamParserFactory
implements NumericFactory {
    private final InputStreamParser parser;

    public InputStreamParserFactory(InputStreamParser parser) {
        this.parser = parser;
    }

    @Override
    public <Num extends Number, Arr> XmlConfiguredFactory<? extends Numeric<Num, Arr>> createTypedFactory(final Arithmetic<Num, Arr> arithmetic) {
        return new XmlConfiguredFactory<PolyhedralCone<Num, Arr>>(){

            @Override
            public PolyhedralCone<Num, Arr> create(Element config) throws ConfigException {
                try {
                    Element elInput = XmlUtil.getRequiredSingleChildElement(config, XmlElement.input);
                    Zero zero = PolcoConfig.getZero(config, Phase.Pre);
                    InputStream in = StreamConfigParser.parseInputStream(elInput);
                    return InputStreamParserFactory.this.parser.parse(config, arithmetic, zero, in);
                }
                catch (Exception e) {
                    throw new ConfigException(e, XmlUtil.getElementPath(config, true));
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElement implements XmlNode
    {
        input;


        @Override
        public String getXmlName() {
            return this.name().replaceAll("_", "-");
        }
    }
}

