/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.impl;

import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.impl.AbstractPolyhedralCone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolyhedralCone<Num extends Number, Arr>
extends AbstractPolyhedralCone<Num, Arr>
implements PolyhedralCone<Num, Arr> {
    private final Arr[] mxA;
    private final Arr[] mxB;

    public DefaultPolyhedralCone(LinAlgOperations<Num, Arr> linAlgOps, Arr[] mxA, Arr[] mxB) {
        super(linAlgOps);
        if (this.arrayOps.getColumnCount(mxA) != this.arrayOps.getColumnCount(mxB)) {
            throw new IllegalArgumentException("column size of A and B must be equal: " + this.arrayOps.getColumnCount(mxA) + "!=" + this.arrayOps.getColumnCount(mxB));
        }
        this.mxA = this.normalize(mxA);
        this.mxB = this.normalize(mxB);
    }

    @Override
    public int getDimensions() {
        return this.linAlgOps.getArrayOperations().getColumnCount(this.mxA);
    }

    @Override
    public int getRowCountA() {
        return this.linAlgOps.getArrayOperations().getRowCount(this.mxA);
    }

    @Override
    public Arr[] getA() {
        return this.mxA;
    }

    @Override
    public Num getA(int row, int col) {
        return (Num)this.linAlgOps.getNumberArrayOperations().get(this.mxA, row, col);
    }

    @Override
    public int getRowCountB() {
        return this.linAlgOps.getArrayOperations().getRowCount(this.mxB);
    }

    @Override
    public Arr[] getB() {
        return this.mxB;
    }

    @Override
    public Num getB(int row, int col) {
        return (Num)this.linAlgOps.getNumberArrayOperations().get(this.mxB, row, col);
    }
}

