/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.config;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.factory.FactoryNotFoundException;
import ch.javasoft.factory.FactoryUtil;
import ch.javasoft.factory.IllegalFactoryException;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticFactory;
import ch.javasoft.polco.config.Phase;
import ch.javasoft.polco.config.XmlAttribute;
import ch.javasoft.polco.config.XmlElement;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.logging.SystemProperties;
import ch.javasoft.util.logging.matlab.LogConfiguration;
import ch.javasoft.util.logging.matlab.LogConfigurationReader;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import ch.javasoft.xml.factory.XmlFactoryUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolcoConfig {
    public static final String CONFIG_FILE = "config/polco.xml";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final String DEFAULT_APP_NAME = "polco";
    private static final String HELP_NAME = "polco-help";
    private static final String NOARGS_NAME = "polco-noargs";
    private static final String VERSION_NAME = "polco-version";

    public static Element getPolco(XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        return PolcoConfig.getPolco(xmlConfig.getDefaultConfigElement());
    }

    public static Element getPolco(Document xmlConfig) throws XmlConfigException, DocumentException {
        return PolcoConfig.getPolco(XmlConfig.getXmlConfig(xmlConfig));
    }

    public static Element getPolco(Element xmlConfig) throws XmlConfigException {
        return XmlUtil.getRequiredSingleChildElement(xmlConfig, XmlElement.polco);
    }

    public static Element getPolcoExtremeRayEnum(XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolco(xmlConfig), XmlElement.extreme_ray_enum);
    }

    public static Element getPolcoParse(XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolco(xmlConfig), XmlElement.parse);
    }

    public static Element getPolcoCallback(XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolco(xmlConfig), XmlElement.callback);
    }

    public static Element getPolcoConfig(XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolco(xmlConfig), XmlElement.config);
    }

    public static Element getPolcoConfig(Document xmlConfig) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolco(xmlConfig), XmlElement.config);
    }

    public static Element getPolcoConfigNumeric(XmlConfig xmlConfig, Phase phase) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolcoConfig(xmlConfig), phase.getNumericXmlElement());
    }

    public static Element getPolcoConfigNumeric(Document xmlConfig, Phase phase) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolcoConfig(xmlConfig), phase.getNumericXmlElement());
    }

    public static Element getPolcoConfigNumericArithmetic(XmlConfig xmlConfig, Phase phase) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolcoConfigNumeric(xmlConfig, phase), XmlElement.arithmetic);
    }

    public static Element getPolcoConfigNumericArithmetic(Document xmlConfig, Phase phase) throws XmlConfigException, DocumentException {
        return XmlUtil.getRequiredSingleChildElement(PolcoConfig.getPolcoConfigNumeric(xmlConfig, phase), XmlElement.arithmetic);
    }

    public static Arithmetic getArithmetic(XmlConfig xmlConfig, Phase phase) throws XmlConfigException, DocumentException, InstantiationException, IllegalAccessException, ConfigException, FactoryNotFoundException, IllegalFactoryException {
        Element elArithmetic = PolcoConfig.getPolcoConfigNumericArithmetic(xmlConfig, phase);
        return FactoryUtil.create(Arithmetic.class, ArithmeticFactory.class, elArithmetic);
    }

    public static Arithmetic getArithmetic(Element config, Phase phase) throws XmlConfigException, DocumentException, InstantiationException, IllegalAccessException, ConfigException, FactoryNotFoundException, IllegalFactoryException {
        if (XmlElement.arithmetic.getXmlName().equals(config.getName())) {
            return FactoryUtil.create(Arithmetic.class, ArithmeticFactory.class, config);
        }
        return PolcoConfig.getArithmetic(config.getDocument(), phase);
    }

    public static Arithmetic getArithmetic(Document xmlConfig, Phase phase) throws FactoryNotFoundException, IllegalFactoryException, ConfigException, XmlConfigException, DocumentException {
        Element elArithmetic = PolcoConfig.getPolcoConfigNumericArithmetic(xmlConfig.getDocument(), phase);
        return FactoryUtil.create(Arithmetic.class, ArithmeticFactory.class, elArithmetic);
    }

    public static Zero getZero(XmlConfig xmlConfig, Phase phase) throws XmlConfigException, DocumentException, ConfigException {
        Element elNumeric = PolcoConfig.getPolcoConfigNumeric(xmlConfig, phase);
        Element elZero = XmlUtil.getRequiredSingleChildElement(elNumeric, XmlElement.zero);
        return PolcoConfig.getZero(elZero, phase);
    }

    public static Zero getZero(Element config, Phase phase) throws XmlConfigException, DocumentException, ConfigException {
        if (XmlElement.zero.getXmlName().equals(config.getName())) {
            String strZero = XmlUtil.getRequiredAttributeValue(config, XmlAttribute.value);
            try {
                double tolerance = Double.parseDouble(strZero.trim());
                if (Double.isNaN(tolerance)) {
                    return PolcoConfig.getArithmetic(config, phase).getDefaultZero();
                }
                return new Zero(tolerance);
            }
            catch (Exception e) {
                throw new ConfigException("cannot parse zero value \"" + strZero + "\", e=" + e, e, XmlUtil.getElementPath(config, true));
            }
        }
        return PolcoConfig.getZero(config.getDocument(), phase);
    }

    public static Zero getZero(Document xmlConfig, Phase phase) throws XmlConfigException, DocumentException, ConfigException {
        Element elNumeric = PolcoConfig.getPolcoConfigNumeric(xmlConfig.getDocument(), phase);
        Element elZero = XmlUtil.getRequiredSingleChildElement(elNumeric, XmlElement.zero);
        return PolcoConfig.getZero(elZero, phase);
    }

    public static XmlConfig resolveXmlConfig(String[] args) throws FileNotFoundException, DocumentException, XmlConfigException {
        XmlConfig xmlConfig = PolcoConfig.parseXmlConfig(args);
        try {
            xmlConfig.getDefaultConfigDocument();
        }
        catch (XmlArgException ex) {
            if (ex.isOption()) {
                System.err.println("ERROR:   missing " + ex.getOptionWithIndex() + " option");
            }
            System.err.println("DETAILS: " + ex.getLocalizedMessage());
            ex.printStackTrace();
            System.err.println("use --help option to display help message");
            throw ex;
        }
        catch (MissingReferableException ex) {
            if ("config[default]/metabolic-parse/parse".equals(ex.getPath())) {
                System.err.println("ERROR:   invalid input kind option '" + ex.getReferable() + "'");
            }
            System.err.println("DETAILS: " + ex.getLocalizedMessage());
            System.err.println("use --help option to display help message");
            throw ex;
        }
        catch (XmlConfigException ex) {
            throw ex;
        }
        return xmlConfig;
    }

    public static XmlConfig parseXmlConfig(String[] args) throws FileNotFoundException, DocumentException {
        InputStream in;
        String config = DEFAULT_CONFIG_NAME;
        if (args.length >= 1 && !args[0].startsWith("-")) {
            in = new FileInputStream(args[0]);
            if (args.length >= 2 && !args[1].startsWith("-")) {
                config = args[1];
            }
        } else {
            File file = new File(CONFIG_FILE);
            in = file.canRead() ? new FileInputStream(CONFIG_FILE) : PolcoConfig.class.getResourceAsStream("/config/polco.xml");
            if (in == null) {
                throw new FileNotFoundException("/config/polco.xml");
            }
        }
        XmlConfig xmlConfig = XmlConfig.getXmlConfig(DEFAULT_APP_NAME, in, args);
        xmlConfig.setAppName(DEFAULT_APP_NAME);
        if (config != null) {
            xmlConfig.setDefaultConfigName(config);
        }
        return xmlConfig;
    }

    public static void initLoggingConfigurationForMatlab(XmlConfig config) throws XmlConfigException, IOException {
        Properties logProps = config.getLoggingProperties();
        LogConfiguration logConfig = logProps == null ? new LogConfiguration() : new LogConfiguration(logProps);
        System.setProperty(SystemProperties.LogManagerPropertiesClass.getPropertyName(), new LogConfigurationReader(logConfig).getClass().getName());
        Logger logger = Loggers.getRootLogger();
        logger.info("logger initialized");
    }

    public static <T> T createFromFactory(Class<T> clazz, Element config) throws FactoryNotFoundException, IllegalFactoryException, ConfigException {
        return XmlFactoryUtil.create(clazz, config, XmlAttribute.factory.getXmlName());
    }

    public static void tracePolcoConfig(Logger logger, Level level, XmlConfig xmlConfig) throws XmlConfigException, DocumentException {
        Element elPolcoConfig = PolcoConfig.getPolco(xmlConfig);
        logger.log(level, "polco config:");
        logger.log(level, "..args             : " + PolcoConfig.traceArgsString("", xmlConfig.getArgs()));
        logger.log(level, "..enum factory     : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.factory, XmlElement.extreme_ray_enum));
        logger.log(level, "..parser factory   : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.factory, XmlElement.parse));
        logger.log(level, "..output callback  : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.factory, XmlElement.callback));
        logger.log(level, "..arithmetic");
        logger.log(level, "....-core          : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric, XmlElement.arithmetic));
        logger.log(level, "....-preprocessing : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric_pre, XmlElement.arithmetic));
        logger.log(level, "....-post/output   : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric_post, XmlElement.arithmetic));
        logger.log(level, "..zero");
        logger.log(level, "....-core          : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric, XmlElement.zero));
        logger.log(level, "....-preprocessing : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric_pre, XmlElement.zero));
        logger.log(level, "....-post/output   : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.value, XmlElement.config, XmlElement.numeric_post, XmlElement.zero));
        logger.log(level, "..sort input       : " + PolcoConfig.getForTracing(elPolcoConfig, XmlAttribute.sort, XmlElement.config, XmlElement.input));
    }

    public static void traceJunitConfig(Arithmetic<?, ?> arithmetic, Zero zero, String testName) throws XmlConfigException, DocumentException {
        Logger logger = Loggers.getRootLogger();
        logger.info("polco junit config:");
        logger.info("..test name        : " + testName);
        logger.info("..arithmetic       : " + arithmetic);
        logger.info("..zero             : " + zero.mZeroPos);
    }

    private static String getForTracing(Element element, XmlAttribute attribute, XmlElement ... elements) {
        try {
            int index;
            int i = 0;
            while (i < elements.length) {
                element = XmlUtil.getRequiredSingleChildElement(element, elements[i]);
                ++i;
            }
            String value = XmlUtil.getRequiredAttributeValue(element, attribute);
            if (XmlAttribute.factory.equals(attribute) && value != null && (index = value.lastIndexOf(46)) >= 0) {
                return value.substring(index + 1);
            }
            return value;
        }
        catch (Exception e) {
            return "<ERROR>, e=" + e;
        }
    }

    public static void traceArgs(PrintStream print, String prefix, String[] args) {
        print.println(PolcoConfig.traceArgsString(prefix, args));
    }

    public static String traceArgsString(String prefix, String[] args) {
        StringBuilder sb = new StringBuilder(prefix);
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(args[i]);
            ++i;
        }
        return sb.toString();
    }

    public static void printVersion(PrintStream stream, XmlConfig xmlConfig) throws XmlConfigException {
        xmlConfig.printUsage(stream, VERSION_NAME);
    }

    public static void printHelp(PrintStream stream, XmlConfig xmlConfig) throws XmlConfigException {
        xmlConfig.printUsage(stream, HELP_NAME);
    }

    public static void printNoArgs(PrintStream stream, XmlConfig xmlConfig) throws XmlConfigException {
        xmlConfig.printUsage(stream, NOARGS_NAME);
    }
}

