/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.metabolic.parse.PalssonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelParser {
    private static final Logger LOG = LogPkg.LOGGER;
    private final File mFile;
    private final HSSFWorkbook mWorkbook;
    private final HSSFSheet mSheet;
    private final String mSheetName;

    public ExcelParser(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public ExcelParser(File file, int sheetIndex) throws FileNotFoundException, IOException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this.mWorkbook = new HSSFWorkbook(fs);
        this.mSheet = this.mWorkbook.getSheetAt(sheetIndex);
        this.mFile = file;
        if (this.mSheet == null) {
            throw new IOException("no sheet " + sheetIndex + " in excel file '" + file.getAbsolutePath() + "'");
        }
        this.mSheetName = this.mWorkbook.getSheetName(sheetIndex);
    }

    protected ExcelParser(File file, String worksheet) throws FileNotFoundException, IOException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this.mWorkbook = new HSSFWorkbook(fs);
        this.mSheet = worksheet == null ? this.mWorkbook.getSheetAt(0) : this.mWorkbook.getSheet(worksheet);
        this.mFile = file;
        if (this.mSheet == null) {
            throw new IOException("no sheet " + (worksheet == null ? "0" : "'" + worksheet + "'") + " in excel file '" + file.getAbsolutePath() + "'");
        }
        this.mSheetName = worksheet == null ? this.mWorkbook.getSheetName(0) : worksheet;
    }

    public MetabolicNetwork parse(int reactionColumn, int reactionNameColumn, int headerRows) throws IOException {
        return this.parse(reactionColumn, reactionNameColumn, headerRows, null);
    }

    public MetabolicNetwork parse(int reactionColumn, int reactionNameColumn, int headerRows, Pattern externalPattern) throws IOException {
        HashSet<String> reacNames = new HashSet<String>();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(buf));
        int rowIndex = headerRows;
        try {
            HSSFRow row = this.mSheet.getRow(rowIndex++);
            while (row != null) {
                HSSFCell nameCell = row.getCell((short)reactionNameColumn);
                HSSFCell formCell = row.getCell((short)reactionColumn);
                if (nameCell != null || formCell != null) {
                    if (nameCell == null) {
                        throw new IOException("reaction name cell " + (reactionNameColumn + 1) + " is empty");
                    }
                    if (formCell == null) {
                        throw new IOException("reaction formula cell " + (reactionColumn + 1) + " is empty");
                    }
                    String name = nameCell.toString().trim();
                    String form = formCell.toString().trim();
                    if (name.length() > 0 && form.length() > 0) {
                        if (reacNames.contains(name)) {
                            throw new Exception("duplicate reaction name: " + name);
                        }
                        reacNames.add(name);
                        pw.println("\"" + name + "\"\t\"" + name + "\"\t\"" + form + "\"");
                        row = this.mSheet.getRow(rowIndex++);
                        continue;
                    }
                    LOG.info("row " + (rowIndex + 1) + " found empty in excel file '" + this.mFile.getAbsolutePath() + "', stopping here.");
                    row = null;
                    continue;
                }
                LOG.info("row " + (rowIndex + 1) + " found empty in excel file '" + this.mFile.getAbsolutePath() + "', stopping here.");
                row = null;
            }
            pw.flush();
            ByteArrayInputStream in = new ByteArrayInputStream(buf.toByteArray());
            Reaction[] reacts = externalPattern == null ? new PalssonParser().parseReactions(new InputStreamReader(in)) : new PalssonParser().parseReactions(new InputStreamReader(in), externalPattern);
            return new DefaultMetabolicNetwork(reacts);
        }
        catch (Exception ex) {
            IOException ioe = new IOException(String.valueOf(ex.getMessage()) + " [row " + (rowIndex + 1) + ", file=" + this.mFile.getAbsolutePath() + ", sheet=" + this.mSheetName + "]");
            ioe.initCause(ex);
            throw ioe;
        }
    }
}

