/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractNestedReaction;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericFixSizeArray;
import ch.javasoft.util.numeric.Zero;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizedRatiosReaction
extends AbstractNestedReaction {
    public final double mNormalizationFactor;
    private ArrayIterable<MetaboliteRatio> mNormalizedRatios;

    public NormalizedRatiosReaction(Reaction reaction) {
        super(reaction);
        this.mNormalizationFactor = this.normalizeRatios(reaction);
    }

    private double normalizeRatios(Reaction reaction) {
        ArrayIterable<? extends MetaboliteRatio> ratios = reaction.getMetaboliteRatios();
        GenericFixSizeArray<MetaboliteRatio> nRatios = new GenericFixSizeArray<MetaboliteRatio>(ratios.length());
        double max = -1.0;
        int ii = 0;
        while (ii < ratios.length()) {
            max = Math.max(max, Math.abs(ratios.get(ii).getRatio()));
            ++ii;
        }
        ii = 0;
        while (ii < ratios.length()) {
            MetaboliteRatio ratio = ratios.get(ii);
            nRatios.set(ii, new DefaultMetaboliteRatio(ratio.getMetabolite(), ratio.getRatio() / max));
            ++ii;
        }
        Collections.sort(nRatios, new Comparator<MetaboliteRatio>(){

            @Override
            public int compare(MetaboliteRatio o1, MetaboliteRatio o2) {
                return o1.getMetabolite().getName().compareTo(o2.getMetabolite().getName());
            }
        });
        this.mNormalizedRatios = nRatios;
        return 1.0 / max;
    }

    public int getCorrelation(NormalizedRatiosReaction with, Zero zero) {
        ArrayIterable<MetaboliteRatio> ratiosMine = this.mNormalizedRatios;
        ArrayIterable<MetaboliteRatio> ratiosOther = with.mNormalizedRatios;
        if (this.mNormalizedRatios.length() != ratiosOther.length()) {
            return 0;
        }
        int sign = 0;
        int ii = 0;
        while (ii < ratiosMine.length()) {
            if (!ratiosMine.get(ii).getMetabolite().equals(ratiosOther.get(ii).getMetabolite())) {
                return 0;
            }
            double valA = ratiosMine.get(ii).getRatio();
            double valB = ratiosOther.get(ii).getRatio();
            if (sign == 0) {
                sign = (int)Math.signum(valA * valB);
            }
            if (sign > 0 && zero.isNonZero(valA - valB)) {
                return 0;
            }
            if (sign < 0 && zero.isNonZero(valA + valB)) {
                return 0;
            }
            ++ii;
        }
        return sign;
    }

    public ArrayIterable<MetaboliteRatio> getMetaboliteRatios() {
        return this.mNormalizedRatios;
    }

    @Override
    public ReactionConstraints getConstraints() {
        return this.mNestedReaction.getConstraints();
    }
}

