/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractNestedReaction;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedReversibilitiesMetabolicNetwork
extends AbstractMetabolicNetwork {
    private final MetabolicNetwork mNetwork;
    private final Map<Reaction, Reaction> mConstrained = new LinkedHashMap<Reaction, Reaction>();
    private transient GenericDynamicArray<Reaction> tReactions = null;
    private transient ReadableMatrix<?> tStoich = null;

    public ConstrainedReversibilitiesMetabolicNetwork(MetabolicNetwork network) {
        this.mNetwork = network;
    }

    public ArrayIterable<Reaction> getReactions() {
        if (this.tReactions == null) {
            this.tReactions = new GenericDynamicArray();
            for (Reaction reaction : this.mNetwork.getReactions()) {
                Reaction constrained = this.mConstrained.get(reaction);
                this.tReactions.add(constrained == null ? reaction : constrained);
            }
        }
        return this.tReactions;
    }

    public void constrainReaction(String name, boolean forward) {
        Reaction reac = this.mNetwork.getReaction(name);
        if (!reac.getConstraints().isReversible()) {
            throw new IllegalArgumentException("reaction must be reversible: " + reac);
        }
        if (this.mConstrained.containsKey(reac)) {
            throw new IllegalArgumentException("reaction is already constrained: " + this.mConstrained.get(reac));
        }
        final GenericDynamicArray<? extends MetaboliteRatio> ratios = new GenericDynamicArray<MetaboliteRatio>((Iterable<? extends MetaboliteRatio>)reac.getMetaboliteRatios());
        if (!forward) {
            int i = 0;
            while (i < ratios.length()) {
                ratios.set(i, ratios.get(i).invert());
                ++i;
            }
        }
        this.mConstrained.put(reac, new AbstractNestedReaction(reac){

            @Override
            public ReactionConstraints getConstraints() {
                return DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
            }

            @Override
            public ArrayIterable<? extends MetaboliteRatio> getMetaboliteRatios() {
                return ratios;
            }
        });
    }

    @Override
    public ArrayIterable<? extends Metabolite> getMetabolites() {
        return this.mNetwork.getMetabolites();
    }

    @Override
    public ReadableMatrix<?> getStoichiometricMatrix() {
        if (this.tStoich == null) {
            WritableMatrix<?> mx = this.mNetwork.getStoichiometricMatrix().toWritableMatrix(true);
            for (Reaction reac : this.mConstrained.keySet()) {
                Reaction cons = this.mConstrained.get(reac);
                if (reac.getMetaboliteRatios().equals(cons.getMetaboliteRatios())) continue;
                int rindex = this.mNetwork.getReactionIndex(reac.getName());
                for (MetaboliteRatio metaboliteRatio : reac.getMetaboliteRatios()) {
                    int mindex = this.mNetwork.getMetaboliteIndex(metaboliteRatio.getMetabolite().getName());
                    mx.negate(mindex, rindex);
                }
            }
            this.tStoich = mx.toReadableMatrix(false);
        }
        return this.tStoich;
    }
}

