/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.sort;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.efm.sort.RowColSorter;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;

public class ReversibleReactionsLastSorter
extends RowColSorter {
    private final MetabolicNetwork mNet;
    private final int[] mRowMappings;

    public ReversibleReactionsLastSorter(MetabolicNetwork net, int[] rowMappings, int startRowCol, int endRowCol) {
        super(true, startRowCol, endRowCol, -1, -1);
        this.mNet = net;
        this.mRowMappings = rowMappings;
    }

    private int getReactionIndex(int row) {
        int reacIndex = 0;
        int rowIndex = 0;
        while (reacIndex < this.mNet.getReactions().length()) {
            if (rowIndex == this.mRowMappings[row]) {
                return reacIndex;
            }
            rowIndex = this.mNet.getReactions().get(reacIndex).getConstraints().isReversible() ? ++rowIndex : ++rowIndex;
            ++reacIndex;
        }
        throw new IllegalArgumentException("no such row: " + row);
    }

    public int compare(ReadableDoubleMatrix mx, int rowA, int rowB) {
        boolean revB;
        Reaction reacA = this.mNet.getReactions().get(this.getReactionIndex(rowA));
        Reaction reacB = this.mNet.getReactions().get(this.getReactionIndex(rowB));
        boolean revA = reacA.getConstraints().isReversible();
        return revA == (revB = reacB.getConstraints().isReversible()) ? 0 : (revA ? 1 : -1);
    }
}

