/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.rankup;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.concurrent.RankUpdateToken;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrixFactory;
import ch.javasoft.metabolic.efm.rankup.RankUpRoot;

public class PreprocessableMatrix
implements Cloneable {
    public final PreprocessableMatrix parent;
    public final IBitSet nodeCutSet;
    protected transient PreprocessedMatrix processedMatrix;

    private PreprocessableMatrix(PreprocessableMatrix parent, IBitSet nodeCutSet) {
        this.parent = parent;
        this.nodeCutSet = nodeCutSet;
        this.processedMatrix = null;
    }

    public static PreprocessableMatrix createRootMatrix(IBitSet nodeCutSet) {
        return new PreprocessableMatrix(null, nodeCutSet){

            protected PreprocessedMatrix process(RankUpdateToken token, PreprocessedMatrixFactory fac) {
                if (this.processedMatrix == null) {
                    this.processedMatrix = fac.createInitialPreprocessedMatrix(this, token);
                }
                return this.processedMatrix;
            }
        };
    }

    public PreprocessableMatrix createChild(IBitSet nodeCutSet) {
        return new PreprocessableMatrix(this, nodeCutSet);
    }

    public boolean hasRequiredRank(RankUpdateToken token, RankUpRoot root, PreprocessedMatrixFactory fac, IBitSet intersectionSet) {
        return this.process(token, fac).hasRequiredRank(root, intersectionSet);
    }

    protected PreprocessedMatrix process(RankUpdateToken token, PreprocessedMatrixFactory fac) {
        if (this.processedMatrix == null) {
            PreprocessedMatrix parentProc = this.parent.process(token, fac);
            this.processedMatrix = fac.createChildPreprocessedMatrix(this, token, parentProc);
        }
        return this.processedMatrix;
    }

    public String toString() {
        return this.processedMatrix == null ? "preprocessable" : this.processedMatrix.toString();
    }

    public PreprocessableMatrix clone() {
        PreprocessableMatrix clone;
        if (this.processedMatrix == null) {
            clone = this.parent == null ? PreprocessableMatrix.createRootMatrix(this.nodeCutSet) : new PreprocessableMatrix(this.parent.clone(), this.nodeCutSet);
        } else {
            clone = new PreprocessableMatrix(this.parent, this.nodeCutSet);
            clone.processedMatrix = this.processedMatrix.clone();
        }
        return clone;
    }

    /* synthetic */ PreprocessableMatrix(PreprocessableMatrix preprocessableMatrix, IBitSet iBitSet, PreprocessableMatrix preprocessableMatrix2) {
        this(preprocessableMatrix, iBitSet);
    }
}

