/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.Util;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteEncodedOutputFormatter
implements EfmOutputFormatter<DataOutput> {
    @Override
    public void formatHeader(EfmOutputCallback cb, DataOutput writer, EfmOutputEvent evt) throws IOException {
        MetabolicNetwork net = Util.getNetworkUncompressedIfNeeded(cb.getGranularity(), evt);
        writer.writeInt(net.getReactions().length());
        writer.writeBoolean(cb.getGranularity().isBinarySufficient());
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, DataOutput writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        if (cb.getGranularity().isBinarySufficient()) {
            Column col = evt.getEfmAsColumn();
            col.writeTo(writer);
        }
    }

    @Override
    public void formatEfmValue(EfmOutputCallback cb, DataOutput writer, EfmOutputEvent evt, long efmIndex, int valueIndex, Number value) throws IOException {
        if (!cb.getGranularity().isBinarySufficient()) {
            writer.writeDouble(value.doubleValue());
        }
    }

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, DataOutput writer, EfmOutputEvent evt, long efmIndex) {
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, DataOutput writer, EfmOutputEvent evt, long countEfms) throws IOException {
        writer.writeLong(countEfms);
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return !cb.getGranularity().isBinarySufficient();
    }
}

