/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.memory.outcore;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.MemoryPart;
import ch.javasoft.metabolic.efm.memory.ReadWriteMemory;
import ch.javasoft.metabolic.efm.memory.outcore.OutOfCoreMemory;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfCoreMemoryFactory
implements MemoryFactory {
    public static final String CONFIG_FILE_NAME = "config.xml";
    private final boolean sortInCore;
    public boolean isInitialized = false;

    public OutOfCoreMemoryFactory() {
        this(false);
    }

    public OutOfCoreMemoryFactory(boolean sortInCore) {
        this.sortInCore = sortInCore;
    }

    private synchronized <N extends Number, Col extends Column> void ensureInitialized(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel) throws IOException {
        if (!this.isInitialized) {
            Config config = efmModel.getConfig();
            config.getTempDir().mkdirPersonalized();
            FileWriter configWriter = new FileWriter(new File(config.getTempDir().getPersonalizedDir(), CONFIG_FILE_NAME));
            config.writeTo(configWriter);
            configWriter.close();
            this.isInitialized = true;
        }
    }

    public <N extends Number, Col extends Column> OutOfCoreMemory<Col> createConcurrentAppendableMemory(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, int iteration, MemoryPart part) throws IOException {
        this.ensureInitialized(columnHome, efmModel);
        Config config = efmModel.getConfig();
        if (part == null) {
            return new OutOfCoreMemory<Col>(config.getTempDir().getPersonalizedDir(), iteration, efmModel.getBooleanSize(iteration), efmModel.getNumericSize(iteration), this.sortInCore, columnHome);
        }
        return new OutOfCoreMemory<Col>(config.getTempDir().getPersonalizedDir(), part, iteration, efmModel.getBooleanSize(iteration), efmModel.getNumericSize(iteration), this.sortInCore, columnHome);
    }

    @Override
    public <N extends Number, Col extends Column> ReadWriteMemory<Col> createReadWriteMemory(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, int iteration, MemoryPart part) throws IOException {
        return this.createConcurrentAppendableMemory((ColumnHome)columnHome, efmModel, iteration, part);
    }
}

