/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.range;

import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.DefaultCellRange;
import ch.javasoft.metabolic.efm.borndie.range.ForwardRowColumnRectangleIterator;
import ch.javasoft.metabolic.efm.borndie.range.RectangularRange;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRectangularRange
implements RectangularRange {
    @Override
    public boolean contains(CellRange cell) {
        return this.contains(cell.getBornColumn(), cell.getDieRow());
    }

    @Override
    public boolean contains(int bornColumn, int dieRow) {
        return dieRow >= this.getDieRowFrom() && bornColumn >= this.getBornColumnFrom() && dieRow < this.getDieRowTo() && bornColumn < this.getBornColumnTo();
    }

    @Override
    public CellRange getUpperLeft() {
        return new DefaultCellRange(this.getBornColumnFrom(), this.getDieRowFrom());
    }

    @Override
    public CellRange getUpperRight() {
        return new DefaultCellRange(this.getBornColumnTo() - 1, this.getDieRowFrom());
    }

    @Override
    public CellRange getLowerLeft() {
        return new DefaultCellRange(this.getBornColumnTo() - 1, this.getDieRowFrom());
    }

    @Override
    public CellRange getLowerRight() {
        return new DefaultCellRange(this.getBornColumnTo() - 1, this.getDieRowTo() - 1);
    }

    @Override
    public int getRowWidth() {
        return this.getBornColumnTo() - this.getBornColumnFrom();
    }

    @Override
    public int getColumnHeight() {
        return this.getDieRowTo() - this.getDieRowFrom();
    }

    @Override
    public int getCellCount() {
        return this.getRowWidth() * this.getColumnHeight();
    }

    @Override
    public Iterator<CellRange> iterator() {
        return new ForwardRowColumnRectangleIterator(this);
    }

    @Override
    public int cellToIndex(int bornColumn, int dieRow) {
        if (dieRow < this.getDieRowFrom()) {
            throw new IndexOutOfBoundsException("row below start row: " + dieRow + "<" + this.getDieRowFrom());
        }
        if (bornColumn < this.getBornColumnFrom()) {
            throw new IndexOutOfBoundsException("column below start column: " + bornColumn + "<" + this.getBornColumnFrom());
        }
        if (dieRow >= this.getDieRowTo()) {
            throw new IndexOutOfBoundsException("row after last row: " + dieRow + ">=" + this.getDieRowTo());
        }
        if (bornColumn >= this.getBornColumnTo()) {
            throw new IndexOutOfBoundsException("column after last column: " + bornColumn + ">=" + this.getBornColumnTo());
        }
        return (bornColumn - this.getBornColumnFrom()) * this.getColumnHeight() + (dieRow - this.getDieRowFrom());
    }

    @Override
    public CellRange indexToCell(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index: " + index);
        }
        if (index >= this.getCellCount()) {
            throw new IndexOutOfBoundsException("index after last cell: " + index + ">=" + this.getCellCount());
        }
        return new DefaultCellRange(this.getBornColumnFrom() + index / this.getColumnHeight(), this.getDieRowFrom() + index % this.getColumnHeight());
    }

    public int hashCode() {
        return this.getUpperLeft().hashCode() ^ this.getLowerRight().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RectangularRange) {
            RectangularRange other = (RectangularRange)obj;
            return this.getUpperLeft().equals(other.getUpperLeft()) && this.getLowerRight().equals(other.getLowerRight());
        }
        return false;
    }

    public String toString() {
        return "Rect{" + this.getUpperLeft() + ", " + this.getLowerRight() + "}";
    }
}

