/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.matrix;

import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CellStage {
    Accumulating(Color.YELLOW),
    Bearing(Color.RED),
    Collaborating(Color.GREEN),
    Done(Color.CYAN);

    private final Color color;

    private CellStage(Color color) {
        this.color = color;
    }

    public boolean isAfter(CellStage other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean isActive() {
        return this == Bearing || this == Collaborating;
    }

    public char toChar() {
        return this.name().charAt(0);
    }

    public Color toColor() {
        return this.color;
    }

    public String toString(CellRange range) {
        return this.toString(range.getBornColumn(), range.getDieRow());
    }

    public String toString(int bornCol, int dieRow) {
        return String.valueOf(this.toChar()) + "[b=" + bornCol + ", d=" + dieRow + "]";
    }
}

