/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryLeaf<T>
extends Node<T> {
    public static final int MAX_LEAF_SIZE = 1;
    protected final int columnIndex;

    protected UnaryLeaf(TreeFactory<T> treeFactory, SortableMemory<Column> cols, int columnIndex) throws IOException {
        super(cols.getColumn(columnIndex).bitValues());
        this.columnIndex = columnIndex;
    }

    @Override
    public void addAdjacentPairs(T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> partner, boolean thisIsPos, Queue<ColumnPair> adjacentPairs) throws IOException {
        if (root.enterIfCandidates(token, this, partner)) {
            if (partner instanceof UnaryLeaf) {
                AdjCandidates<Column> adjCandidates;
                UnaryLeaf leafPartner;
                IBitSet cutPat = this.addAdjacentPairs(token, root, thisIsPos ? posCols : negCols, thisIsPos ? negCols : posCols, leafPartner = (UnaryLeaf)partner, adjCandidates = new AdjCandidates<Column>(posCols, negCols, 1), adjacentPairs);
                if (cutPat != null) {
                    root.filterAdjacentPairs(token, this, partner, cutPat, posCols, zeroCols, negCols, adjCandidates);
                    adjCandidates.appendPairsTo(adjacentPairs);
                }
            } else {
                partner.addAdjacentPairs(token, root, posCols, zeroCols, negCols, this, !thisIsPos, adjacentPairs);
            }
            root.leave(token, this, partner);
        }
    }

    private IBitSet addAdjacentPairs(T token, Root<T> root, SortableMemory<Column> thisCols, SortableMemory<Column> partnerCols, UnaryLeaf partner, AdjCandidates<Column> adjCandidates, Queue<ColumnPair> adjacentPairs) throws IOException {
        IBitSet pat = null;
        int index = adjCandidates.size();
        adjCandidates.add(thisCols, this.columnIndex, partnerCols, partner.columnIndex);
        int interCard = adjCandidates.getIntersectionCardinality(index);
        if (root.isRequiredZeroBitCount(token, interCard)) {
            if (adjCandidates.getColumnPos(index).bitValues().cardinality() - interCard == 1 || adjCandidates.getColumnNeg(index).bitValues().cardinality() - interCard == 1) {
                adjCandidates.appendPairTo(adjacentPairs, index);
                adjCandidates.removeLast();
            } else {
                IBitSet inter = adjCandidates.getIntersection(index);
                if (pat == null) {
                    pat = inter;
                } else {
                    pat.and(inter);
                }
            }
        } else {
            adjCandidates.removeLast();
        }
        return pat;
    }

    @Override
    public IBitSet filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> cols, AdjCandidates<Column> adjCandidates) throws IOException {
        if (filterCutPattern != null && filterCutPattern.isSubSetOf(this.unionPattern)) {
            IBitSet cutPat = null;
            int len = adjCandidates.size();
            int index = 0;
            while (index < len) {
                boolean remove = false;
                if (adjCandidates.hasSuperSet(index, cols, this.columnIndex, this.columnIndex + 1)) {
                    remove = true;
                }
                if (remove) {
                    if (index != --len) {
                        adjCandidates.swap(index, len);
                    }
                    adjCandidates.removeLast();
                    continue;
                }
                IBitSet inter = adjCandidates.getIntersection(index);
                if (cutPat == null) {
                    cutPat = inter;
                } else {
                    cutPat.and(inter);
                }
                ++index;
            }
            return cutPat;
        }
        return filterCutPattern;
    }
}

