/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.Leaf;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogLogInterNode<T>
extends Node<T> {
    private final Node<T>[] children;

    public LogLogInterNode(TreeFactory<T> treeFactory, SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        super(Node.calculateUnionPattern(cols, iStart, iEnd));
        int bitsToUse = this.getBitsToUse(iStart, iEnd, selectiveBits, prevSelBitIndex);
        this.children = LogLogInterNode.createChildArray(1 << bitsToUse);
        this.initChildren(treeFactory, cols, 0, iStart, iEnd, selectiveBits, prevSelBitIndex, bitsToUse);
    }

    protected int getBitsToUse(int start, int end, int[] selectiveBits, int prevSelBitIndex) {
        int bitsLeft = 32 - Integer.numberOfLeadingZeros(end - start - 1);
        return Math.max(1, bitsLeft >>> 3);
    }

    private static <TT> Node<TT>[] createChildArray(int len) {
        return new Node[len];
    }

    private void initChildren(TreeFactory<T> treeFactory, SortableMemory<Column> cols, int childOffset, int start, int end, int[] selectiveBits, int prevSelBitIndex, int bitsToUse) throws IOException {
        if (end > start) {
            int median = AbstractColumn.partition(cols, start, end, selectiveBits[++prevSelBitIndex]);
            if (bitsToUse > 1 && end > start + 1) {
                this.initChildren(treeFactory, cols, childOffset, start, median, selectiveBits, prevSelBitIndex, bitsToUse - 1);
                this.initChildren(treeFactory, cols, childOffset + (1 << bitsToUse - 1), median, end, selectiveBits, prevSelBitIndex, bitsToUse - 1);
            } else {
                this.children[childOffset] = treeFactory.createNode(cols, selectiveBits, prevSelBitIndex, start, median);
                this.children[childOffset + 1] = treeFactory.createNode(cols, selectiveBits, prevSelBitIndex, median, end);
            }
        }
    }

    @Override
    public void addAdjacentPairs(T token, Root<T> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<T> partner, boolean thisIsPos, Queue<ColumnPair> adjacentPairs) throws IOException {
        if (root.enterIfCandidates(token, this, partner)) {
            if (partner instanceof Leaf) {
                int i = 0;
                while (i < this.children.length) {
                    Node<T> child = this.children[i];
                    if (child != null) {
                        child.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                    }
                    ++i;
                }
            } else {
                LogLogInterNode interPartner = (LogLogInterNode)partner;
                int i = 0;
                while (i < this.children.length) {
                    Node<T> child = this.children[i];
                    if (child != null) {
                        int j = 0;
                        while (j < interPartner.children.length) {
                            Node<T> other = interPartner.children[j];
                            if (other != null) {
                                child.addAdjacentPairs(token, root, posCols, zeroCols, negCols, other, thisIsPos, adjacentPairs);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            root.leave(token, this, partner);
        }
    }

    @Override
    public IBitSet filterAdjacentPairs(IBitSet filterCutPattern, SortableMemory<Column> cols, AdjCandidates<Column> adjCandidates) throws IOException {
        int i = 0;
        while (i < this.children.length && filterCutPattern != null) {
            Node<T> child = this.children[i];
            if (child != null && filterCutPattern.isSubSetOf(child.unionPattern)) {
                filterCutPattern = child.filterAdjacentPairs(filterCutPattern, cols, adjCandidates);
            }
            ++i;
        }
        return filterCutPattern;
    }
}

