/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputCallback;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SantosTest
extends ch.javasoft.metabolic.parse.SantosTest {
    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD;
        if (Config.initForJUnitTest("pattern-tree-minzero", compression, Arithmetic.fractional)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
            Logger.getLogger("compress.data").setLevel(Level.INFO);
        }
    }

    @Override
    public void test_P_aeruginosa_full() throws Exception {
        super.test_P_aeruginosa_full();
    }

    @Override
    public void test_P_putida_full() throws Exception {
        super.test_P_putida_full();
    }

    @Override
    public void test_P_putida_core() throws Exception {
        super.test_P_putida_core();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        if (suppressedReactions != null) {
            Config.getConfig().getReactionsToSuppress().addAll(suppressedReactions);
        }
        File outFile = new File("/home/terzerm/eth/metabolic-efm-run/results-other/mnet_santos.mat");
        ElementaryFluxModes.calculateCallback(network, new MatFileOutputCallback(network, outFile.getParentFile(), outFile.getName()));
        LogPkg.LOGGER.info("written modes to file(s): " + outFile.getAbsolutePath());
    }
}

