/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.metabolic.compress.LogPkg;
import java.util.Arrays;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CompressionMethod {
    CoupledZero,
    CoupledContradicting,
    CoupledCombine,
    UniqueFlows,
    DeadEnd,
    DuplicateGene,
    DuplicateGeneExtended,
    InterchangeableMetabolite,
    Recursive;

    public static final CompressionMethod[] ALL;
    public static final CompressionMethod[] NONE;
    public static final CompressionMethod[] STANDARD;
    public static final CompressionMethod[] STANDARD_NO_DUPLICATE;
    public static final CompressionMethod[] STANDARD_NO_COMBINE;
    public static final CompressionMethod[] STANDARD_NO_NULL;
    public static final CompressionMethod[] STANDARD_NO_NULL_COMBINE;

    static {
        ALL = CompressionMethod.values();
        NONE = new CompressionMethod[0];
        STANDARD = CompressionMethod.methods(CoupledZero, CoupledContradicting, CoupledCombine, UniqueFlows, DeadEnd, Recursive, DuplicateGene);
        STANDARD_NO_DUPLICATE = CompressionMethod.methods(CoupledZero, CoupledContradicting, CoupledCombine, UniqueFlows, DeadEnd, Recursive);
        STANDARD_NO_COMBINE = CompressionMethod.methods(CoupledZero, CoupledContradicting, DeadEnd, DuplicateGene, Recursive);
        STANDARD_NO_NULL = CompressionMethod.methods(UniqueFlows, DeadEnd, DuplicateGene, Recursive);
        STANDARD_NO_NULL_COMBINE = CompressionMethod.methods(CoupledZero, CoupledContradicting, UniqueFlows, DeadEnd, DuplicateGene, Recursive);
    }

    public boolean containedIn(CompressionMethod ... methods) {
        int i = 0;
        while (i < methods.length) {
            if (this == methods[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContainingCoupled(CompressionMethod ... methods) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isCoupled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContainingRecursive(CompressionMethod ... methods) {
        return Recursive.containedIn(methods);
    }

    public static boolean isContainingDuplicateGene(CompressionMethod ... methods) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isDublicateGene()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CompressionMethod[] methods(CompressionMethod ... methods) {
        return methods;
    }

    public static void log(Level logLevel, CompressionMethod ... methods) {
        LogPkg.LOGGER.log(logLevel, "network compression methods are " + Arrays.toString((Object[])methods));
    }

    public static void logUnsupported(Level logLevel, CompressionMethod[] methods, CompressionMethod ... supported) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        CompressionMethod[] compressionMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionMethod method = compressionMethodArray[n2];
            if (!method.containedIn(supported)) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((Object)method);
                ++cnt;
            }
            ++n2;
        }
        if (cnt > 0) {
            LogPkg.LOGGER.log(logLevel, "NOTE: ignoring unsupported network compression method" + (cnt > 1 ? "s" : "") + ": " + sb);
        }
    }

    public boolean isDublicateGene() {
        return this == DuplicateGene || this == DuplicateGeneExtended;
    }

    public boolean isCoupled() {
        return this == CoupledZero || this == CoupledContradicting || this == CoupledCombine;
    }

    public static CompressionMethod[] removeDuplicateGeneMethods(CompressionMethod ... methods) {
        int cnt = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isDublicateGene()) {
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return methods;
        }
        CompressionMethod[] res = new CompressionMethod[methods.length - cnt];
        cnt = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2].isDublicateGene()) {
                ++cnt;
            } else {
                res[i2 - cnt] = methods[i2];
            }
            ++i2;
        }
        return res;
    }
}

