/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compartment;

import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompartmentMetabolicNetwork
extends DefaultMetabolicNetwork {
    private Map<String, String> mCompartments = null;

    public CompartmentMetabolicNetwork(CompartmentMetabolite[] metabolites, String[] reactionNames, double[][] stoichMatrix, boolean[] reversible) {
        super((Metabolite[])metabolites, reactionNames, stoichMatrix, reversible);
    }

    public CompartmentMetabolicNetwork(CompartmentReaction[] reactions) {
        super(reactions);
    }

    public CompartmentMetabolicNetwork(Iterable<? extends CompartmentMetabolite> metabolites, Iterable<? extends CompartmentReaction> reactions) {
        super(metabolites, reactions);
    }

    public CompartmentMetabolicNetwork(Metabolite[] metabolites, Reaction[] reactions) {
        super(metabolites, reactions);
    }

    public CompartmentMetabolicNetwork(GenericDynamicArray<? extends CompartmentMetabolite> metabolites, GenericDynamicArray<? extends CompartmentReaction> reactions) {
        super(metabolites, reactions);
    }

    @Override
    public CompartmentMetabolite getMetabolite(String name) {
        return (CompartmentMetabolite)super.getMetabolite(name);
    }

    public ArrayIterable<? extends CompartmentMetabolite> getMetabolites() {
        return super.getMetabolites();
    }

    @Override
    public CompartmentReaction getReaction(String name) {
        return (CompartmentReaction)super.getReaction(name);
    }

    public ArrayIterable<? extends CompartmentReaction> getReactions() {
        return super.getReactions();
    }

    public ArrayIterable<? extends CompartmentReaction> getReactions(Metabolite metabolite) {
        return super.getReactions(metabolite);
    }

    public Iterable<String> getCompartmentNames() {
        if (this.mCompartments == null) {
            this.mCompartments = new LinkedHashMap<String, String>();
            for (CompartmentMetabolite compartmentMetabolite : this.getMetabolites()) {
                this.mCompartments.put(compartmentMetabolite.getCompartment(), compartmentMetabolite.getCompartment());
            }
        }
        return Collections.unmodifiableSet(this.mCompartments.keySet());
    }

    public String getCompartmentFullName(String name) {
        this.getCompartmentNames();
        return this.mCompartments.get(name);
    }

    public void setCompartmentFullName(String name, String fullName) {
        if (fullName == null) {
            throw new NullPointerException("null name not allowed");
        }
        this.getCompartmentNames();
        if (!this.mCompartments.containsKey(name)) {
            throw new IllegalArgumentException("no such compartment: " + name);
        }
        this.mCompartments.put(name, fullName);
    }

    public ArrayIterable<? extends CompartmentMetabolite> getMetabolitesForCompartment(String compartment) {
        GenericDynamicArray<CompartmentMetabolite> metas = new GenericDynamicArray<CompartmentMetabolite>();
        for (CompartmentMetabolite compartmentMetabolite : this.getMetabolites()) {
            if (!compartment.equals(compartmentMetabolite.getCompartment())) continue;
            metas.add(compartmentMetabolite);
        }
        return metas;
    }
}

