/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.ops.AbstractNumberOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleOperations
extends AbstractNumberOps<Double> {
    private static DoubleOperations sInstance;

    public static DoubleOperations instance() {
        if (sInstance == null) {
            sInstance = new DoubleOperations();
        }
        return sInstance;
    }

    @Override
    public Class<Double> numberClass() {
        return Double.class;
    }

    public Double[] newArray(int size) {
        return new Double[size];
    }

    public Double[][] newArray(int rows, int cols) {
        return new Double[rows][cols];
    }

    @Override
    public Double valueOf(String s) {
        return Double.valueOf(s);
    }

    @Override
    public Double valueOf(Number number) {
        return number.doubleValue();
    }

    @Override
    public Double valueOf(long value) {
        return value;
    }

    @Override
    public Double valueOf(double value) {
        return value;
    }

    @Override
    public Double abs(Double number) {
        return Math.abs(number);
    }

    @Override
    public Double add(Double numA, Double numB) {
        return numA + numB;
    }

    @Override
    public Double divide(Double numA, Double numB) {
        return numA / numB;
    }

    @Override
    public Double invert(Double number) {
        return 1.0 / number;
    }

    @Override
    public boolean isOne(Double number) {
        return number == 1.0;
    }

    @Override
    public boolean isZero(Double number) {
        return number == 0.0;
    }

    @Override
    public Double multiply(Double numA, Double numB) {
        return numA * numB;
    }

    @Override
    public Double negate(Double number) {
        return -number.doubleValue();
    }

    @Override
    public Double reduce(Double number) {
        return number;
    }

    public Double[] reduceVector(boolean cloneOnChange, Double ... vector) {
        return vector;
    }

    @Override
    public Double one() {
        return 1.0;
    }

    @Override
    public Double pow(Double numA, Double numB) {
        return Math.pow(numA, numB);
    }

    @Override
    public int signum(Double number) {
        return (int)Math.signum(number);
    }

    @Override
    public Double subtract(Double numA, Double numB) {
        return numA - numB;
    }

    @Override
    public Double zero() {
        return 0.0;
    }

    @Override
    public int compare(Double o1, Double o2) {
        return o1.compareTo(o2);
    }

    @Override
    public byte[] toByteArray(Double number) {
        long v = Double.doubleToLongBits(number);
        byte[] bytes = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return bytes;
    }

    @Override
    public void writeTo(Double number, DataOutput out) throws IOException {
        out.writeDouble(number);
    }

    @Override
    public Double fromByteArray(byte[] bytes) {
        long longBits = ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
        return Double.longBitsToDouble(longBits);
    }

    @Override
    public Double readFrom(DataInput in) throws IOException {
        return in.readDouble();
    }

    @Override
    public int byteLength() {
        return 8;
    }
}

