/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.ops.AbstractNumberOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalOperations
extends AbstractNumberOps<BigDecimal> {
    private final MathContext mathContext;

    public BigDecimalOperations(MathContext mathContext) {
        this.mathContext = mathContext;
    }

    public BigDecimalOperations(int setPrecision) {
        this(new MathContext(setPrecision));
    }

    public BigDecimalOperations(String contextVal) {
        this(new MathContext(contextVal));
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    @Override
    public Class<BigDecimal> numberClass() {
        return BigDecimal.class;
    }

    public BigDecimal[] newArray(int size) {
        return new BigDecimal[size];
    }

    public BigDecimal[][] newArray(int rows, int cols) {
        return new BigDecimal[rows][cols];
    }

    @Override
    public BigDecimal valueOf(String s) {
        return new BigDecimal(s);
    }

    @Override
    public BigDecimal valueOf(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof BigFraction) {
            return ((BigFraction)number).toBigDecimal(this.mathContext);
        }
        return this.valueOf(number.toString());
    }

    @Override
    public BigDecimal valueOf(long value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal valueOf(double value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal abs(BigDecimal number) {
        return number.abs(this.mathContext);
    }

    @Override
    public BigDecimal add(BigDecimal numA, BigDecimal numB) {
        return numA.add(numB, this.mathContext);
    }

    @Override
    public BigDecimal divide(BigDecimal numA, BigDecimal numB) {
        return numA.divide(numB, this.mathContext);
    }

    @Override
    public BigDecimal invert(BigDecimal number) {
        return this.divide(BigDecimal.ONE, number);
    }

    @Override
    public boolean isOne(BigDecimal number) {
        return BigDecimal.ONE.equals(number);
    }

    @Override
    public BigDecimal multiply(BigDecimal numA, BigDecimal numB) {
        return numA.multiply(numB, this.mathContext);
    }

    @Override
    public BigDecimal negate(BigDecimal number) {
        return number.negate(this.mathContext);
    }

    @Override
    public BigDecimal one() {
        return BigDecimal.ONE;
    }

    @Override
    public BigDecimal subtract(BigDecimal numA, BigDecimal numB) {
        return numA.subtract(numB, this.mathContext);
    }

    @Override
    public BigDecimal zero() {
        return BigDecimal.ZERO;
    }

    @Override
    public int compare(BigDecimal o1, BigDecimal o2) {
        return o1.compareTo(o2);
    }

    @Override
    public BigDecimal reduce(BigDecimal number) {
        return number.round(this.mathContext);
    }

    public BigDecimal[] reduceVector(boolean cloneOnChange, BigDecimal ... vector) {
        return vector;
    }

    @Override
    public int signum(BigDecimal number) {
        return number.signum();
    }

    @Override
    public BigDecimal pow(BigDecimal numA, BigDecimal numB) {
        int expSign = numB.signum();
        if (expSign == 0) {
            return BigDecimal.ONE;
        }
        if (this.isOne(numA)) {
            return BigDecimal.ONE;
        }
        try {
            BigInteger inumB = numB.toBigIntegerExact();
            if (expSign > 0 && inumB.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new ArithmeticException("exponent too large, only integer range supported: " + inumB + " > " + Integer.MAX_VALUE);
            }
            if (expSign < 0 && inumB.compareTo(BigInteger.valueOf(-2147483647L)) < 0) {
                throw new ArithmeticException("exponent too small, only integer range supported: " + inumB + " < " + Integer.MIN_VALUE);
            }
            return numA.pow(inumB.intValue());
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("non-integer exponent not supported");
        }
    }

    @Override
    public byte[] toByteArray(BigDecimal number) {
        int scale = number.scale();
        BigInteger unscaled = number.unscaledValue();
        byte[] value = unscaled.toByteArray();
        byte[] bytes = new byte[value.length + 4];
        bytes[0] = (byte)(scale >>> 24);
        bytes[1] = (byte)(scale >>> 16);
        bytes[2] = (byte)(scale >>> 8);
        bytes[3] = (byte)(scale >>> 0);
        System.arraycopy(value, 0, bytes, 4, value.length);
        return bytes;
    }

    @Override
    public void writeTo(BigDecimal number, DataOutput out) throws IOException {
        byte[] bytes = number.unscaledValue().toByteArray();
        out.writeInt(number.scale());
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public BigDecimal fromByteArray(byte[] bytes) {
        int scale = (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + (bytes[3] << 0);
        byte[] vals = new byte[bytes.length - 4];
        System.arraycopy(bytes, 4, vals, 0, vals.length);
        BigInteger unscaled = new BigInteger(bytes);
        return new BigDecimal(unscaled, scale);
    }

    @Override
    public BigDecimal readFrom(DataInput in) throws IOException {
        int scale = in.readInt();
        int length = in.readInt();
        byte[] value = new byte[length];
        in.readFully(value);
        BigInteger unscaled = new BigInteger(value);
        return new BigDecimal(unscaled, scale);
    }

    @Override
    public int byteLength() {
        return -1;
    }
}

