/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.compose;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.operator.AbstractQuaternaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.TernaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.operator.compose.TempArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryTernaryOperator<T extends Number, A>
extends AbstractQuaternaryOperator<T, A> {
    private final BinaryOperator<T, A> operator;
    private final UnaryOperator<T, A> operand1;
    private final TernaryOperator<T, A> operand2;
    private final TempArray<A> temp;

    public UnaryTernaryOperator(ArrayOperations<A> ops, BinaryOperator<T, A> operator, UnaryOperator<T, A> operand1, TernaryOperator<T, A> operand2) {
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.temp = new TempArray<A>(ops, 2);
    }

    @Override
    public T operate(T operand1, T operand2, T operand3, T operand4) {
        Number operated1 = (Number)this.operand1.operate(operand1);
        Number operated2 = (Number)this.operand2.operate(operand2, operand3, operand4);
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public void operate(A operand1, int index1, A operand2, int index2, A operand3, int index3, A operand4, int index4, A dst, int dstIndex) {
        A tmp = this.temp.get();
        this.operand1.operate(operand1, index1, tmp, 0);
        this.operand2.operate(operand2, index2, operand3, index3, operand4, index4, tmp, 1);
        this.operator.operate(tmp, 0, tmp, 1, dst, dstIndex);
    }
}

