/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg.impl;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.linalg.GaussPivoting;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerGaussPivoting {
    public static GaussPivotingFactory<BigInteger, BigInteger[]> LEN_L = new GaussPivotingFactory<BigInteger, BigInteger[]>(){

        @Override
        public GaussPivoting<BigInteger, BigInteger[]> getGaussPivoting(NumberArrayOperations<BigInteger, BigInteger[]> numberOps, int pivot) {
            return new LenL(pivot);
        }
    };
    public static GaussPivotingFactory<BigInteger, BigInteger[]> LEN_LE = new GaussPivotingFactory<BigInteger, BigInteger[]>(){

        @Override
        public GaussPivoting<BigInteger, BigInteger[]> getGaussPivoting(NumberArrayOperations<BigInteger, BigInteger[]> numberOps, int pivot) {
            return new LenLE(pivot);
        }
    };
    public static GaussPivotingFactory<BigInteger, BigInteger[]> LEN_L_OR_E_AND_MORE_ROW_ZEROS = new GaussPivotingFactory<BigInteger, BigInteger[]>(){

        @Override
        public GaussPivoting<BigInteger, BigInteger[]> getGaussPivoting(NumberArrayOperations<BigInteger, BigInteger[]> numberOps, int pivot) {
            return new LenLorEandMoreRowZeros(numberOps, pivot);
        }
    };

    private static boolean isZero(NumberArrayOperations<BigInteger, BigInteger[]> nops, BigInteger value) {
        return nops.getNumberOperators().booleanUnary(BooleanUnaryOperator.Id.isZero).booleanOperate(value);
    }

    private BigIntegerGaussPivoting() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenL
    implements GaussPivoting<BigInteger, BigInteger[]> {
        private int pivCol;
        private int pivRow;
        private int pivLen = Integer.MAX_VALUE;

        public LenL(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigInteger[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(BigInteger[][] matrix, int pivot, int row, int col, int rowResult) {
            BigInteger val = matrix[row][col];
            int len = val.abs().bitLength();
            if (len < this.pivLen) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivLen = len;
            }
            return this.pivLen != 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenLE
    implements GaussPivoting<BigInteger, BigInteger[]> {
        private int pivCol;
        private int pivRow;
        private int pivLen = Integer.MAX_VALUE;

        public LenLE(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigInteger[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(BigInteger[][] matrix, int pivot, int row, int col, int rowResult) {
            BigInteger val = matrix[row][col];
            int len = val.abs().bitLength();
            if (len <= this.pivLen) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivLen = len;
            }
            return this.pivLen != 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenLorEandMoreRowZeros
    implements GaussPivoting<BigInteger, BigInteger[]> {
        private final NumberArrayOperations<BigInteger, BigInteger[]> numberOps;
        private int pivCol;
        private int pivRow;
        private int pivLen = Integer.MAX_VALUE;
        private int pivCnt = 0;

        public LenLorEandMoreRowZeros(NumberArrayOperations<BigInteger, BigInteger[]> numberOps, int pivot) {
            this.numberOps = numberOps;
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigInteger[][] matrix, int pivot, int row) {
            int cols = matrix[row].length;
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (BigIntegerGaussPivoting.isZero(this.numberOps, matrix[row][col])) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        public boolean checkCandidateCol(BigInteger[][] matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger val = matrix[row][col];
            int len = val.abs().bitLength();
            if (len < this.pivLen || len == this.pivLen && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivLen = len;
                this.pivCnt = zerCnt;
            }
            int cols = matrix[row].length;
            return this.pivLen != 1 || this.pivCnt < cols - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }
}

