/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.sort;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostZerosArrayComparator<N extends Number, A>
implements Comparator<A> {
    private final ArrayOperations<A> aops;
    private final BooleanUnaryOperator<N, A> isZero;

    public MostZerosArrayComparator(NumberOperators<N, A> operators) {
        this.aops = operators.getArrayOperations();
        this.isZero = operators.booleanUnary(BooleanUnaryOperator.Id.isZero);
    }

    @Override
    public int compare(A o1, A o2) {
        int len1 = this.aops.getLength(o1);
        int cnt1 = 0;
        int i = 0;
        while (i < len1) {
            if (this.isZero.booleanOperate(o1, i)) {
                ++cnt1;
            }
            ++i;
        }
        int len2 = this.aops.getLength(o2);
        int cnt2 = 0;
        int i2 = 0;
        while (i2 < len2) {
            if (this.isZero.booleanOperate(o2, i2)) {
                ++cnt2;
            }
            ++i2;
        }
        return cnt2 - cnt1;
    }
}

