/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter<IN extends Number, IA, RN extends Number, RA> {
    private final NumberArrayOperations<IN, IA> naopsO;
    private final NumberArrayOperations<RN, RA> naopsT;
    private final ArrayOperations<IA> aopsO;
    private final ArrayOperations<RA> aopsT;
    private final NumberOperators<IN, IA> nopsO;
    private final NumberOperators<RN, RA> nopsT;
    private final BooleanUnaryOperator<IN, IA> isZeroO;
    private final BooleanUnaryOperator<IN, IA> isOneO;
    private final ConvertingUnaryOperator<Number, Number[], RN, RA> converter;
    private final ExpressionComposer<IN, IA> composerO;

    public Converter(NumberArrayOperations<IN, IA> originalOps, NumberArrayOperations<RN, RA> targetOps) {
        this.naopsO = originalOps;
        this.naopsT = targetOps;
        this.aopsO = originalOps.getArrayOperations();
        this.aopsT = targetOps.getArrayOperations();
        this.nopsO = originalOps.getNumberOperators();
        this.nopsT = targetOps.getNumberOperators();
        this.isZeroO = this.nopsO.booleanUnary(BooleanUnaryOperator.Id.isZero);
        this.isOneO = this.nopsO.booleanUnary(BooleanUnaryOperator.Id.isOne);
        this.converter = this.nopsT.converter();
        this.composerO = this.naopsO.getExpressionComposer();
    }

    public Class<IN> numberClassInput() {
        return this.naopsO.numberClass();
    }

    public Class<IA> arrayClassInput() {
        return this.naopsO.arrayClass();
    }

    public NumberArrayOperations<IN, IA> getNumberArrayOperationsInput() {
        return this.naopsO;
    }

    public Class<RN> numberClassResult() {
        return this.naopsT.numberClass();
    }

    public Class<RA> arrayClassResult() {
        return this.naopsT.arrayClass();
    }

    public NumberArrayOperations<RN, RA> getNumberArrayOperationsResult() {
        return this.naopsT;
    }

    public boolean isIdentityConverter() {
        return this.numberClassInput().equals(this.numberClassResult()) && this.arrayClassInput().equals(this.arrayClassResult());
    }

    public RN convertValue(IN original) {
        if (this.naopsT.numberClass().equals(this.naopsO.numberClass())) {
            return (RN)((Number)this.naopsT.numberClass().cast(original));
        }
        if (this.isZeroO.booleanOperate(original)) {
            return this.nopsT.zero();
        }
        if (this.isOneO.booleanOperate(original)) {
            return this.nopsT.one();
        }
        return (RN)((Number)this.converter.operate((Number)original));
    }

    public void convertVector(IA src, int srcStart, RA dst, int dstStart, int length) {
        if (this.naopsO.arrayClass().equals(this.naopsT.arrayClass())) {
            if (src != dst) {
                RA srcC = this.naopsT.arrayClass().cast(src);
                this.naopsT.getArrayOperations().copyVectorElements(srcC, srcStart, dst, dstStart, length);
            }
        } else {
            this.convertVectorInternal(src, srcStart, dst, dstStart, length);
        }
    }

    public RA convertVector(IA original) {
        if (this.naopsO.arrayClass().equals(this.naopsT.arrayClass())) {
            return this.naopsT.arrayClass().cast(original);
        }
        int len = this.aopsO.getLength(original);
        RA converted = this.aopsT.newVector(len);
        return this.convertVectorInternal(original, 0, converted, 0, len);
    }

    public RA convertVector(IA original, boolean normalize, boolean allowScaling) {
        RA converted;
        if (this.naopsO.arrayClass().equals(this.naopsT.arrayClass())) {
            converted = this.naopsT.arrayClass().cast(original);
        } else {
            int len = this.aopsO.getLength(original);
            converted = this.aopsT.newVector(len);
            try {
                this.convertVectorInternal(original, 0, converted, 0, len);
            }
            catch (ArithmeticException e) {
                if (allowScaling) {
                    Number div = (Number)this.composerO.vectorSqueezeDivisor().operate(original, 0, len);
                    if (!this.isZeroO.booleanOperate(div) && !this.isOneO.booleanOperate(div)) {
                        UnaryOperator<Number, IA> norm = this.composerO.normalize(this.composerO.divFreeBy(this.composerO.constant(div)));
                        this.naopsO.applyToEachElement(original, original, norm);
                    }
                    this.convertVectorInternal(original, 0, converted, 0, len);
                }
                throw e;
            }
        }
        if (normalize) {
            ExpressionComposer<RN, RA> composer = this.naopsT.getExpressionComposer();
            UnaryOperator<RN, RA> norm = composer.normalize();
            this.naopsT.applyToEachElement(converted, converted, norm);
        }
        return converted;
    }

    private RA convertVectorInternal(IA src, int srcStart, RA dst, int dstStart, int length) {
        int i = 0;
        while (i < length) {
            if (this.isZeroO.booleanOperate(src, i)) {
                this.naopsT.set(dst, dstStart + i, this.nopsT.zero());
            } else if (this.isOneO.booleanOperate(src, i)) {
                this.naopsT.set(dst, dstStart + i, this.nopsT.one());
            } else {
                IN num = this.naopsO.get(src, srcStart + i);
                Number value = (Number)this.converter.operate((Number)num);
                this.naopsT.set(dst, dstStart + i, value);
            }
            ++i;
        }
        return dst;
    }

    public RA[] convertMatrix(IA[] original) {
        if (this.naopsO.arrayClass().equals(this.naopsT.arrayClass())) {
            return original;
        }
        return this.convertMatrixInternal(original);
    }

    /*
     * Unable to fully structure code
     */
    public RA[] convertMatrix(IA[] original, boolean normalize, boolean allowRowScaling, boolean allowColumnScaling, boolean allowMatrixScaling) {
        block15: {
            block12: {
                block13: {
                    block14: {
                        if (!this.naopsO.arrayClass().equals(this.naopsT.arrayClass())) break block14;
                        converted = this.convertMatrix(original);
                        break block15;
                    }
                    try {
                        conv = this.convertMatrixInternal(original);
                        break block12;
                    }
                    catch (ArithmeticException e) {
                        rows = this.aopsO.getRowCount(original);
                        cols = this.aopsO.getColumnCount(original);
                        if (!allowRowScaling) break block13;
                        r = 0;
                        ** while (r < rows)
                    }
lbl-1000:
                    // 1 sources

                    {
                        div = (Number)this.composerO.vectorSqueezeDivisor().operate(original[r], 0, cols);
                        if (!this.isZeroO.booleanOperate(div) && !this.isOneO.booleanOperate(div)) {
                            norm = this.composerO.normalize(this.composerO.divFreeBy(this.composerO.constant(div)));
                            this.naopsO.applyToEachRowElement(original, r, original, r, norm);
                        }
                        ++r;
                        continue;
                    }
lbl20:
                    // 1 sources

                    conv = this.convertMatrixInternal(original);
                    break block12;
                }
                if (allowColumnScaling) {
                    c = 0;
                    while (c < cols) {
                        div = (Number)this.composerO.vectorSqueezeDivisor().operate(original, 0, c, rows, 1);
                        if (!this.isZeroO.booleanOperate(div) && !this.isOneO.booleanOperate(div)) {
                            norm = this.composerO.normalize(this.composerO.divFreeBy(this.composerO.constant(div)));
                            this.naopsO.applyToEachColumnElement(original, c, original, c, norm);
                        }
                        ++c;
                    }
                    conv = this.convertMatrixInternal(original);
                } else if (allowMatrixScaling) {
                    div = (Number)this.composerO.vectorSqueezeDivisor().operate(original, 0, 0, rows, cols);
                    if (!this.isZeroO.booleanOperate(div) && !this.isOneO.booleanOperate(div)) {
                        norm = this.composerO.normalize(this.composerO.divFreeBy(this.composerO.constant(div)));
                        this.naopsO.applyToEachElement(original, original, norm);
                    }
                    conv = this.convertMatrixInternal(original);
                } else {
                    throw e;
                }
            }
            converted = conv;
        }
        if (normalize) {
            composer = this.naopsT.getExpressionComposer();
            norm = composer.normalize();
            this.naopsT.applyToEachElement(converted, converted, norm);
        }
        return converted;
    }

    private RA[] convertMatrixInternal(IA[] original) {
        int rows = this.aopsO.getRowCount(original);
        int cols = this.aopsO.getColumnCount(original);
        RA[] converted = this.aopsT.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            converted[r] = this.convertVector(original[r]);
            ++r;
        }
        return converted;
    }
}

