/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.marshal;

import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.FixedWidthMarshaller;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveArrayMarshallers {
    public static final EntityMarshaller<byte[]> BYTE = new EntityMarshaller<byte[]>(){

        @Override
        public void writeTo(byte[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            out.write(entity);
        }

        @Override
        public byte[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            byte[] arr = new byte[len];
            in.readFully(arr);
            return arr;
        }
    };
    public static final EntityMarshaller<short[]> SHORT = new EntityMarshaller<short[]>(){

        @Override
        public void writeTo(short[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeShort(entity[i]);
                ++i;
            }
        }

        @Override
        public short[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            short[] arr = new short[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readShort();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<int[]> INT = new EntityMarshaller<int[]>(){

        @Override
        public void writeTo(int[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeInt(entity[i]);
                ++i;
            }
        }

        @Override
        public int[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            int[] arr = new int[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readInt();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<long[]> LONG = new EntityMarshaller<long[]>(){

        @Override
        public void writeTo(long[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeLong(entity[i]);
                ++i;
            }
        }

        @Override
        public long[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            long[] arr = new long[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readLong();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<float[]> FLOAT = new EntityMarshaller<float[]>(){

        @Override
        public void writeTo(float[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeFloat(entity[i]);
                ++i;
            }
        }

        @Override
        public float[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            float[] arr = new float[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readFloat();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<double[]> DOUBLE = new EntityMarshaller<double[]>(){

        @Override
        public void writeTo(double[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeDouble(entity[i]);
                ++i;
            }
        }

        @Override
        public double[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            double[] arr = new double[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readDouble();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<boolean[]> BOOLEAN = new EntityMarshaller<boolean[]>(){

        @Override
        public void writeTo(boolean[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeBoolean(entity[i]);
                ++i;
            }
        }

        @Override
        public boolean[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            boolean[] arr = new boolean[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readBoolean();
                ++i;
            }
            return arr;
        }
    };
    public static final EntityMarshaller<char[]> CHAR = new EntityMarshaller<char[]>(){

        @Override
        public void writeTo(char[] entity, DataOutput out) throws IOException {
            out.writeInt(entity.length);
            int i = 0;
            while (i < entity.length) {
                out.writeChar(entity[i]);
                ++i;
            }
        }

        @Override
        public char[] readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            char[] arr = new char[len];
            int i = 0;
            while (i < len) {
                arr[i] = in.readChar();
                ++i;
            }
            return arr;
        }
    };

    public static FixedWidthMarshaller<byte[]> getForFixedByteArray(final int arrayLength) {
        return new FixedWidthMarshaller<byte[]>(){

            @Override
            public void writeTo(byte[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                out.write(entity);
            }

            @Override
            public byte[] readFrom(DataInput in) throws IOException {
                byte[] arr = new byte[arrayLength];
                in.readFully(arr);
                return arr;
            }

            @Override
            public int getByteWidth() {
                return arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<short[]> getForFixedShortArray(final int arrayLength) {
        return new FixedWidthMarshaller<short[]>(){

            @Override
            public void writeTo(short[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeShort(entity[i]);
                    ++i;
                }
            }

            @Override
            public short[] readFrom(DataInput in) throws IOException {
                short[] arr = new short[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readShort();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 2 * arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<int[]> getForFixedIntArray(final int arrayLength) {
        return new FixedWidthMarshaller<int[]>(){

            @Override
            public void writeTo(int[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeInt(entity[i]);
                    ++i;
                }
            }

            @Override
            public int[] readFrom(DataInput in) throws IOException {
                int[] arr = new int[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readInt();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 4 * arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<long[]> getForFixedLongArray(final int arrayLength) {
        return new FixedWidthMarshaller<long[]>(){

            @Override
            public void writeTo(long[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeLong(entity[i]);
                    ++i;
                }
            }

            @Override
            public long[] readFrom(DataInput in) throws IOException {
                long[] arr = new long[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readLong();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 8 * arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<float[]> getForFixedFloatArray(final int arrayLength) {
        return new FixedWidthMarshaller<float[]>(){

            @Override
            public void writeTo(float[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeFloat(entity[i]);
                    ++i;
                }
            }

            @Override
            public float[] readFrom(DataInput in) throws IOException {
                float[] arr = new float[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readFloat();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 4 * arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<double[]> getForFixedDoubleArray(final int arrayLength) {
        return new FixedWidthMarshaller<double[]>(){

            @Override
            public void writeTo(double[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeDouble(entity[i]);
                    ++i;
                }
            }

            @Override
            public double[] readFrom(DataInput in) throws IOException {
                double[] arr = new double[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readDouble();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 8 * arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<boolean[]> getForFixedBooleanArray(final int arrayLength) {
        return new FixedWidthMarshaller<boolean[]>(){

            @Override
            public void writeTo(boolean[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeBoolean(entity[i]);
                    ++i;
                }
            }

            @Override
            public boolean[] readFrom(DataInput in) throws IOException {
                boolean[] arr = new boolean[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readBoolean();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return arrayLength;
            }
        };
    }

    public static FixedWidthMarshaller<char[]> getForFixedCharArray(final int arrayLength) {
        return new FixedWidthMarshaller<char[]>(){

            @Override
            public void writeTo(char[] entity, DataOutput out) throws IOException {
                if (entity.length != arrayLength) {
                    throw new IOException("invalid array length " + entity.length + ", expected " + arrayLength);
                }
                int i = 0;
                while (i < arrayLength) {
                    out.writeChar(entity[i]);
                    ++i;
                }
            }

            @Override
            public char[] readFrom(DataInput in) throws IOException {
                char[] arr = new char[arrayLength];
                int i = 0;
                while (i < arr.length) {
                    arr[i] = in.readChar();
                    ++i;
                }
                return arr;
            }

            @Override
            public int getByteWidth() {
                return 2 * arrayLength;
            }
        };
    }

    private PrimitiveArrayMarshallers() {
    }
}

