/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    private final Writer mWriter;
    private final String mCharsetName;

    public WriterOutputStream(Writer writer) {
        this.mWriter = writer;
        this.mCharsetName = null;
    }

    public WriterOutputStream(Writer writer, String charsetName) throws UnsupportedEncodingException {
        new String(new byte[0], charsetName);
        this.mWriter = writer;
        this.mCharsetName = charsetName;
    }

    public String getCharsetName() {
        return this.mCharsetName;
    }

    public void write(int b) throws IOException {
        String str = this.mCharsetName == null ? new String(new byte[]{(byte)b}) : new String(new byte[]{(byte)b}, this.mCharsetName);
        this.mWriter.write(str);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        String str = this.mCharsetName == null ? new String(b, off, len) : new String(b, off, len, this.mCharsetName);
        this.mWriter.write(str);
    }

    public void flush() throws IOException {
        this.mWriter.flush();
    }

    public void close() throws IOException {
        this.mWriter.close();
    }
}

