from ymdantic.models.base import YMBaseModel


class R128(YMBaseModel):
    """
    Pydantic модель, представляющая данные нормализации громкости по стандарту EBU R128.

    Стандарт EBU R128 используется для измерения воспринимаемой громкости аудиоконтента.
    """

    i: float
    # Значение интегрированной громкости в LUFS (единицы громкости
    # относительно полной шкалы). Это общая громкость всего аудиофрагмента.
    tp: float
    # Истинный пиковый уровень в dBTP (децибелы истинного пика).
    # Это самый высокий уровень в аудиоконтенте, учитывающий межсемпловые пики.
