from .landing3 import OldChartBlock, NewReleasesBlock
from .landing import (
    NewReleasesResponse,
    NewRelease,
    SkeletonResponse,
    LandingArtist,
    LandingArtistItemData,
    LandingArtistItem,
    LandingAlbum,
    LandingAlbumItemData,
    LandingAlbumItem,
    EditorialResponse,
    LandingPlaylist,
    LandingPlaylistItemData,
    LandingPlaylistItem,
    LandingLikedPlaylistItemData,
    LandingLikedPlaylistItem,
    LandingPersonalPlaylistItemData,
    LandingPersonalPlaylistItem,
    LandingPromotion,
    LandingPromotionResponse,
    LandingOpenPlaylist,
    LandingSpecial,
    Chart,
    ChartBlock,
    InStyle,
    InStyleResponse,
    LandingCustomWave,
    LandingWaves,
    LandingWavesResponse,
)
from .playlists import Playlist
from .response import Response
from .albums import Album, ShortAlbum
from .tracks import (
    TrackType,
    DownloadInfo,
    DownloadInfoDirect,
    Track,
    UnavailableTrack,
    Podcast,
    UnavailablePodcast,
)
from .artists import Artist
from .s3 import S3FileUrl

# Ребилд моделей с учётом новых изменений. (TrackType)
ShortAlbum.model_rebuild()
Album.model_rebuild()

__all__ = (
    "Response",
    "Album",
    "ShortAlbum",
    "Artist",
    "TrackType",
    "DownloadInfo",
    "DownloadInfoDirect",
    "OldChartBlock",
    "NewReleasesBlock",
    "Playlist",
    "Track",
    "UnavailableTrack",
    "Podcast",
    "UnavailablePodcast",
    "NewReleasesResponse",
    "NewRelease",
    "SkeletonResponse",
    "LandingArtist",
    "LandingArtistItemData",
    "LandingArtistItem",
    "LandingAlbum",
    "LandingAlbumItemData",
    "LandingAlbumItem",
    "LandingPlaylist",
    "LandingPlaylistItemData",
    "LandingPlaylistItem",
    "LandingLikedPlaylistItemData",
    "LandingLikedPlaylistItem",
    "LandingPersonalPlaylistItemData",
    "LandingPersonalPlaylistItem",
    "LandingPromotion",
    "LandingPromotionResponse",
    "LandingOpenPlaylist",
    "LandingSpecial",
    "EditorialResponse",
    "Chart",
    "ChartBlock",
    "InStyle",
    "InStyleResponse",
    "LandingCustomWave",
    "LandingWaves",
    "LandingWavesResponse",
    "S3FileUrl",
)
