"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroAppsS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cf = require("aws-cdk-lib/aws-cloudfront");
const cforigins = require("aws-cdk-lib/aws-cloudfront-origins");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * (experimental) Create a new MicroApps S3 Bucket.
 *
 * @experimental
 */
class MicroAppsS3 extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { removalPolicy, assetNameRoot, assetNameSuffix } = props;
        // Use Auto-Delete S3Bucket if removal policy is DESTROY
        const s3AutoDeleteItems = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        //
        // S3 Bucket for Logging - Usable by many stacks
        //
        this._bucketLogs = new s3.Bucket(this, 'logs', {
            bucketName: props.bucketLogsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        //
        // S3 Buckets for Apps
        //
        this._bucketApps = new s3.Bucket(this, 'apps', {
            bucketName: props.bucketAppsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        this._bucketAppsStaging = new s3.Bucket(this, 'staging', {
            bucketName: props.bucketAppsStagingName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        // Create S3 Origin Identity
        this._bucketAppsOAI = new cf.OriginAccessIdentity(this, 'oai', {
            comment: assetNameRoot !== undefined ? `${assetNameRoot}${assetNameSuffix}` : undefined,
        });
        if (removalPolicy !== undefined) {
            this._bucketAppsOAI.applyRemovalPolicy(removalPolicy);
        }
        // Add Origin for CloudFront
        this._bucketAppsOrigin = new cforigins.S3Origin(this._bucketApps, {
            originAccessIdentity: this.bucketAppsOAI,
        });
    }
    /**
     * (experimental) S3 bucket for deployed applications.
     *
     * @experimental
     */
    get bucketApps() {
        return this._bucketApps;
    }
    /**
     * (experimental) CloudFront Origin Access Identity for the deployed applications bucket.
     *
     * @experimental
     */
    get bucketAppsOAI() {
        return this._bucketAppsOAI;
    }
    /**
     * (experimental) CloudFront Origin for the deployed applications bucket.
     *
     * @experimental
     */
    get bucketAppsOrigin() {
        return this._bucketAppsOrigin;
    }
    /**
     * (experimental) S3 bucket for staged applications (prior to deploy).
     *
     * @experimental
     */
    get bucketAppsStaging() {
        return this._bucketAppsStaging;
    }
    /**
     * (experimental) S3 bucket for CloudFront logs.
     *
     * @experimental
     */
    get bucketLogs() {
        return this._bucketLogs;
    }
}
exports.MicroAppsS3 = MicroAppsS3;
_a = JSII_RTTI_SYMBOL_1;
MicroAppsS3[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroAppsS3", version: "0.2.7" };
//# sourceMappingURL=data:application/json;base64,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