import { RemovalPolicy } from 'aws-cdk-lib';
import * as cf from 'aws-cdk-lib/aws-cloudfront';
import * as cforigins from 'aws-cdk-lib/aws-cloudfront-origins';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * (experimental) Represents a MicroApps S3.
 *
 * @experimental
 */
export interface IMicroAppsS3 {
    /**
     * (experimental) S3 bucket for deployed applications.
     *
     * @experimental
     */
    readonly bucketApps: s3.IBucket;
    /**
     * (experimental) CloudFront Origin Access Identity for the deployed applications bucket.
     *
     * @experimental
     */
    readonly bucketAppsOAI: cf.OriginAccessIdentity;
    /**
     * (experimental) CloudFront Origin for the deployed applications bucket.
     *
     * @experimental
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * (experimental) S3 bucket for staged applications (prior to deploy).
     *
     * @experimental
     */
    readonly bucketAppsStaging: s3.IBucket;
    /**
     * (experimental) S3 bucket for CloudFront logs.
     *
     * @experimental
     */
    readonly bucketLogs: s3.IBucket;
}
/**
 * (experimental) Properties to initialize an instance of `MicroAppsS3`.
 *
 * @experimental
 */
export interface MicroAppsS3Props {
    /**
     * (experimental) RemovalPolicy override for child resources.
     *
     * Note: if set to DESTROY the S3 buckets will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) S3 deployed apps bucket name.
     *
     * @default auto-assigned
     * @experimental
     */
    readonly bucketAppsName?: string;
    /**
     * (experimental) S3 staging apps bucket name.
     *
     * @default auto-assigned
     * @experimental
     */
    readonly bucketAppsStagingName?: string;
    /**
     * (experimental) S3 logs bucket name.
     *
     * @default auto-assigned
     * @experimental
     */
    readonly bucketLogsName?: string;
    /**
     * (experimental) Optional asset name root.
     *
     * @default - resource names auto assigned
     * @experimental
     * @example
     *
     * microapps
     */
    readonly assetNameRoot?: string;
    /**
     * (experimental) Optional asset name suffix.
     *
     * @default none
     * @experimental
     * @example
     *
     * -dev-pr-12
     */
    readonly assetNameSuffix?: string;
}
/**
 * (experimental) Create a new MicroApps S3 Bucket.
 *
 * @experimental
 */
export declare class MicroAppsS3 extends Construct implements IMicroAppsS3 {
    private _bucketApps;
    /**
     * (experimental) S3 bucket for deployed applications.
     *
     * @experimental
     */
    get bucketApps(): s3.IBucket;
    private _bucketAppsOAI;
    /**
     * (experimental) CloudFront Origin Access Identity for the deployed applications bucket.
     *
     * @experimental
     */
    get bucketAppsOAI(): cf.OriginAccessIdentity;
    private _bucketAppsOrigin;
    /**
     * (experimental) CloudFront Origin for the deployed applications bucket.
     *
     * @experimental
     */
    get bucketAppsOrigin(): cforigins.S3Origin;
    private _bucketAppsStaging;
    /**
     * (experimental) S3 bucket for staged applications (prior to deploy).
     *
     * @experimental
     */
    get bucketAppsStaging(): s3.IBucket;
    private _bucketLogs;
    /**
     * (experimental) S3 bucket for CloudFront logs.
     *
     * @experimental
     */
    get bucketLogs(): s3.IBucket;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: MicroAppsS3Props);
}
