import * as apigwy from '@aws-cdk/aws-apigatewayv2-alpha';
import { RemovalPolicy } from 'aws-cdk-lib';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as cf from 'aws-cdk-lib/aws-cloudfront';
import * as cforigins from 'aws-cdk-lib/aws-cloudfront-origins';
import * as r53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * (experimental) Represents a MicroApps CloudFront.
 *
 * @experimental
 */
export interface IMicroAppsCF {
    /**
     * @experimental
     */
    readonly cloudFrontDistro: cf.Distribution;
}
/**
 * (experimental) Properties to initialize an instance of `MicroAppsCF`.
 *
 * @experimental
 */
export interface MicroAppsCFProps {
    /**
     * (experimental) RemovalPolicy override for child resources.
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) S3 bucket origin for deployed applications.
     *
     * @experimental
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * (experimental) S3 bucket for CloudFront logs.
     *
     * @experimental
     */
    readonly bucketLogs?: s3.IBucket;
    /**
     * (experimental) CloudFront Distribution domain name.
     *
     * @default auto-assigned
     * @experimental
     * @example
     *
     * apps.pwrdrvr.com
     */
    readonly domainNameEdge?: string;
    /**
     * (experimental) API Gateway custom origin domain name.
     *
     * @default - retrieved from httpApi, if possible
     * @experimental
     * @example
     *
     * apps.pwrdrvr.com
     */
    readonly domainNameOrigin?: string;
    /**
     * (experimental) API Gateway v2 HTTP API for apps.
     *
     * @experimental
     */
    readonly httpApi: apigwy.HttpApi;
    /**
     * (experimental) Optional asset name root.
     *
     * @default - resource names auto assigned
     * @experimental
     * @example
     *
     * microapps
     */
    readonly assetNameRoot?: string;
    /**
     * (experimental) Optional asset name suffix.
     *
     * @default none
     * @experimental
     * @example
     *
     * -dev-pr-12
     */
    readonly assetNameSuffix?: string;
    /**
     * (experimental) ACM Certificate that covers `domainNameEdge` name.
     *
     * @experimental
     */
    readonly certEdge?: acm.ICertificate;
    /**
     * (experimental) Route53 zone in which to create optional `domainNameEdge` record.
     *
     * @experimental
     */
    readonly r53Zone?: r53.IHostedZone;
    /**
     * (experimental) Path prefix on the root of the CloudFront distribution.
     *
     * @experimental
     * @example
     *
     * dev/
     */
    readonly rootPathPrefix?: string;
    /**
     * (experimental) Create an extra Behavior (Route) for /api/ that allows API routes to have a period in them.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /api/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default true
     * @experimental
     */
    readonly createAPIPathRoute?: boolean;
}
/**
 * (experimental) Options for the `CreateAPIOriginPolicy`.
 *
 * @experimental
 */
export interface CreateAPIOriginPolicyOptions {
    /**
     * (experimental) Optional asset name root.
     *
     * @default - resource names auto assigned
     * @experimental
     * @example
     *
     * microapps
     */
    readonly assetNameRoot?: string;
    /**
     * (experimental) Optional asset name suffix.
     *
     * @default none
     * @experimental
     * @example
     *
     * -dev-pr-12
     */
    readonly assetNameSuffix?: string;
    /**
     * (experimental) Edge domain name used by CloudFront - If set a custom OriginRequestPolicy will be created that prevents the Host header from being passed to the origin.
     *
     * @experimental
     */
    readonly domainNameEdge?: string;
}
/**
 * (experimental) Options for `AddRoutes`.
 *
 * @experimental
 */
export interface AddRoutesOptions {
    /**
     * (experimental) API Gateway CloudFront Origin for API calls.
     *
     * @experimental
     */
    readonly apiGwyOrigin: cf.IOrigin;
    /**
     * (experimental) S3 Bucket CloudFront Origin for static assets.
     *
     * @experimental
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * (experimental) CloudFront Distribution to add the Behaviors (Routes) to.
     *
     * @experimental
     */
    readonly distro: cf.Distribution;
    /**
     * (experimental) Origin Request policy for API Gateway Origin.
     *
     * @experimental
     */
    readonly apigwyOriginRequestPolicy: cf.IOriginRequestPolicy;
    /**
     * (experimental) Path prefix on the root of the CloudFront distribution.
     *
     * @experimental
     * @example
     *
     * dev/
     */
    readonly rootPathPrefix?: string;
    /**
     * (experimental) Create an extra Behavior (Route) for /api/ that allows API routes to have a period in them.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /api/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default true
     * @experimental
     */
    readonly createAPIPathRoute?: boolean;
}
/**
 * (experimental) Create a new MicroApps CloudFront Distribution.
 *
 * @experimental
 */
export declare class MicroAppsCF extends Construct implements IMicroAppsCF {
    /**
     * (experimental) Create or get the origin request policy.
     *
     * If a custom domain name is NOT used for the origin then a policy
     * will be created.
     *
     * If a custom domain name IS used for the origin then the ALL_VIEWER
     * policy will be returned.  This policy passes the Host header to the
     * origin, which is fine when using a custom domain name on the origin.
     *
     * @experimental
     */
    static createAPIOriginPolicy(scope: Construct, props: CreateAPIOriginPolicyOptions): cf.IOriginRequestPolicy;
    /**
     * (experimental) Add API Gateway and S3 routes to an existing CloudFront Distribution.
     *
     * @experimental
     */
    static addRoutes(_scope: Construct, props: AddRoutesOptions): void;
    private _cloudFrontDistro;
    /**
     * @experimental
     */
    get cloudFrontDistro(): cf.Distribution;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: MicroAppsCFProps);
}
