import * as apigwy from '@aws-cdk/aws-apigatewayv2-alpha';
import { RemovalPolicy } from 'aws-cdk-lib';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as r53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
/**
 * (experimental) Properties to initialize an instance of `MicroAppsAPIGwy`.
 *
 * @experimental
 */
export interface MicroAppsAPIGwyProps {
    /**
     * (experimental) RemovalPolicy override for child resources.
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) CloudFront edge domain name.
     *
     * @default auto-assigned
     * @experimental
     * @example
     *
     * apps.pwrdrvr.com
     */
    readonly domainNameEdge?: string;
    /**
     * (experimental) API Gateway origin domain name.
     *
     * @default auto-assigned
     * @experimental
     * @example
     *
     * apps-origin.pwrdrvr.com
     */
    readonly domainNameOrigin?: string;
    /**
     * (experimental) Optional asset name root.
     *
     * @default - resource names auto assigned
     * @experimental
     * @example
     *
     * microapps
     */
    readonly assetNameRoot?: string;
    /**
     * (experimental) Optional asset name suffix.
     *
     * @default none
     * @experimental
     * @example
     *
     * -dev-pr-12
     */
    readonly assetNameSuffix?: string;
    /**
     * (experimental) Optional local region ACM certificate to use for API Gateway Note: required when using a custom domain.
     *
     * @default none
     * @experimental
     */
    readonly certOrigin?: acm.ICertificate;
    /**
     * (experimental) Route53 zone in which to create optional `domainNameEdge` record.
     *
     * @experimental
     */
    readonly r53Zone?: r53.IHostedZone;
    /**
     * (experimental) Path prefix on the root of the API Gateway Stage.
     *
     * @default none
     * @experimental
     * @example
     *
     * dev/
     */
    readonly rootPathPrefix?: string;
}
/**
 * (experimental) Represents a MicroApps API Gateway.
 *
 * @experimental
 */
export interface IMicroAppsAPIGwy {
    /**
     * (experimental) Domain Name applied to API Gateway origin.
     *
     * @experimental
     */
    readonly dnAppsOrigin?: apigwy.IDomainName;
    /**
     * (experimental) API Gateway.
     *
     * @experimental
     */
    readonly httpApi: apigwy.HttpApi;
}
/**
 * (experimental) Create a new MicroApps API Gateway HTTP API endpoint.
 *
 * @experimental
 */
export declare class MicroAppsAPIGwy extends Construct implements IMicroAppsAPIGwy {
    private _dnAppsOrigin;
    /**
     * (experimental) Domain Name applied to API Gateway origin.
     *
     * @experimental
     */
    get dnAppsOrigin(): apigwy.IDomainName | undefined;
    private _httpApi;
    /**
     * (experimental) API Gateway.
     *
     * @experimental
     */
    get httpApi(): apigwy.HttpApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: MicroAppsAPIGwyProps);
}
