import { RemovalPolicy } from 'aws-cdk-lib';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as r53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
import { IMicroAppsAPIGwy } from './MicroAppsAPIGwy';
import { IMicroAppsCF } from './MicroAppsCF';
import { IMicroAppsS3 } from './MicroAppsS3';
import { IMicroAppsSvcs } from './MicroAppsSvcs';
/**
 * (experimental) Properties to initialize an instance of `MicroApps`.
 *
 * @experimental
 */
export interface MicroAppsProps {
    /**
     * (experimental) RemovalPolicy override for child resources.
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Passed to NODE_ENV of Router and Deployer Lambda functions.
     *
     * @default dev
     * @experimental
     */
    readonly appEnv: string;
    /**
     * (experimental) Optional asset name root.
     *
     * @default - resource names auto assigned
     * @experimental
     * @example
     *
     * microapps
     */
    readonly assetNameRoot?: string;
    /**
     * (experimental) Optional asset name suffix.
     *
     * @default none
     * @experimental
     * @example
     *
     * -dev-pr-12
     */
    readonly assetNameSuffix?: string;
    /**
     * (experimental) Route53 zone in which to create optional `domainNameEdge` record.
     *
     * @experimental
     */
    readonly r53Zone?: r53.IHostedZone;
    /**
     * (experimental) Certificate in US-East-1 for the CloudFront distribution.
     *
     * @experimental
     */
    readonly certEdge?: acm.ICertificate;
    /**
     * (experimental) Certificate in deployed region for the API Gateway.
     *
     * @experimental
     */
    readonly certOrigin?: acm.ICertificate;
    /**
     * (experimental) Use a strict S3 Bucket Policy that prevents applications from reading/writing/modifying/deleting files in the S3 Bucket outside of the path that is specific to their app/version.
     *
     * This setting should be used when applications are less than
     * fully trusted.
     *
     * @default false
     * @experimental
     */
    readonly s3StrictBucketPolicy?: boolean;
    /**
     * (experimental) Applies when using s3StrictBucketPolicy = true.
     *
     * IAM Role or IAM User names to exclude from the DENY rules on the S3 Bucket Policy.
     *
     * Roles that are Assumed must instead have their AROA added to `s3PolicyBypassAROAs`.
     *
     * Typically any admin roles / users that need to view or manage the S3 Bucket
     * would be added to this list.
     *
     * @see s3PolicyBypassAROAs
     * @experimental
     * @example
     *
     * ['arn:aws:iam::1234567890123:role/AdminAccess', 'arn:aws:iam::1234567890123:user/MyAdminUser']
     */
    readonly s3PolicyBypassPrincipalARNs?: string[];
    /**
     * (experimental) Applies when using s3StrictBucketPolicy = true.
     *
     * AROAs of the IAM Role to exclude from the DENY rules on the S3 Bucket Policy.
     * This allows sessions that assume the IAM Role to be excluded from the
     * DENY rules on the S3 Bucket Policy.
     *
     * Typically any admin roles / users that need to view or manage the S3 Bucket
     * would be added to this list.
     *
     * Roles / users that are used directly, not assumed, can be added to `s3PolicyBypassRoleNames` instead.
     *
     * Note: This AROA must be specified to prevent this policy from locking
     * out non-root sessions that have assumed the admin role.
     *
     * The notPrincipals will only match the role name exactly and will not match
     * any session that has assumed the role since notPrincipals does not allow
     * wildcard matches and does not do wildcard matches implicitly either.
     *
     * The AROA must be used because there are only 3 Principal variables available:
     *   https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable
     *   aws:username, aws:userid, aws:PrincipalTag
     *
     * For an assumed role, aws:username is blank, aws:userid is:
     *   [unique id AKA AROA for Role]:[session name]
     *
     * Table of unique ID prefixes such as AROA:
     *   https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-prefixes
     *
     * The name of the role is simply not available for an assumed role and, if it was,
     * a complicated comparison would be requierd to prevent exclusion
     * of applying the Deny Rule to roles from other accounts.
     *
     * To get the AROA with the AWS CLI:
     *    aws iam get-role --role-name ROLE-NAME
     *    aws iam get-user -–user-name USER-NAME
     *
     * @see s3StrictBucketPolicy
     * @experimental
     * @example
     *
     * [ 'AROA1234567890123' ]
     */
    readonly s3PolicyBypassAROAs?: string[];
    /**
     * (experimental) Optional custom domain name for the CloudFront distribution.
     *
     * @default auto-assigned
     * @experimental
     * @example
     *
     * apps.pwrdrvr.com
     */
    readonly domainNameEdge?: string;
    /**
     * (experimental) Optional custom domain name for the API Gateway HTTPv2 API.
     *
     * @default auto-assigned
     * @experimental
     * @example
     *
     * apps-origin.pwrdrvr.com
     */
    readonly domainNameOrigin?: string;
    /**
     * (experimental) Path prefix on the root of the CloudFront distribution.
     *
     * @experimental
     * @example
     *
     * dev/
     */
    readonly rootPathPrefix?: string;
    /**
     * (experimental) Create an extra Behavior (Route) for /api/ that allows API routes to have a period in them.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /api/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default true
     * @experimental
     */
    readonly createAPIPathRoute?: boolean;
}
/**
 * (experimental) Represents a MicroApps.
 *
 * @experimental
 */
export interface IMicroApps {
    /**
     * (experimental) {@inheritdoc IMicroAppsCF}.
     *
     * @experimental
     */
    readonly cf: IMicroAppsCF;
    /**
     * (experimental) {@inheritdoc IMicroAppsS3}.
     *
     * @experimental
     */
    readonly s3: IMicroAppsS3;
    /**
     * (experimental) {@inheritdoc IMicroAppsSvcs}.
     *
     * @experimental
     */
    readonly svcs: IMicroAppsSvcs;
    /**
     * (experimental) {@inheritdoc IMicroAppsAPIGwy}.
     *
     * @experimental
     */
    readonly apigwy: IMicroAppsAPIGwy;
}
/**
 * (experimental) Create a new MicroApps "turnkey" construct for simple deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 * @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 * @experimental
 */
export declare class MicroApps extends Construct implements IMicroApps {
    private _cf;
    /**
     * (experimental) {@inheritdoc IMicroAppsCF}.
     *
     * @experimental
     */
    get cf(): IMicroAppsCF;
    private _s3;
    /**
     * (experimental) {@inheritdoc IMicroAppsS3}.
     *
     * @experimental
     */
    get s3(): IMicroAppsS3;
    private _apigwy;
    /**
     * (experimental) {@inheritdoc IMicroAppsAPIGwy}.
     *
     * @experimental
     */
    get apigwy(): IMicroAppsAPIGwy;
    private _svcs;
    /**
     * (experimental) {@inheritdoc IMicroAppsSvcs}.
     *
     * @experimental
     */
    get svcs(): IMicroAppsSvcs;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: MicroAppsProps);
}
