PROTOCOL_TYPES = ("Tcp", "Udp", "Tls", "Https", "Quic")
COMMON_RECORD_TYPES = ("A", "AAAA", "CNAME", "MX", "NS", "PTR", "SOA", "SRV",  "TXT")

RECORD_TYPES = {
    "A": "IPv4 address",
    "AAAA": "IPv6 address",
    "AFSDB": "AFS database location",
    "APL": "Address prefix list",
    "AXFR": "Authoritative zone transfer",
    "CAA": "Certification authority authorization",
    "CDNSKEY": "Child copy of a DNSKEY",
    "CDS": "Child copy of DS",
    "CERT": "Cryptographic certificate",
    "CNAME": "Canonical name",
    "CSYNC": "Child-to-parent synchronization",
    "DHCID": "DHCP identifier",
    "DLV": "DNSSEC lookaside validation",
    "DNAME": "Delegation name",
    "DNSKEY": "Cryptographic key for DNSSEC",
    "DS": "Delegation signer",
    "EUI48": "MAC address (EUI-48)",
    "EUI64": "Mac address (EUI-64)",
    "HINFO": "Host information",
    "HIP": "Host identification protocol",
    "HTTPS": "HTTPS binding",
    "IPSECKEY": "Cryptographic key for IPsec",
    "IXFR": "Incremental zone transfer",
    "KEY": "Cryptographic key for DNSSEC (obsoleted by DNSKEY)",
    "KX": "Key exchange",
    "LOC": "Geographical location",
    "MX": "Mail exchange",
    "NAPTR": "Naming authority pointer",
    "NS": "Name server",
    "NSEC3": "Next secure (version 3)",
    "NSEC3PARAM": "Parameter for NSEC3",
    "NSEC": "Next secure (obsoleted by NSEC3)",
    "NXT": "DNSSEC key (obsoleted by NSEC)",
    "OPENPGPKEY": "Public key for OpenPGP",
    "OPT": "EDNS option",
    "PTR": "Canonical name pointer",
    "RP": "Responsible person",
    "RRSIG": "Resource record signature for DNSSEC",
    "SIG": "Resource record signature for DNSSEC (obsoleted by RRSIG)",
    "SMIMEA": "S/MIME association",
    "SOA": "Start of authority",
    "SSHFP": "Public key fingerprint for SSH",
    "SVCB": "Service binding",
    "SRV": "Service locator",
    "TA": "Trust authority for DNSSEC",
    "TKEY": "Transaction key",
    "TLSA": "Certificate association for TLS",
    "TSIG": "Transaction signature",
    "TXT": "Human-readable text",
    "URI": "Uniform resource identifier",
    "ZONEMD": "Message digest for DNS zones",
}

HELP_FOR_STATS = {
    "technitium_stats_total_queries": "Total number of DNS queries received by the server",
    "technitium_stats_total_no_error": "Total number of queries resolved without error",
    "technitium_stats_total_server_failure": "Total number of queries with SERVFAIL result",
    "technitium_stats_total_nx_domain": "Total number of queries with NXDOMAIN result",
    "technitium_stats_total_refused": "Total number of queries refused",
    "technitium_stats_total_authoritative": "Total number of queries resolved as authoritative",
    "technitium_stats_total_recursive": "Total number of queries resolved recursively",
    "technitium_stats_total_cached": "Total number of results cached",
    "technitium_stats_total_blocked": "Total number of queries blocked",
    "technitium_stats_total_dropped": "Total number of queries dropped",
    "technitium_stats_total_clients": "Number of clients using the DNS",
    "technitium_stats_zones": "Number of zones managed by the DNS",
    "technitium_stats_cached_entries": "Number of DNS entries cached by the server",
    "technitium_stats_allowed_zones": "Number of zones explicitely allowed by the DNS",
    "technitium_stats_blocked_zones": "Number of zones blocked by the DNS",
    "technitium_stats_allow_list_zones": "Number of zones in the allow lists of the DNS",
    "technitium_stats_block_list_zones": "Number of zones in the block lists of the DNS",
}