# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 image_name: pulumi.Input[str],
                 project_id: str,
                 service_name: str):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] image_name: The name of the image to deploy to cloudrun
        :param str project_id: The project in which to create the cloudrun resources
        :param str service_name: The name of the cloudrun service
        """
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[str]:
        """
        The name of the image to deploy to cloudrun
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project in which to create the cloudrun resources
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: str):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the cloudrun service
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: str):
        pulumi.set(self, "service_name", value)


class Deployment(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[str] = None,
                 service_name: Optional[str] = None,
                 __props__=None):
        """
        Create a Deployment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] image_name: The name of the image to deploy to cloudrun
        :param str project_id: The project in which to create the cloudrun resources
        :param str service_name: The name of the cloudrun service
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Deployment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[str] = None,
                 service_name: Optional[str] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if image_name is None and not opts.urn:
                raise TypeError("Missing required property 'image_name'")
            __props__.__dict__["image_name"] = image_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["ip_address"] = None
        super(Deployment, __self__).__init__(
            'globalgcpcloudrun:index:deployment',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP Address of the global service
        """
        return pulumi.get(self, "ip_address")

