# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _doordeck_headless_sdk
else:
    import _doordeck_headless_sdk

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



import json
import uuid
import time
import dataclasses
import typing
import base64
import asyncio
import ctypes
from types import SimpleNamespace
from typing import List, Optional
from dataclasses import dataclass, field


class SdkException(Exception):
    def __init__(self, message: str, exception: Exception = None):
        super().__init__(message)
        self.exception = exception


class MissingContextFieldException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class MissingAndroidContextException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class BatchShareFailedException(SdkException):
    def __init__(self, message: str, user_ids: list):
        super().__init__(message, user_ids)
        self.user_ids = user_ids


class BadRequestException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class UnauthorizedException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class ForbiddenException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class NotFoundException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class MethodNotAllowedException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class NotAcceptableException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class ConflictException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class GoneException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class LockedException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class TooEarlyException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class TooManyRequestsException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class InternalServerErrorException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class ServiceUnavailableException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


class GatewayTimeoutException(SdkException):
    def __init__(self, message: str):
        super().__init__(message)


def current_epoch_seconds() -> int:
    return int(time.time())

def decode_base64_to_byte_array(input):
    return base64.b64decode(input)

def encode_byte_array_to_base64(input):
    return base64.b64encode(input).decode('utf-8')

def certificate_chain_to_string(input):
    return '|'.join(input)

def string_to_certificate_chain(input):
    return input.split('|')

def handle_exception(response):
    if response.failure is None:
        return
    exception_type = response.failure.exceptionType
    exception_message = response.failure.exceptionMessage
    if "SdkException" in exception_type:
        raise SdkException(exception_message)
    if "MissingContextFieldException" in exception_type:
        raise MissingContextFieldException(exception_message)
    if "BatchShareFailedException" in exception_type:
        raise BatchShareFailedException(exception_message, [])
    if "BadRequestException" in exception_type:
        raise BadRequestException(exception_message)
    if "UnauthorizedException" in exception_type:
        raise UnauthorizedException(exception_message)
    if "ForbiddenException" in exception_type:
        raise ForbiddenException(exception_message)
    if "NotFoundException" in exception_type:
        raise NotFoundException(exception_message)
    if "MethodNotAllowedException" in exception_type:
        raise MethodNotAllowedException(exception_message)
    if "NotAcceptableException" in exception_type:
        raise NotAcceptableException(exception_message)
    if "ConflictException" in exception_type:
        raise ConflictException(exception_message)
    if "GoneException" in exception_type:
        raise GoneException(exception_message)
    if "LockedException" in exception_type:
        raise LockedException(exception_message)
    if "TooEarlyException" in exception_type:
        raise TooEarlyException(exception_message)
    if "TooManyRequestsException" in exception_type:
        raise TooManyRequestsException(exception_message)
    if "InternalServerErrorException" in exception_type:
        raise InternalServerErrorException(exception_message)
    if "ServiceUnavailableException" in exception_type:
        raise ServiceUnavailableException(exception_message)
    if "GatewayTimeoutException" in exception_type:
        raise GatewayTimeoutException(exception_message)
    raise SdkException("Unhandled exception type: " + exception_type)

def object_hook(d):
    return SimpleNamespace(**{k: (object_hook(v) if isinstance(v, dict) else v) for k, v in d.items()})

py_callback_type = ctypes.CFUNCTYPE(None, ctypes.c_char_p)

async def execute_async(sdk_func, args):
    loop = asyncio.get_running_loop()
    future = loop.create_future()

    def callback(result):
        try:
            response = json.loads(result, object_hook=object_hook)
            handle_exception(response)
            loop.call_soon_threadsafe(future.set_result, response.success.result)
        except Exception as e:
            loop.call_soon_threadsafe(future.set_exception, e)

    f = py_callback_type(callback)
    f_ptr = ctypes.cast(f, ctypes.c_void_p).value

    sdk_func(*args, f_ptr)
    return await future


@dataclass
class LockController:
    type: str = field(init=False)

@dataclass
class AlpetaController(LockController):
    type: str = field(init=False)
    username: str
    password: str
    doorId: int
    baseUrl: str = None

    def __post_init__(self):
        self.type = "alpeta"

@dataclass
class AmagController(LockController):
    type: str = field(init=False)
    username: str
    password: str
    doorId: int
    baseUrl: str = None

    def __post_init__(self):
        self.type = "amag"

@dataclass
class AssaAbloyController(LockController):
    type: str = field(init=False)
    baseUrl: str
    doorId: str

    def __post_init__(self):
        self.type = "assa-abloy"

@dataclass
class AvigilonController(LockController):
    type: str = field(init=False)
    baseUrl: str
    username: str
    password: str
    doorId: str

    def __post_init__(self):
        self.type = "avigilon"

@dataclass
class AxisController(LockController):
    type: str = field(init=False)
    baseUrl: str
    doorIdentifier: str

    def __post_init__(self):
        self.type = "axis"

@dataclass
class CCureController(LockController):
    type: str = field(init=False)
    baseUrl: str
    username: str
    password: str
    doorType: str
    doorId: int

    def __post_init__(self):
        self.type = "ccure"

@dataclass
class DemoController(LockController):
    type: str = field(init=False)
    port: int = 8080

    def __post_init__(self):
        self.type = "demo"

@dataclass
class GallagherController(LockController):
    type: str = field(init=False)
    apiKey: str
    doorId: str
    baseUrl: Optional[str] = None

    def __post_init__(self):
        self.type = "gallagher"

@dataclass
class GenetecController(LockController):
    type: str = field(init=False)
    baseUrl: str
    username: str
    password: str
    doorId: str

    def __post_init__(self):
        self.type = "genetec"

@dataclass
class LenelController(LockController):
    type: str = field(init=False)
    baseUrl: str
    username: str
    password: str
    directoryId: str
    panelId: str
    readerId: str

    def __post_init__(self):
        self.type = "lenel"

@dataclass
class MitrefinchController(LockController):
    type: str = field(init=False)
    host: str
    output: int

    def __post_init__(self):
        self.type = "mitrefinch"

@dataclass
class PaxtonNet2Controller(LockController):
    type: str = field(init=False)
    host: str
    username: Optional[str] = None
    password: Optional[str] = None
    address: str
    output: int

    def __post_init__(self):
        self.type = "net2"

@dataclass
class Paxton10Controller(LockController):
    type: str = field(init=False)
    baseUrl: str
    username: str
    password: str
    applianceId: int

    def __post_init__(self):
        self.type = "paxton10"

@dataclass
class IntegraV1Controller(LockController):
    type: str = field(init=False)
    username: str
    password: str
    controllerId: int

    def __post_init__(self):
        self.type = "integra"

@dataclass
class IntegraV2Controller(LockController):
    type: str = field(init=False)
    baseUrl: str
    sessionId: str
    controllerId: int
    cardholderId: int
    pinCode: Optional[int] = None

    def __post_init__(self):
        self.type = "integra-v2"

@dataclass
class DataSource:
    driverClass: str
    url: str
    user: str
    password: str

@dataclass
class PacController(LockController):
    type: str = field(init=False)
    dataSource: DataSource
    outputChannel: int
    controllerSerial: int

    def __post_init__(self):
        self.type = "pac512"

@dataclass
class TdsiExgardeController(LockController):
    type: str = field(init=False)
    username: str
    password: str
    doorId: int
    dbUrl: Optional[str] = None

    def __post_init__(self):
        self.type = "tdsi-exgarde"

@dataclass
class TdsiGardisController(LockController):
    type: str = field(init=False)
    host: str
    username: str
    password: str
    doorId: int

    def __post_init__(self):
        self.type = "tdsi-gardis"

@dataclass
class ZktecoController(LockController):
    type: str = field(init=False)
    clientSecret: str
    doorId: str
    entityType: typing.Literal["DOOR", "FLOOR"]
    baseUrl: str = None

    def __post_init__(self):
        self.type = "zkteco-zkbio-cvsecurity"



@dataclass
class TimeRequirement:
    start: str
    end: str
    timezone: str
    days: typing.List[str]

@dataclass
class LocationRequirement:
    latitude: float
    longitude: float
    enabled: typing.Optional[bool] = None
    radius: typing.Optional[int] = None
    accuracy: typing.Optional[int] = None

@dataclass
class ShareLock:
    targetUserId: str
    targetUserRole: typing.Literal["ADMIN", "USER"]
    targetUserPublicKey: str
    start: typing.Optional[int] = None
    end: typing.Optional[int] = None

@dataclass
class BaseOperation:
    lockId: str
    userId: typing.Optional[str] = None
    userCertificateChain: typing.Optional[typing.List[str]] = None
    userPrivateKey: typing.Optional[str] = None
    notBefore: int = field(default_factory=current_epoch_seconds)
    issuedAt: int = field(default_factory=current_epoch_seconds)
    expiresAt: int = field(default_factory=lambda: current_epoch_seconds() + 60)  # 1 minute from now
    jti: str = field(default_factory=lambda: str(uuid.uuid4()))

@dataclass
class ShareLockOperation:
    baseOperation: BaseOperation
    shareLock: ShareLock

@dataclass
class BatchShareLockOperation:
    baseOperation: BaseOperation
    users: typing.List[ShareLock]

@dataclass
class RevokeAccessToLockOperation:
    baseOperation: BaseOperation
    users: typing.List[str]

@dataclass
class UpdateSecureSettingUnlockDuration:
    baseOperation: BaseOperation
    unlockDuration: int

@dataclass
class UnlockBetween:
    start: str
    end: str
    timezone: str
    days: typing.List[str]
    exceptions: typing.Optional[typing.List[str]] = None

@dataclass
class UnlockOperation:
    baseOperation: BaseOperation
    directAccessEndpoints: typing.Optional[typing.List[str]] = None

@dataclass
class UpdateSecureSettingUnlockBetween:
    baseOperation: BaseOperation
    unlockBetween: typing.Optional[UnlockBetween] = None


@dataclass
class EmailCallToAction:
    actionTarget: str
    headline: str
    actionText: str

@dataclass
class EmailPreferences:
    senderEmail: typing.Optional[str] = None
    senderName: typing.Optional[str] = None
    primaryColour: typing.Optional[str] = None
    secondaryColour: typing.Optional[str] = None
    onlySendEssentialEmails: typing.Optional[bool] = None
    callToAction: typing.Optional[EmailCallToAction] = None

@dataclass
class CreateApplication:
    name: str
    companyName: str
    mailingAddress: str
    privacyPolicy: typing.Optional[str] = None
    supportContact: typing.Optional[str] = None
    appLink: typing.Optional[str] = None
    emailPreferences: typing.Optional[EmailPreferences] = None
    logoUrl: typing.Optional[str] = None

@dataclass
class AuthKey:
    use: str
    kid: str
    alg: typing.Optional[str]
    kty: str = field(init=False)

@dataclass
class RsaKey(AuthKey):
    kty: str
    p: str
    q: str
    d: str
    e: str
    qi: str
    dp: str
    dq: str
    n: str

    def __post_init__(self):
        self.kty = "RSA"

@dataclass
class EcKey(AuthKey):
    kty: str
    d: str
    crv: str
    x: str
    y: str

    def __post_init__(self):
        self.kty = "EC"

@dataclass
class Ed25519Key(AuthKey):
    kty: str
    d: str
    crv: str
    x: str

    def __post_init__(self):
        self.kty = "OKP"


class Account(object):

    def __init__(self, resource):
        self.resource = resource

    async def refresh_token(self, refreshToken: str):
        data = { "refreshToken": refreshToken }
        return await execute_async(
            _doordeck_headless_sdk.refreshToken,
            [self.resource, json.dumps(data)]
        )

    async def logout(self):
        return await execute_async(
            _doordeck_headless_sdk.logout,
            [self.resource]
        )

    async def register_ephemeral_key(self, publicKey: str):
        data = { "publicKey": publicKey }
        return await execute_async(
            _doordeck_headless_sdk.registerEphemeralKey,
            [self.resource, json.dumps(data)]
        )

    async def register_ephemeral_key_with_secondary_authentication(self, publicKey: str, method: Optional[typing.Literal["EMAIL", "TELEPHONE", "SMS"]] = None):
        data = {
            "publicKey": publicKey,
            "method": method
        }
        return await execute_async(
            _doordeck_headless_sdk.registerEphemeralKeyWithSecondaryAuthentication,
            [self.resource, json.dumps(data)]
        )

    async def verify_ephemeral_key_registration(self, code: str, privateKey: str = None):
        data = {
            "code": code,
            "privateKey": privateKey
        }
        return await execute_async(
            _doordeck_headless_sdk.verifyEphemeralKeyRegistration,
            [self.resource, json.dumps(data)]
        )

    async def reverify_email(self):
        return await execute_async(
            _doordeck_headless_sdk.reverifyEmail,
            [self.resource]
        )

    async def change_password(self, oldPassword: str, newPassword: str):
        data = {
           "oldPassword": oldPassword,
           "newPassword": newPassword
        }
        return await execute_async(
            _doordeck_headless_sdk.changePassword,
            [self.resource, json.dumps(data)]
        )

    async def get_user_details(self):
        return await execute_async(
            _doordeck_headless_sdk.getUserDetails,
            [self.resource]
        )

    async def update_user_details(self, displayName: str):
        data = { "displayName": displayName }
        return await execute_async(
            _doordeck_headless_sdk.updateUserDetails,
            [self.resource, json.dumps(data)]
        )

    async def delete_account(self):
        return await execute_async(
            _doordeck_headless_sdk.deleteAccount,
            [self.resource]
        )


class Accountless(object):

    def __init__(self, resource):
        self.resource = resource

    async def login(self, email: str, password: str):
        data = {
            "email": email,
            "password": password
        }
        return await execute_async(
            _doordeck_headless_sdk.login,
            [self.resource, json.dumps(data)]
        )

    async def registration(self, email: str, password: str, force: bool = False, displayName: str = None, publicKey: str = None):
        data = {
            "email": email,
            "password": password,
            "force": force,
            "publicKey": publicKey,
            "displayName": displayName
        }
        return await execute_async(
            _doordeck_headless_sdk.registration,
            [self.resource, json.dumps(data)]
        )

    async def verify_email(self, code: str):
        data = { "code": code }
        return await execute_async(
            _doordeck_headless_sdk.verifyEmail,
            [self.resource, json.dumps(data)]
        )

    async def password_reset(self, email: str):
        data = { "email": email }
        return await execute_async(
            _doordeck_headless_sdk.passwordReset,
            [self.resource, json.dumps(data)]
        )

    async def password_reset_verify(self, userId: str, token: str, password: str):
        data = {
            "userId": userId,
            "token": token,
            "password": password
        }
        return await execute_async(
            _doordeck_headless_sdk.passwordResetVerify,
            [self.resource, json.dumps(data)]
        )


class ContextManager(object):

    def __init__(self, resource):
        self.resource = resource

    def get_api_environment(self):
        env = _doordeck_headless_sdk.getApiEnvironment(self.resource)
        name = _doordeck_headless_sdk.getApiEnvironmentName(env)
        return name

    def set_cloud_auth_token(self, token: str):
        _doordeck_headless_sdk.setCloudAuthToken(self.resource, token)

    def get_cloud_auth_token(self):
        return _doordeck_headless_sdk.getCloudAuthToken(self.resource)

    def is_cloud_auth_token_about_to_expire(self):
        return _doordeck_headless_sdk.isCloudAuthTokenAboutToExpire(self.resource)

    def set_cloud_refresh_token(self, token: str):
        _doordeck_headless_sdk.setCloudRefreshToken(self.resource, token)

    def get_cloud_refresh_token(self):
        return _doordeck_headless_sdk.getCloudRefreshToken(self.resource)

    def set_fusion_host(self, host: str):
        _doordeck_headless_sdk.setFusionHost(self.resource, host)

    def get_fusion_host(self):
        return _doordeck_headless_sdk.getFusionHost(self.resource)

    def set_fusion_auth_token(self, token: str):
        _doordeck_headless_sdk.setFusionAuthToken(self.resource, token)

    def get_fusion_auth_token(self):
        return _doordeck_headless_sdk.getFusionAuthToken(self.resource)

    def set_user_id(self, userId: str):
        _doordeck_headless_sdk.setUserId(self.resource, userId)

    def get_user_id(self):
        return _doordeck_headless_sdk.getUserId(self.resource)

    def set_user_email(self, email: str):
        _doordeck_headless_sdk.setUserEmail(self.resource, email)

    def get_user_email(self):
        return _doordeck_headless_sdk.getUserEmail(self.resource)

    def is_certificate_chain_about_to_expire(self):
        return _doordeck_headless_sdk.isCertificateChainAboutToExpire(self.resource)

    def is_key_pair_valid(self):
        return _doordeck_headless_sdk.isKeyPairValid(self.resource)

    def set_operation_context(self, userId: str, userCertificateChain: str, userPublicKey: str, userPrivateKey: str):
        data = {
            "userId": userId,
            "userCertificateChain": userCertificateChain,
            "userPublicKey": userPublicKey,
            "userPrivateKey": userPrivateKey
        }
        _doordeck_headless_sdk.setOperationContextJson(self.resource, json.dumps(data))

    def clear_context(self):
        _doordeck_headless_sdk.clearContext(self.resource)


class CryptoManager(object):

    def __init__(self, resource):
        self.resource = resource

    def generate_key_pair(self):
        return json.loads(_doordeck_headless_sdk.generateEncodedKeyPair(self.resource), object_hook=object_hook)


class Fusion(object):

    def __init__(self, resource):
        self.resource = resource

    async def login(self, email: str, password: str):
        data = {
            "email": email,
            "password": password
        }
        return await execute_async(
            _doordeck_headless_sdk.loginFusion,
            [self.resource, json.dumps(data)]
        )

    async def get_integration_type(self):
        return await execute_async(
            _doordeck_headless_sdk.getIntegrationType,
            [self.resource]
        )

    async def get_integration_configuration(self, type: str):
        data = { "type": type }
        return await execute_async(
            _doordeck_headless_sdk.getIntegrationConfiguration,
            [self.resource, json.dumps(data)]
        )

    async def enable_door(self, name: str, siteId: str, controller: LockController):
        data = {
            "name": name,
            "siteId": siteId,
            "controller": dataclasses.asdict(controller)
        }
        return await execute_async(
            _doordeck_headless_sdk.enableDoor,
            [self.resource, json.dumps(data)]
        )

    async def delete_door(self, deviceId: str):
        data = { "deviceId": deviceId }
        return await execute_async(
            _doordeck_headless_sdk.deleteDoor,
            [self.resource, json.dumps(data)]
        )

    async def get_door_status(self, deviceId: str):
        data = { "deviceId": deviceId }
        return await execute_async(
            _doordeck_headless_sdk.getDoorStatus,
            [self.resource, json.dumps(data)]
        )

    async def start_door(self, deviceId: str):
        data = { "deviceId": deviceId }
        return await execute_async(
            _doordeck_headless_sdk.startDoor,
            [self.resource, json.dumps(data)]
        )

    async def stop_door(self, deviceId: str):
        data = { "deviceId": deviceId }
        return await execute_async(
            _doordeck_headless_sdk.stopDoor,
            [self.resource, json.dumps(data)]
        )


class Helper(object):

    def __init__(self, resource):
        self.resource = resource

    async def upload_platform_logo(self, applicationId: str, contentType: str, image: str):
        data = {
            "applicationId": applicationId,
            "contentType": contentType,
            "image": image
        }
        return await execute_async(
            _doordeck_headless_sdk.uploadPlatformLogo,
            [self.resource, json.dumps(data)]
        )

    async def assisted_login(self, email: str, password: str):
        data = {
            "email": email,
            "password": password
        }
        return await execute_async(
            _doordeck_headless_sdk.assistedLogin,
            [self.resource, json.dumps(data)]
        )

    async def assisted_register_ephemeral_key(self, publicKey: str):
        data = { "publicKey": publicKey }
        return await execute_async(
            _doordeck_headless_sdk.assistedRegisterEphemeralKey,
            [self.resource, json.dumps(data)]
        )

    async def assisted_register(self, email: str, password: str, force: bool = False, displayName: str = None):
        data = {
            "email": email,
            "password": password,
            "displayName": displayName,
            "force": force
        }
        return await execute_async(
            _doordeck_headless_sdk.assistedRegister,
            [self.resource, json.dumps(data)]
        )


class LockOperations(object):

    def __init__(self, resource):
        self.resource = resource

    async def get_single_lock(self, lockId: str):
        data = { "lockId": lockId }
        return await execute_async(
            _doordeck_headless_sdk.getSingleLock,
            [self.resource, json.dumps(data)]
        )

    async def get_lock_audit_trail(self, lockId: str, start: int, end: int):
        data = {
            "lockId": lockId,
            "start": start,
            "end": end
        }
        return await execute_async(
            _doordeck_headless_sdk.getLockAuditTrail,
            [self.resource, json.dumps(data)]
        )

    async def get_audit_for_user(self, lockId: str, start: int, end: int):
        data = {
            "lockId": lockId,
            "start": start,
            "end": end
        }
        return await execute_async(
            _doordeck_headless_sdk.getAuditForUser,
            [self.resource, json.dumps(data)]
        )

    async def get_users_for_lock(self, userId: str):
        data = { "userId": userId }
        return await execute_async(
            _doordeck_headless_sdk.getUsersForLock,
            [self.resource, json.dumps(data)]
        )

    async def get_locks_for_user(self, userId: str):
        data = { "userId": userId }
        return await execute_async(
            _doordeck_headless_sdk.getLocksForUser,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_name(self, lockId: str, name: str = None):
        data = {
            "lockId": lockId,
            "name": name
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockName,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_favourite(self, lockId: str, favourite: bool = None):
        data = {
            "lockId": lockId,
            "favourite": favourite
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockFavourite,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_colour(self, lockId: str, colour: str = None):
        data = {
            "lockId": lockId,
            "colour": colour
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockColour,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_setting_default_name(self, lockId: str, name: str = None):
        data = {
            "lockId": lockId,
            "name": name
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockSettingDefaultName,
            [self.resource, json.dumps(data)]
        )

    async def set_lock_setting_permitted_addresses(self, lockId: str, permittedAddresses: List[str]):
        data = {
            "lockId": lockId,
            "permittedAddresses": permittedAddresses
        }
        return await execute_async(
            _doordeck_headless_sdk.setLockSettingPermittedAddresses,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_setting_hidden(self, lockId: str, hidden: bool):
        data = {
            "lockId": lockId,
            "hidden": hidden
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockSettingHidden,
            [self.resource, json.dumps(data)]
        )

    async def set_lock_setting_time_restrictions(self, lockId: str, times: List[TimeRequirement]):
        data = {
            "lockId": lockId,
            "times": dataclasses.asdict(times)
        }
        return await execute_async(
            _doordeck_headless_sdk.setLockSettingTimeRestrictions,
            [self.resource, json.dumps(data)]
        )

    async def update_lock_setting_location_restrictions(self, lockId: str, location: LocationRequirement = None):
        data = {
            "lockId": lockId,
            "location": dataclasses.asdict(location)
        }
        return await execute_async(
            _doordeck_headless_sdk.updateLockSettingLocationRestrictions,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key(self, userEmail: str, visitor: bool = False):
        data = {
            "userEmail": userEmail,
            "visitor": visitor
        }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKey,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_email(self, email: str):
        data = { "email": email }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByEmail,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_telephone(self, telephone: str):
        data = { "telephone": telephone }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByTelephone,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_local_key(self, localKey: str):
        data = { "localKey": localKey }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByLocalKey,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_foreign_key(self, foreignKey: str):
        data = { "foreignKey": foreignKey }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByForeignKey,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_identity(self, identity: str):
        data = { "identity": identity }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByIdentity,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_emails(self, emails: List[str]):
        data = { "emails": emails }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByEmails,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_telephones(self, telephones: List[str]):
        data = { "telephones": telephones }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByTelephones,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_local_keys(self, localKeys: List[str]):
        data = { "localKeys": localKeys }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByLocalKeys,
            [self.resource, json.dumps(data)]
        )

    async def get_user_public_key_by_foreign_keys(self, foreignKeys: List[str]):
        data = { "foreignKeys": foreignKeys }
        return await execute_async(
            _doordeck_headless_sdk.getUserPublicKeyByForeignKeys,
            [self.resource, json.dumps(data)]
        )

    async def unlock(self, data: UnlockOperation):
        return await execute_async(
            _doordeck_headless_sdk.unlock,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def share_lock(self, data: ShareLockOperation):
        return await execute_async(
            _doordeck_headless_sdk.shareLock,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def batch_share_lock(self, data: BatchShareLockOperation):
        return await execute_async(
            _doordeck_headless_sdk.batchShareLock,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def revoke_access_to_lock(self, data: RevokeAccessToLockOperation):
        return await execute_async(
            _doordeck_headless_sdk.revokeAccessToLock,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def update_secure_setting_unlock_duration(self, data: UpdateSecureSettingUnlockDuration):
        return await execute_async(
            _doordeck_headless_sdk.updateSecureSettingUnlockDuration,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def update_secure_setting_unlock_between(self, data: UpdateSecureSettingUnlockBetween):
        return await execute_async(
            _doordeck_headless_sdk.updateSecureSettingUnlockBetween,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def get_pinned_locks(self):
        return await execute_async(
            _doordeck_headless_sdk.getPinnedLocks,
            [self.resource]
        )

    async def get_shareable_locks(self):
        return await execute_async(
            _doordeck_headless_sdk.getShareableLocks,
            [self.resource]
        )


class Platform(object):

    def __init__(self, resource):
        self.resource = resource

    async def create_application(self, data: CreateApplication):
        return await execute_async(
            _doordeck_headless_sdk.createApplication,
            [self.resource, json.dumps(dataclasses.asdict(data))]
        )

    async def list_applications(self):
        return await execute_async(
            _doordeck_headless_sdk.listApplications,
            [self.resource]
        )

    async def get_application(self, applicationId: str):
        data = { "applicationId": applicationId }
        return await execute_async(
            _doordeck_headless_sdk.getApplication,
            [self.resource, json.dumps(data)]
        )

    async def update_application_name(self, applicationId: str, name: str):
        data = {
            "applicationId": applicationId,
            "name": name
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationName,
            [self.resource, json.dumps(data)]
        )

    async def update_application_company_name(self, applicationId: str, companyName: str):
        data = {
            "applicationId": applicationId,
            "companyName": companyName
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationCompanyName,
            [self.resource, json.dumps(data)]
        )

    async def update_application_mailing_address(self, applicationId: str, mailingAddress: str):
        data = {
            "applicationId": applicationId,
            "mailingAddress": mailingAddress
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationMailingAddress,
            [self.resource, json.dumps(data)]
        )

    async def update_application_privacy_policy(self, applicationId: str, privacyPolicy: str):
        data = {
            "applicationId": applicationId,
            "privacyPolicy": privacyPolicy
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationPrivacyPolicy,
            [self.resource, json.dumps(data)]
        )

    async def update_application_support_contact(self, applicationId: str, supportContact: str):
        data = {
            "applicationId": applicationId,
            "supportContact": supportContact
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationSupportContact,
            [self.resource, json.dumps(data)]
        )

    async def update_application_app_link(self, applicationId: str, appLink: str):
        data = {
            "applicationId": applicationId,
            "appLink": appLink
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationAppLink,
            [self.resource, json.dumps(data)]
        )

    async def update_application_email_preferences(self, applicationId: str, emailPreferences: EmailPreferences):
        data = {
            "applicationId": applicationId,
            "emailPreferences": dataclasses.asdict(emailPreferences)
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationEmailPreferences,
            [self.resource, json.dumps(data)]
        )

    async def update_application_logo_url(self, applicationId: str, logoUrl: str):
        data = {
            "applicationId": applicationId,
            "logoUrl": logoUrl
        }
        return await execute_async(
            _doordeck_headless_sdk.updateApplicationLogoUrl,
            [self.resource, json.dumps(data)]
        )

    async def delete_application(self, applicationId: str):
        data = { "applicationId": applicationId }
        return await execute_async(
            _doordeck_headless_sdk.deleteApplication,
            [self.resource, json.dumps(data)]
        )

    async def get_logo_upload_url(self, applicationId: str, contentType: str):
        data = {
            "applicationId": applicationId,
            "contentType": contentType
        }
        return await execute_async(
            _doordeck_headless_sdk.getLogoUploadUrl,
            [self.resource, json.dumps(data)]
        )

    async def add_auth_key(self, applicationId: str, key: AuthKey):
        data = {
            "applicationId": applicationId,
            "key": dataclasses.asdict(key)
        }
        return await execute_async(
            _doordeck_headless_sdk.addAuthKey,
            [self.resource, json.dumps(data)]
        )

    async def add_auth_issuer(self, applicationId: str, url: str):
        data = {
            "applicationId": applicationId,
            "url": url
        }
        return await execute_async(
            _doordeck_headless_sdk.addAuthIssuer,
            [self.resource, json.dumps(data)]
        )

    async def delete_auth_issuer(self, applicationId: str, url: str):
        data = {
            "applicationId": applicationId,
            "url": url
        }
        return await execute_async(
            _doordeck_headless_sdk.deleteAuthIssuer,
            [self.resource, json.dumps(data)]
        )

    async def add_cors_domain(self, applicationId: str, url: str):
        data = {
            "applicationId": applicationId,
            "url": url
        }
        return await execute_async(
            _doordeck_headless_sdk.addCorsDomain,
            [self.resource, json.dumps(data)]
        )

    async def remove_cors_domain(self, applicationId: str, url: str):
        data = {
            "applicationId": applicationId,
            "url": url
        }
        return await execute_async(
            _doordeck_headless_sdk.removeCorsDomain,
            [self.resource, json.dumps(data)]
        )

    async def add_application_owner(self, applicationId: str, userId: str):
        data = {
            "applicationId": applicationId,
            "userId": userId
        }
        return await execute_async(
            _doordeck_headless_sdk.addApplicationOwner,
            [self.resource, json.dumps(data)]
        )

    async def remove_application_owner(self, applicationId: str, userId: str):
        data = {
            "applicationId": applicationId,
            "userId": userId
        }
        return await execute_async(
            _doordeck_headless_sdk.removeApplicationOwner,
            [self.resource, json.dumps(data)]
        )

    async def get_application_owners_details(self, applicationId: str):
        data = { "applicationId": applicationId }
        return await execute_async(
            _doordeck_headless_sdk.getApplicationOwnersDetails,
            [self.resource, json.dumps(data)]
        )


class Sites(object):

    def __init__(self, resource):
        self.resource = resource

    async def list_sites(self):
        return await execute_async(
            _doordeck_headless_sdk.listSites,
            [self.resource]
        )

    async def get_locks_for_site(self, siteId: str):
        data = { "siteId": siteId }
        return await execute_async(
            _doordeck_headless_sdk.getLocksForSite,
            [self.resource, json.dumps(data)]
        )

    async def get_users_for_site(self, siteId: str):
        data = { "siteId": siteId }
        return await execute_async(
            _doordeck_headless_sdk.getUsersForSite,
            [self.resource, json.dumps(data)]
        )


class Tiles(object):

    def __init__(self, resource):
        self.resource = resource

    async def get_locks_belonging_to_tile(self, tileId: str):
        data = { "tileId": tileId }
        return await execute_async(
            _doordeck_headless_sdk.getLocksBelongingToTile,
            [self.resource, json.dumps(data)]
        )

    async def associate_multiple_locks(self, tileId: str, siteId: str, lockIds: List[str]):
        data = {
            "tileId": tileId,
            "siteId": siteId,
            "lockIds": lockIds
        }
        return await execute_async(
            _doordeck_headless_sdk.associateMultipleLocks,
            [self.resource, json.dumps(data)]
        )


class InitializeSdk(object):

    def __init__(self, api_environment: typing.Literal["DEV", "STAGING", "PROD"] = "PROD", cloud_auth_token: str = None, cloud_refresh_token: str = None, fusion_host: str = None):
        self.sdkApiEnvironment = _doordeck_headless_sdk.getApiEnvironmentByName(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment(), api_environment)
        self.sdkConfig = _doordeck_headless_sdk.buildSdkConfig(self.sdkApiEnvironment, cloud_auth_token, cloud_refresh_token, fusion_host)
        self.sdk = initialize(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory(), self.sdkConfig)
        self.accountless = Accountless(accountless(self.sdk))
        self.account = Account(account(self.sdk))
        self.fusion = Fusion(fusion(self.sdk))
        self.helper = Helper(helper(self.sdk))
        self.lockOperations = LockOperations(lockOperations(self.sdk))
        self.platform = Platform(platform(self.sdk))
        self.sites = Sites(sites(self.sdk))
        self.tiles = Tiles(tiles(self.sdk))
        self.contextManager = ContextManager(contextManager(self.sdk))
        self.cryptoManager = CryptoManager(crypto(self.sdk))

class Doordeck_Headless_Sdk_kref_kotlin_Byte(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Byte_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Byte_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Byte_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Byte())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Byte

# Register Doordeck_Headless_Sdk_kref_kotlin_Byte in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Byte_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Byte)
class Doordeck_Headless_Sdk_kref_kotlin_Short(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Short_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Short_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Short_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Short())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Short

# Register Doordeck_Headless_Sdk_kref_kotlin_Short in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Short_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Short)
class Doordeck_Headless_Sdk_kref_kotlin_Int(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Int_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Int_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Int_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Int())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Int

# Register Doordeck_Headless_Sdk_kref_kotlin_Int in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Int_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Int)
class Doordeck_Headless_Sdk_kref_kotlin_Long(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Long_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Long_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Long_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Long())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Long

# Register Doordeck_Headless_Sdk_kref_kotlin_Long in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Long_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Long)
class Doordeck_Headless_Sdk_kref_kotlin_Float(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Float_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Float_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Float_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Float())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Float

# Register Doordeck_Headless_Sdk_kref_kotlin_Float in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Float_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Float)
class Doordeck_Headless_Sdk_kref_kotlin_Double(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Double_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Double_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Double_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Double())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Double

# Register Doordeck_Headless_Sdk_kref_kotlin_Double in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Double_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Double)
class Doordeck_Headless_Sdk_kref_kotlin_Char(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Char_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Char_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Char_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Char())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Char

# Register Doordeck_Headless_Sdk_kref_kotlin_Char in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Char_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Char)
class Doordeck_Headless_Sdk_kref_kotlin_Boolean(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Boolean_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Boolean_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Boolean_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Boolean())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Boolean

# Register Doordeck_Headless_Sdk_kref_kotlin_Boolean in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Boolean_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Boolean)
class Doordeck_Headless_Sdk_kref_kotlin_Unit(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Unit_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Unit_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Unit_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Unit())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Unit

# Register Doordeck_Headless_Sdk_kref_kotlin_Unit in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Unit_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Unit)
class Doordeck_Headless_Sdk_kref_kotlin_UByte(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UByte_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UByte_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UByte_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_UByte())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_UByte

# Register Doordeck_Headless_Sdk_kref_kotlin_UByte in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UByte_swigregister(Doordeck_Headless_Sdk_kref_kotlin_UByte)
class Doordeck_Headless_Sdk_kref_kotlin_UShort(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UShort_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UShort_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UShort_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_UShort())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_UShort

# Register Doordeck_Headless_Sdk_kref_kotlin_UShort in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UShort_swigregister(Doordeck_Headless_Sdk_kref_kotlin_UShort)
class Doordeck_Headless_Sdk_kref_kotlin_UInt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UInt_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UInt_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UInt_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_UInt())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_UInt

# Register Doordeck_Headless_Sdk_kref_kotlin_UInt in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_UInt_swigregister(Doordeck_Headless_Sdk_kref_kotlin_UInt)
class Doordeck_Headless_Sdk_kref_kotlin_ULong(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ULong_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ULong_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ULong_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_ULong())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_ULong

# Register Doordeck_Headless_Sdk_kref_kotlin_ULong in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ULong_swigregister(Doordeck_Headless_Sdk_kref_kotlin_ULong)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_AccountlessApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_FusionApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_HelperApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_LockOperationsApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_PlatformApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_SitesApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_api_TilesApi)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_storage_SecureStorage)
class Doordeck_Headless_Sdk_kref_kotlin_Any(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Any_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Any_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Any_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Any())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Any

# Register Doordeck_Headless_Sdk_kref_kotlin_Any in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Any_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Any)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_config_SdkConfig_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_ApplicationContext)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_context_ContextManager)
class Doordeck_Headless_Sdk_kref_kotlin_collections_List(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_List_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_List_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_List_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_collections_List())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_collections_List

# Register Doordeck_Headless_Sdk_kref_kotlin_collections_List in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_List_swigregister(Doordeck_Headless_Sdk_kref_kotlin_collections_List)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_KeyPair)
class Doordeck_Headless_Sdk_kref_kotlin_ByteArray(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ByteArray_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ByteArray_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ByteArray_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_ByteArray())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_ByteArray

# Register Doordeck_Headless_Sdk_kref_kotlin_ByteArray in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_ByteArray_swigregister(Doordeck_Headless_Sdk_kref_kotlin_ByteArray)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_crypto_CryptoManager)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BadRequestException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_UnauthorizedException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ForbiddenException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotFoundException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MethodNotAllowedException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_NotAcceptableException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ConflictException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GoneException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_LockedException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooEarlyException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_TooManyRequestsException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_InternalServerErrorException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_ServiceUnavailableException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_GatewayTimeoutException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_SdkException)
class Doordeck_Headless_Sdk_kref_kotlin_Throwable(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Throwable_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Throwable_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Throwable_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Throwable())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Throwable

# Register Doordeck_Headless_Sdk_kref_kotlin_Throwable in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Throwable_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Throwable)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingContextFieldException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_MissingAndroidContextException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_exceptions_BatchShareFailedException)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_OPEN)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_CLOSE)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_UNLOCK)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DOOR_LOCK)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_OWNER_ASSIGNED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_CONNECTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DISCONNECTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_SHARED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_LOCK_REVOKED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_PROMOTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_USER_DEMOTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_SETTING_CHANGED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_ASSOCIATED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_TILE_DISASSOCIATED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_DEVICE_DECOMMISSIONED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_AuditEvent_Companion)
class Doordeck_Headless_Sdk_kref_kotlin_Array(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Array_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Array_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Array_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_Array())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_Array

# Register Doordeck_Headless_Sdk_kref_kotlin_Array in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_Array_swigregister(Doordeck_Headless_Sdk_kref_kotlin_Array)
class Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer

# Register Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer_swigregister(Doordeck_Headless_Sdk_kref_kotlinx_serialization_KSerializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_SUPPORTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_UNSUPPORTED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityStatus_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_CONFIGURABLE_UNLOCK_DURATION)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_OPEN_HOURS)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25 in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_BATCH_SHARING_25)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_CapabilityType_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_EMAIL)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_TELEPHONE)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_SMS)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_TwoFactorMethod_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_ADMIN)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_USER)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_common_UserRole_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_DEV)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_STAGING)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApiEnvironment_PROD)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_serializer)
class Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor

# Register Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor_swigregister(Doordeck_Headless_Sdk_kref_kotlinx_serialization_descriptors_SerialDescriptor)
class Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder

# Register Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder_swigregister(Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Decoder)
class Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder

# Register Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder_swigregister(Doordeck_Headless_Sdk_kref_kotlinx_serialization_encoding_Encoder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Context_OperationContextData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Crypto_EncodedKeyPair_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LockController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AlpetaController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AmagController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AssaAbloyController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AvigilonController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_AxisController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_CCureController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DemoController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GallagherController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_GenetecController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_LenelController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_MitrefinchController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PaxtonNet2Controller_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_Paxton10Controller_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV1Controller_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_IntegraV2Controller_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_PacController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_DataSource_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiExgardeController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_TdsiGardisController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoController_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_DOOR)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_FLOOR)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Fusion_ZktecoEntityType_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_TimeRequirement_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_LocationRequirement_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockBetween_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UnlockOperation_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLockOperation_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_ShareLock_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BatchShareLockOperation_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_RevokeAccessToLockOperation_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockDuration_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_UpdateSecureSettingUnlockBetween_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_BaseOperation_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LockOperations_Operation)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_CreateApplication_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailPreferences_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EmailCallToAction_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_AuthKey)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_RsaKey_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_EcKey_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Platform_Ed25519Key_Builder)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RefreshTokenData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegisterEphemeralKeyWithSecondaryAuthenticationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEphemeralKeyRegistrationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ChangePasswordData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateUserDetailsData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LoginData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RegistrationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_VerifyEmailData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_PasswordResetVerifyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FusionLoginData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetIntegrationConfigurationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EnableDoorData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_DeviceIdData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UploadPlatformLogoData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedLoginData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterEphemeralKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssistedRegisterData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetSingleLockData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLockAuditTrailData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetAuditForUserData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUsersForLockData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksForUserData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockNameData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockFavouriteData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockColourData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingDefaultNameData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingPermittedAddressesData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingHiddenData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SetLockSettingTimeRestrictionsData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_TimeRequirementData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateLockSettingLocationRestrictionsData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_LocationRequirementData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephoneData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByIdentityData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByEmailsData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByTelephonesData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByLocalKeysData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetUserPublicKeyByForeignKeysData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockOperationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BaseOperationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ShareLockOperationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_BatchShareLockOperationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RevokeAccessToLockOperationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockDurationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UnlockBetweenData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateSecureSettingUnlockBetweenData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CreateApplicationData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailPreferencesData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EmailCallToActionData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationIdData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationNameData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationCompanyNameData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationMailingAddressData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationPrivacyPolicyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationSupportContactData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationAppLinkData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationEmailPreferencesData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_UpdateApplicationLogoUrlData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLogoUploadUrlData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AddAuthKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_RsaKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_EcKeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_Ed25519KeyData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AuthIssuerData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_CorsDomainData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_ApplicationOwnerData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_FailedResultData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_SiteIdData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_GetLocksBelongingToTileData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_data_AssociateMultipleLocksData_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_OperationRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateLockPropertiesRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_LockSettingsRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UsageRequirementRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_UpdateApplicationRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_requests_AddAuthKeyRequest_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_Companion)
class Doordeck_Headless_Sdk_kref_kotlin_collections_Map(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_Map_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_Map_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_Map_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_kotlin_collections_Map())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_kotlin_collections_Map

# Register Doordeck_Headless_Sdk_kref_kotlin_collections_Map in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_kotlin_collections_Map_swigregister(Doordeck_Headless_Sdk_kref_kotlin_collections_Map)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_RUNNING)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_STOPPED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_UNDEFINED)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_util_Utils)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_Doordeck)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JVM)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_ANDROID)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_APPLE)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_PlatformType_JS)
class Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pinned = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory_pinned_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory_pinned_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory

# Register Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory_swigregister(Doordeck_Headless_Sdk_kref_com_doordeck_multiplatform_sdk_KDoordeckFactory)

def changePassword(thiz, data, callback):
    return _doordeck_headless_sdk.changePassword(thiz, data, callback)

def deleteAccount(thiz, callback):
    return _doordeck_headless_sdk.deleteAccount(thiz, callback)

def getUserDetails(thiz, callback):
    return _doordeck_headless_sdk.getUserDetails(thiz, callback)

def logout(thiz, callback):
    return _doordeck_headless_sdk.logout(thiz, callback)

def refreshToken(thiz, data, callback):
    return _doordeck_headless_sdk.refreshToken(thiz, data, callback)

def registerEphemeralKey(thiz, data, callback):
    return _doordeck_headless_sdk.registerEphemeralKey(thiz, data, callback)

def registerEphemeralKeyWithSecondaryAuthentication(thiz, data, callback):
    return _doordeck_headless_sdk.registerEphemeralKeyWithSecondaryAuthentication(thiz, data, callback)

def reverifyEmail(thiz, callback):
    return _doordeck_headless_sdk.reverifyEmail(thiz, callback)

def updateUserDetails(thiz, data, callback):
    return _doordeck_headless_sdk.updateUserDetails(thiz, data, callback)

def verifyEphemeralKeyRegistration(thiz, data, callback):
    return _doordeck_headless_sdk.verifyEphemeralKeyRegistration(thiz, data, callback)

def login(thiz, data, callback):
    return _doordeck_headless_sdk.login(thiz, data, callback)

def passwordReset(thiz, data, callback):
    return _doordeck_headless_sdk.passwordReset(thiz, data, callback)

def passwordResetVerify(thiz, data, callback):
    return _doordeck_headless_sdk.passwordResetVerify(thiz, data, callback)

def registration(thiz, data, callback):
    return _doordeck_headless_sdk.registration(thiz, data, callback)

def verifyEmail(thiz, data, callback):
    return _doordeck_headless_sdk.verifyEmail(thiz, data, callback)

def deleteDoor(thiz, data, callback):
    return _doordeck_headless_sdk.deleteDoor(thiz, data, callback)

def enableDoor(thiz, data, callback):
    return _doordeck_headless_sdk.enableDoor(thiz, data, callback)

def getDoorStatus(thiz, data, callback):
    return _doordeck_headless_sdk.getDoorStatus(thiz, data, callback)

def getIntegrationConfiguration(thiz, data, callback):
    return _doordeck_headless_sdk.getIntegrationConfiguration(thiz, data, callback)

def getIntegrationType(thiz, callback):
    return _doordeck_headless_sdk.getIntegrationType(thiz, callback)

def loginFusion(thiz, data, callback):
    return _doordeck_headless_sdk.loginFusion(thiz, data, callback)

def startDoor(thiz, data, callback):
    return _doordeck_headless_sdk.startDoor(thiz, data, callback)

def stopDoor(thiz, data, callback):
    return _doordeck_headless_sdk.stopDoor(thiz, data, callback)

def assistedLogin(thiz, data, callback):
    return _doordeck_headless_sdk.assistedLogin(thiz, data, callback)

def assistedRegister(thiz, data, callback):
    return _doordeck_headless_sdk.assistedRegister(thiz, data, callback)

def assistedRegisterEphemeralKey(thiz, data, callback):
    return _doordeck_headless_sdk.assistedRegisterEphemeralKey(thiz, data, callback)

def uploadPlatformLogo(thiz, data, callback):
    return _doordeck_headless_sdk.uploadPlatformLogo(thiz, data, callback)

def batchShareLock(thiz, data, callback):
    return _doordeck_headless_sdk.batchShareLock(thiz, data, callback)

def getAuditForUser(thiz, data, callback):
    return _doordeck_headless_sdk.getAuditForUser(thiz, data, callback)

def getLockAuditTrail(thiz, data, callback):
    return _doordeck_headless_sdk.getLockAuditTrail(thiz, data, callback)

def getLocksForUser(thiz, data, callback):
    return _doordeck_headless_sdk.getLocksForUser(thiz, data, callback)

def getPinnedLocks(thiz, callback):
    return _doordeck_headless_sdk.getPinnedLocks(thiz, callback)

def getShareableLocks(thiz, callback):
    return _doordeck_headless_sdk.getShareableLocks(thiz, callback)

def getSingleLock(thiz, data, callback):
    return _doordeck_headless_sdk.getSingleLock(thiz, data, callback)

def getUserPublicKey(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKey(thiz, data, callback)

def getUserPublicKeyByEmail(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByEmail(thiz, data, callback)

def getUserPublicKeyByEmails(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByEmails(thiz, data, callback)

def getUserPublicKeyByForeignKey(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByForeignKey(thiz, data, callback)

def getUserPublicKeyByForeignKeys(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByForeignKeys(thiz, data, callback)

def getUserPublicKeyByIdentity(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByIdentity(thiz, data, callback)

def getUserPublicKeyByLocalKey(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByLocalKey(thiz, data, callback)

def getUserPublicKeyByLocalKeys(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByLocalKeys(thiz, data, callback)

def getUserPublicKeyByTelephone(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByTelephone(thiz, data, callback)

def getUserPublicKeyByTelephones(thiz, data, callback):
    return _doordeck_headless_sdk.getUserPublicKeyByTelephones(thiz, data, callback)

def getUsersForLock(thiz, data, callback):
    return _doordeck_headless_sdk.getUsersForLock(thiz, data, callback)

def revokeAccessToLock(thiz, data, callback):
    return _doordeck_headless_sdk.revokeAccessToLock(thiz, data, callback)

def setLockSettingPermittedAddresses(thiz, data, callback):
    return _doordeck_headless_sdk.setLockSettingPermittedAddresses(thiz, data, callback)

def setLockSettingTimeRestrictions(thiz, data, callback):
    return _doordeck_headless_sdk.setLockSettingTimeRestrictions(thiz, data, callback)

def shareLock(thiz, data, callback):
    return _doordeck_headless_sdk.shareLock(thiz, data, callback)

def unlock(thiz, data, callback):
    return _doordeck_headless_sdk.unlock(thiz, data, callback)

def updateLockColour(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockColour(thiz, data, callback)

def updateLockFavourite(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockFavourite(thiz, data, callback)

def updateLockName(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockName(thiz, data, callback)

def updateLockSettingDefaultName(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockSettingDefaultName(thiz, data, callback)

def updateLockSettingHidden(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockSettingHidden(thiz, data, callback)

def updateLockSettingLocationRestrictions(thiz, data, callback):
    return _doordeck_headless_sdk.updateLockSettingLocationRestrictions(thiz, data, callback)

def updateSecureSettingUnlockBetween(thiz, data, callback):
    return _doordeck_headless_sdk.updateSecureSettingUnlockBetween(thiz, data, callback)

def updateSecureSettingUnlockDuration(thiz, data, callback):
    return _doordeck_headless_sdk.updateSecureSettingUnlockDuration(thiz, data, callback)

def addApplicationOwner(thiz, data, callback):
    return _doordeck_headless_sdk.addApplicationOwner(thiz, data, callback)

def addAuthIssuer(thiz, data, callback):
    return _doordeck_headless_sdk.addAuthIssuer(thiz, data, callback)

def addAuthKey(thiz, data, callback):
    return _doordeck_headless_sdk.addAuthKey(thiz, data, callback)

def addCorsDomain(thiz, data, callback):
    return _doordeck_headless_sdk.addCorsDomain(thiz, data, callback)

def createApplication(thiz, data, callback):
    return _doordeck_headless_sdk.createApplication(thiz, data, callback)

def deleteApplication(thiz, data, callback):
    return _doordeck_headless_sdk.deleteApplication(thiz, data, callback)

def deleteAuthIssuer(thiz, data, callback):
    return _doordeck_headless_sdk.deleteAuthIssuer(thiz, data, callback)

def getApplication(thiz, data, callback):
    return _doordeck_headless_sdk.getApplication(thiz, data, callback)

def getApplicationOwnersDetails(thiz, data, callback):
    return _doordeck_headless_sdk.getApplicationOwnersDetails(thiz, data, callback)

def getLogoUploadUrl(thiz, data, callback):
    return _doordeck_headless_sdk.getLogoUploadUrl(thiz, data, callback)

def listApplications(thiz, callback):
    return _doordeck_headless_sdk.listApplications(thiz, callback)

def removeApplicationOwner(thiz, data, callback):
    return _doordeck_headless_sdk.removeApplicationOwner(thiz, data, callback)

def removeCorsDomain(thiz, data, callback):
    return _doordeck_headless_sdk.removeCorsDomain(thiz, data, callback)

def updateApplicationAppLink(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationAppLink(thiz, data, callback)

def updateApplicationCompanyName(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationCompanyName(thiz, data, callback)

def updateApplicationEmailPreferences(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationEmailPreferences(thiz, data, callback)

def updateApplicationLogoUrl(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationLogoUrl(thiz, data, callback)

def updateApplicationMailingAddress(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationMailingAddress(thiz, data, callback)

def updateApplicationName(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationName(thiz, data, callback)

def updateApplicationPrivacyPolicy(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationPrivacyPolicy(thiz, data, callback)

def updateApplicationSupportContact(thiz, data, callback):
    return _doordeck_headless_sdk.updateApplicationSupportContact(thiz, data, callback)

def getLocksForSite(thiz, data, callback):
    return _doordeck_headless_sdk.getLocksForSite(thiz, data, callback)

def getUsersForSite(thiz, data, callback):
    return _doordeck_headless_sdk.getUsersForSite(thiz, data, callback)

def listSites(thiz, callback):
    return _doordeck_headless_sdk.listSites(thiz, callback)

def associateMultipleLocks(thiz, data, callback):
    return _doordeck_headless_sdk.associateMultipleLocks(thiz, data, callback)

def getLocksBelongingToTile(thiz, data, callback):
    return _doordeck_headless_sdk.getLocksBelongingToTile(thiz, data, callback)

def clearContext(thiz):
    return _doordeck_headless_sdk.clearContext(thiz)

def getApiEnvironment(thiz):
    return _doordeck_headless_sdk.getApiEnvironment(thiz)

def getCloudAuthToken(thiz):
    return _doordeck_headless_sdk.getCloudAuthToken(thiz)

def getCloudRefreshToken(thiz):
    return _doordeck_headless_sdk.getCloudRefreshToken(thiz)

def getFusionAuthToken(thiz):
    return _doordeck_headless_sdk.getFusionAuthToken(thiz)

def getFusionHost(thiz):
    return _doordeck_headless_sdk.getFusionHost(thiz)

def getUserEmail(thiz):
    return _doordeck_headless_sdk.getUserEmail(thiz)

def getUserId(thiz):
    return _doordeck_headless_sdk.getUserId(thiz)

def isCertificateChainAboutToExpire(thiz):
    return _doordeck_headless_sdk.isCertificateChainAboutToExpire(thiz)

def isCloudAuthTokenAboutToExpire(thiz):
    return _doordeck_headless_sdk.isCloudAuthTokenAboutToExpire(thiz)

def isKeyPairValid(thiz):
    return _doordeck_headless_sdk.isKeyPairValid(thiz)

def isKeyPairVerified(thiz):
    return _doordeck_headless_sdk.isKeyPairVerified(thiz)

def setCloudAuthToken(thiz, token):
    return _doordeck_headless_sdk.setCloudAuthToken(thiz, token)

def setCloudRefreshToken(thiz, token):
    return _doordeck_headless_sdk.setCloudRefreshToken(thiz, token)

def setFusionAuthToken(thiz, token):
    return _doordeck_headless_sdk.setFusionAuthToken(thiz, token)

def setFusionHost(thiz, host):
    return _doordeck_headless_sdk.setFusionHost(thiz, host)

def setOperationContextJson(thiz, data):
    return _doordeck_headless_sdk.setOperationContextJson(thiz, data)

def setUserEmail(thiz, email):
    return _doordeck_headless_sdk.setUserEmail(thiz, email)

def setUserId(thiz, userId):
    return _doordeck_headless_sdk.setUserId(thiz, userId)

def generateEncodedKeyPair(thiz):
    return _doordeck_headless_sdk.generateEncodedKeyPair(thiz)

def buildSdkConfig(apiEnvironment, cloudAuthToken, cloudRefreshToken, fusionHost):
    return _doordeck_headless_sdk.buildSdkConfig(apiEnvironment, cloudAuthToken, cloudRefreshToken, fusionHost)

def getApiEnvironmentByName(thiz, name):
    return _doordeck_headless_sdk.getApiEnvironmentByName(thiz, name)

def getApiEnvironmentName(thiz):
    return _doordeck_headless_sdk.getApiEnvironmentName(thiz)

def account(thiz):
    return _doordeck_headless_sdk.account(thiz)

def accountless(thiz):
    return _doordeck_headless_sdk.accountless(thiz)

def contextManager(thiz):
    return _doordeck_headless_sdk.contextManager(thiz)

def crypto(thiz):
    return _doordeck_headless_sdk.crypto(thiz)

def fusion(thiz):
    return _doordeck_headless_sdk.fusion(thiz)

def helper(thiz):
    return _doordeck_headless_sdk.helper(thiz)

def lockOperations(thiz):
    return _doordeck_headless_sdk.lockOperations(thiz)

def platform(thiz):
    return _doordeck_headless_sdk.platform(thiz)

def sites(thiz):
    return _doordeck_headless_sdk.sites(thiz)

def tiles(thiz):
    return _doordeck_headless_sdk.tiles(thiz)

def initialize(thiz, sdkConfig):
    return _doordeck_headless_sdk.initialize(thiz, sdkConfig)
class Doordeck_Headless_Sdk_ExportedSymbols(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    DisposeStablePointer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_DisposeStablePointer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_DisposeStablePointer_set)
    DisposeString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_DisposeString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_DisposeString_set)
    IsInstance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_IsInstance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_IsInstance_set)
    createNullableByte = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableByte_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableByte_set)
    getNonNullValueOfByte = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfByte_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfByte_set)
    createNullableShort = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableShort_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableShort_set)
    getNonNullValueOfShort = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfShort_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfShort_set)
    createNullableInt = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableInt_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableInt_set)
    getNonNullValueOfInt = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfInt_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfInt_set)
    createNullableLong = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableLong_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableLong_set)
    getNonNullValueOfLong = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfLong_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfLong_set)
    createNullableFloat = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableFloat_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableFloat_set)
    getNonNullValueOfFloat = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfFloat_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfFloat_set)
    createNullableDouble = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableDouble_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableDouble_set)
    getNonNullValueOfDouble = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfDouble_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfDouble_set)
    createNullableChar = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableChar_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableChar_set)
    getNonNullValueOfChar = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfChar_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfChar_set)
    createNullableBoolean = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableBoolean_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableBoolean_set)
    getNonNullValueOfBoolean = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfBoolean_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfBoolean_set)
    createNullableUnit = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUnit_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUnit_set)
    createNullableUByte = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUByte_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUByte_set)
    getNonNullValueOfUByte = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUByte_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUByte_set)
    createNullableUShort = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUShort_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUShort_set)
    getNonNullValueOfUShort = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUShort_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUShort_set)
    createNullableUInt = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUInt_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableUInt_set)
    getNonNullValueOfUInt = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUInt_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfUInt_set)
    createNullableULong = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableULong_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_createNullableULong_set)
    getNonNullValueOfULong = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfULong_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_getNonNullValueOfULong_set)
    kotlin = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols

# Register Doordeck_Headless_Sdk_ExportedSymbols in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_swigregister(Doordeck_Headless_Sdk_ExportedSymbols)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    root = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    com = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    doordeck = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    multiplatform = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    sdk = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    api = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_api_get)
    config = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_config_get)
    context = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_context_get)
    crypto = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_crypto_get)
    exceptions = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_exceptions_get)
    model = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_get)
    storage = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_get)
    util = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_get)
    Doordeck = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_get)
    PlatformType = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_get)
    KDoordeckFactory = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory_get)
    ApplicationContext = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext_get)
    getPlatform = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_getPlatform_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_getPlatform_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext__instance_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_ApplicationContext)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory__instance_set)
    initialize_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory_initialize__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory_initialize__set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_KDoordeckFactory)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    JVM = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM_get)
    ANDROID = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_get)
    APPLE = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE_get)
    WINDOWS = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_get)
    JS = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType__type_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    get = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS_get_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS_get_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JS)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    get = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_get_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_get_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_WINDOWS)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    get = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE_get_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE_get_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_APPLE)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    get = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_get_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_get_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_ANDROID)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    get = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM_get_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM_get_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_PlatformType_JVM)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck__type_set)
    account_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_account__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_account__set)
    accountless_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_accountless__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_accountless__set)
    contextManager_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_contextManager__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_contextManager__set)
    crypto_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_crypto__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_crypto__set)
    fusion_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_fusion__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_fusion__set)
    helper_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_helper__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_helper__set)
    lockOperations_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_lockOperations__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_lockOperations__set)
    platform_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_platform__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_platform__set)
    sites_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_sites__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_sites__set)
    tiles_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_tiles__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_tiles__set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_Doordeck)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Utils = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_get)
    buildSdkConfig_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_buildSdkConfig__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_buildSdkConfig__set)
    getApiEnvironmentByName_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_getApiEnvironmentByName__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_getApiEnvironmentByName__set)
    getApiEnvironmentName_ = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_getApiEnvironmentName__get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_getApiEnvironmentName__set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils__instance_set)
    certificateChainToString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_certificateChainToString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_certificateChainToString_set)
    decodeBase64ToByteArray = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_decodeBase64ToByteArray_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_decodeBase64ToByteArray_set)
    encodeByteArrayToBase64 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_encodeByteArrayToBase64_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_encodeByteArrayToBase64_set)
    stringToCertificateChain = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_stringToCertificateChain_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_stringToCertificateChain_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_util_Utils)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    SecureStorage = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage__type_set)
    addCertificateChain = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCertificateChain_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCertificateChain_set)
    addCloudAuthToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCloudAuthToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCloudAuthToken_set)
    addCloudRefreshToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCloudRefreshToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addCloudRefreshToken_set)
    addFusionAuthToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addFusionAuthToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addFusionAuthToken_set)
    addPrivateKey = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addPrivateKey_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addPrivateKey_set)
    addPublicKey = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addPublicKey_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addPublicKey_set)
    addUserEmail = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addUserEmail_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addUserEmail_set)
    addUserId = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addUserId_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_addUserId_set)
    clear = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_clear_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_clear_set)
    getApiEnvironment = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getApiEnvironment_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getApiEnvironment_set)
    getCertificateChain = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCertificateChain_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCertificateChain_set)
    getCloudAuthToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCloudAuthToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCloudAuthToken_set)
    getCloudRefreshToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCloudRefreshToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getCloudRefreshToken_set)
    getFusionAuthToken = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getFusionAuthToken_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getFusionAuthToken_set)
    getFusionHost = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getFusionHost_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getFusionHost_set)
    getKeyPairVerified = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getKeyPairVerified_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getKeyPairVerified_set)
    getPrivateKey = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getPrivateKey_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getPrivateKey_set)
    getPublicKey = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getPublicKey_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getPublicKey_set)
    getUserEmail = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getUserEmail_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getUserEmail_set)
    getUserId = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getUserId_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_getUserId_set)
    setApiEnvironment = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setApiEnvironment_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setApiEnvironment_set)
    setFusionHost = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setFusionHost_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setFusionHost_set)
    setKeyPairVerified = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setKeyPairVerified_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_setKeyPairVerified_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_storage_SecureStorage)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    common = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_common_get)
    data = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_data_get)
    requests = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_requests_get)
    responses = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    TokenResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TokenResponse_get)
    UserDetailsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserDetailsResponse_get)
    RegisterEphemeralKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyResponse_get)
    RegisterEphemeralKeyWithSecondaryAuthenticationResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_RegisterEphemeralKeyWithSecondaryAuthenticationResponse_get)
    FusionLoginResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_FusionLoginResponse_get)
    IntegrationTypeResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_IntegrationTypeResponse_get)
    DoorStateResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_DoorStateResponse_get)
    IntegrationConfigurationResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_IntegrationConfigurationResponse_get)
    ControllerResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ControllerResponse_get)
    ServiceStateResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ServiceStateResponse_get)
    DiscoveredDeviceResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_DiscoveredDeviceResponse_get)
    ServiceStateType = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ServiceStateType_get)
    AssistedLoginResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AssistedLoginResponse_get)
    AssistedRegisterEphemeralKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AssistedRegisterEphemeralKeyResponse_get)
    LockResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LockResponse_get)
    LockSettingsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LockSettingsResponse_get)
    UsageRequirementsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UsageRequirementsResponse_get)
    TimeRequirementResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TimeRequirementResponse_get)
    LocationRequirementResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LocationRequirementResponse_get)
    UnlockBetweenSettingResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UnlockBetweenSettingResponse_get)
    LockStateResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LockStateResponse_get)
    UserPublicKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserPublicKeyResponse_get)
    BatchUserPublicKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_BatchUserPublicKeyResponse_get)
    ShareableLockResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ShareableLockResponse_get)
    UserLockResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserLockResponse_get)
    LockUserResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LockUserResponse_get)
    LockUserDetailsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_LockUserDetailsResponse_get)
    AuditResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AuditResponse_get)
    AuditIssuerResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AuditIssuerResponse_get)
    AuditSubjectResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AuditSubjectResponse_get)
    ApplicationResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ApplicationResponse_get)
    AuthKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_AuthKeyResponse_get)
    RsaKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_RsaKeyResponse_get)
    EcKeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_EcKeyResponse_get)
    Ed25519KeyResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_Ed25519KeyResponse_get)
    EmailPreferencesResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_EmailPreferencesResponse_get)
    EmailCallToActionResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_EmailCallToActionResponse_get)
    OauthResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_OauthResponse_get)
    ApplicationOwnerDetailsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_ApplicationOwnerDetailsResponse_get)
    GetLogoUploadUrlResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_get)
    SiteResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get)
    SiteLocksResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get)
    SiteLockSettingsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get)
    SiteStateResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_get)
    UserForSiteResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get)
    TileLocksResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse__type_set)
    TileLocksResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_TileLocksResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_TileLocksResponse_set)
    get_deviceIds = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_deviceIds_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_deviceIds_set)
    get_siteId = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_siteId_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_siteId_set)
    get_tileId = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_tileId_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_get_tileId_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component1_set)
    component2 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component2_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component2_set)
    component3 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component3_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_component3_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_TileLocksResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse__type_set)
    UserForSiteResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_UserForSiteResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_UserForSiteResponse_set)
    get_displayName = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_displayName_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_displayName_set)
    get_email = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_email_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_email_set)
    get_orphan = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_orphan_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_orphan_set)
    get_userId = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_userId_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_get_userId_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component1_set)
    component2 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component2_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component2_set)
    component3 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component3_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component3_set)
    component4 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component4_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_component4_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_UserForSiteResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse__type_set)
    SiteStateResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_SiteStateResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_SiteStateResponse_set)
    get_connected = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_get_connected_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_get_connected_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_component1_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteStateResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse__type_set)
    SiteLockSettingsResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_SiteLockSettingsResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_SiteLockSettingsResponse_set)
    get_defaultName = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_defaultName_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_defaultName_set)
    get_favourite = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_favourite_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_favourite_set)
    get_permittedAddresses = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_permittedAddresses_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_permittedAddresses_set)
    get_state = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_state_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_state_set)
    get_tiles = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_tiles_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_tiles_set)
    get_unlockTime = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_unlockTime_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_get_unlockTime_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component1_set)
    component2 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component2_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component2_set)
    component3 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component3_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component3_set)
    component4 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component4_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component4_set)
    component5 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component5_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component5_set)
    component6 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component6_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_component6_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLockSettingsResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse__type_set)
    SiteLocksResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_SiteLocksResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_SiteLocksResponse_set)
    get_colour = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_colour_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_colour_set)
    get_id = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_id_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_id_set)
    get_name = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_name_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_name_set)
    get_role = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_role_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_role_set)
    get_settings = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_settings_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_get_settings_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component1_set)
    component2 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component2_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component2_set)
    component3 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component3_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component3_set)
    component4 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component4_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component4_set)
    component5 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component5_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_component5_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteLocksResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse__type_set)
    SiteResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_SiteResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_SiteResponse_set)
    get_colour = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_colour_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_colour_set)
    get_created = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_created_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_created_set)
    get_id = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_id_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_id_set)
    get_latitude = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_latitude_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_latitude_set)
    get_longitude = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_longitude_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_longitude_set)
    get_name = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_name_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_name_set)
    get_passBackground = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_passBackground_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_passBackground_set)
    get_radius = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_radius_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_radius_set)
    get_updated = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_updated_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_get_updated_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component1_set)
    component2 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component2_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component2_set)
    component3 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component3_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component3_set)
    component4 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component4_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component4_set)
    component5 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component5_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component5_set)
    component6 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component6_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component6_set)
    component7 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component7_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component7_set)
    component8 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component8_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component8_set)
    component9 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component9_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_component9_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_Companion)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer__instance_set)
    get_descriptor = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_get_descriptor_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_get_descriptor_set)
    childSerializers = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_childSerializers_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_childSerializers_set)
    deserialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_deserialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_deserialize_set)
    serialize = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_serialize_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_serialize_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_SiteResponse_serializer)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_serializer_get)
    Companion = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_get)
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse__type_set)
    GetLogoUploadUrlResponse = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_GetLogoUploadUrlResponse_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_GetLogoUploadUrlResponse_set)
    get_uploadUrl = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_get_uploadUrl_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_get_uploadUrl_set)
    component1 = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_component1_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_component1_set)
    copy = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_copy_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_copy_set)
    equals = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_equals_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_equals_set)
    hashCode = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_hashCode_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_hashCode_set)
    toString = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_toString_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_toString_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_swigregister(Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse)
class Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    _type = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion__type_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion__type_set)
    _instance = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion__instance_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion__instance_set)
    serializer = property(_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_serializer_get, _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_serializer_set)

    def __init__(self):
        _doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_swiginit(self, _doordeck_headless_sdk.new_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion())
    __swig_destroy__ = _doordeck_headless_sdk.delete_Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion

# Register Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion in _doordeck_headless_sdk:
_doordeck_headless_sdk.Doordeck_Headless_Sdk_ExportedSymbols_kotlin_root_com_doordeck_multiplatform_sdk_model_responses_GetLogoUploadUrlResponse_Companion_swigregi