# Doordeck Headless SDK
A cross-platform SDK for seamless access to Doordeck’s services. This SDK supports multiple platforms and is designed to cater to a variety of development environments.

## Packages
We are publishing the packages to multiple repositories:

|          Platform           | Repository                                                                                                             |
|:---------------------------:|------------------------------------------------------------------------------------------------------------------------|
| Multiplatform, Android, JVM | [Maven central](https://central.sonatype.com/namespace/com.doordeck.headless.sdk)                                      |
|         iOS, macOS          | [Cocoapods](https://cocoapods.org/pods/DoordeckSDK), [SPM](https://github.com/doordeck/doordeck-headless-sdk-spm)      |
|             JS              | [NPM](https://www.npmjs.com/package/@doordeck/doordeck-headless-sdk)                                                   |
|           Windows           | [NuGet](https://www.nuget.org/packages/Doordeck.Headless.Sdk), [PyPi](https://pypi.org/project/doordeck-headless-sdk/) |

## Supported platforms
The SDK supports a range of targets for different platforms:

| Platform | Target                                    | Language          |
|:--------:|-------------------------------------------|-------------------|
| Android  | `android`                                 | `Java`, `Kotlin`  |
|   JVM    | `jvm`                                     | `Java`, `Kotlin`  |
|   iOS    | `iosX64`, `iosArm64`, `iosSimulatorArm64` | `Swift`           |
|  macOS   | `macosArm64`                              | `Swift`           |
|    JS    | `jsNode`, `jsBrowser`                     | `JavaScript`      |
| Windows  | `mingwX64`                                | `C#`, `Python`    |

## Getting started
To start using the Doordeck Headless SDK, refer to the [documentation index](https://github.com/doordeck/doordeck-headless-sdk/blob/main/docs/01_INDEX.md#index) for detailed setup and usage instructions tailored to your platform.

## Samples
We provide samples for different targets, where you can see how the SDK can be used in fully functional projects. For more information, please see the [samples page](https://github.com/doordeck/doordeck-headless-sdk/blob/main/docs/15_SAMPLES.md).