from dataclasses import dataclass, field

@dataclass
class SeasonAvgTableOffset:
    gm_offset: int = 3
    tm_offset: int = 8
    ta_offset: int = 9
    fga_offset: int = 6
    fgm_offset: int = 5
    pt_offset: int = 21
    ast_offset: int = 17
    reb_offset: int = 16
    to_offset: int = 18
    fta_offset: int = 12
    ftm_offset: int = 11
    stl_offset: int = 19
    blk_offset: int = 20

@dataclass
class GameTableOffset:
    ftm_offset: int = 9
    fta_offset: int = 10
    tm_offset: int = 6
    ta_offset: int = 7
    pt_offset: int = 20
    ast_offset: int = 15
    to_offset: int = 16
    reb_offset: int = 14
    blk_offset: int = 18
    stl_offset: int = 17
    fga_offset: int = 4
    fgm_offset: int = 3

TEAM_INFO_URL = 'https://sports.yahoo.com/nba/teams/{team_name}/roster'
PLAYER_INFO_URL = 'https://sports.yahoo.com/nba/players/{player_id}'
GAME_LOG_URL = 'https://sports.yahoo.com/nba/players/{player_id}/gamelog?selectedTable=0&season={year}'

# last updated 1/1/2021
PLAYER_LU_TABLE = {
    "Marshall Brown": 5001,
    "Anthony Roberson": 4001,
    "Darrell Armstrong": 3001,
    "Jeff Foote": 5002,
    "Dwayne Jones": 4002,
    "Ben Mccauley": 5003,
    "Joe Smith": 3003,
    "Gustavo Ayon": 5004,
    "Antonio Mcdyess": 3004,
    "Eric Dawson": 5005,
    "Jerry Stackhouse": 3005,
    "D.J. Kennedy": 5006,
    "Rasheed Wallace": 3006,
    "Anthony Davis": 5007,
    "Aaron Miles": 4007,
    "Kevin Garnett": 3007,
    "Michael Kidd-Gilchrist": 5008,
    "Bradley Beal": 5009,
    "Damon Stoudamire": 3009,
    "Dion Waiters": 5010,
    "Jawad Williams": 4010,
    "Thomas Robinson": 5011,
    "Damian Lillard": 5012,
    "Stephen Graham": 4012,
    "Kurt Thomas": 3012,
    "Harrison Barnes": 5013,
    "Terrence Ross": 5014,
    "Will Conroy": 4014,
    "Luka Doncic": 6014,
    "Andre Drummond": 5015,
    "Corliss Williamson": 3015,
    "Jaren Jackson Jr.": 6015,
    "Austin Rivers": 5016,
    "Trae Young": 6016,
    "Meyers Leonard": 5017,
    "Brent Barry": 3017,
    "Mo Bamba": 6017,
    "Jeremy Lamb": 5018,
    "Alan Henderson": 3018,
    "Wendell Carter Jr.": 6018,
    "Kendall Marshall": 5019,
    "Collin Sexton": 6019,
    "John Henson": 5020,
    "Theo Ratliff": 3020,
    "Kevin Knox Ii": 6020,
    "Moe Harkless": 5021,
    "Mikal Bridges": 6021,
    "Royce White": 5022,
    "Shai Gilgeous-Alexander": 6022,
    "Chuck Hayes": 4023,
    "Tyler Zeller": 5023,
    "Miles Bridges": 6023,
    "Michael Finley": 3023,
    "Terrence Jones": 5024,
    "Jerome Robinson": 6024,
    "Andrew Nicholson": 5025,
    "Michael Porter Jr.": 6025,
    "Troy Brown Jr.": 6026,
    "Zhaire Smith": 6027,
    "Donte Divincenzo": 6028,
    "Kelenna Azubuike": 4030,
    "Lonnie Walker Iv": 6029,
    "Kevin Huerter": 6030,
    "Josh Okogie": 6031,
    "Grayson Allen": 6032,
    "Chandler Hutchison": 6033,
    "Aaron Holiday": 6034,
    "Anfernee Simons": 6035,
    "Moritz Wagner": 6036,
    "Landry Shamet": 6037,
    "D'Or Fischer": 4038,
    "Robert Williams": 6038,
    "Jacob Evans Iii": 6039,
    "Dzanan Musa": 6040,
    "Omari Spellman": 6041,
    "Elie Okobo": 6042,
    "Roger Powell": 4044,
    "Jevon Carter": 6043,
    "Jalen Brunson": 6044,
    "Eric Snow": 3045,
    "Devonte' Graham": 6045,
    "Melvin Frazier Jr.": 6046,
    "Mitchell Robinson": 6047,
    "Gary Trent Jr.": 6048,
    "Khyri Thomas": 6049,
    "John Lucas Iii": 4052,
    "Isaac Bonga": 6050,
    "Rodions Kurucs": 6051,
    "Jarred Vanderbilt": 6052,
    "James Singleton": 4055,
    "Bruce Brown": 6053,
    "Evan Fournier": 5054,
    "Devin Green": 4056,
    "Justin Jackson": 5828,
    "Jared Sullinger": 5055,
    "Issuf Sanon": 6055,
    "Fab Melo": 5056,
    "John Jenkins": 5057,
    "Hamidou Diallo": 6056,
    "Jared Cunningham": 5058,
    "De'Anthony Melton": 6057,
    "Tony Wroten": 5059,
    "Miles Plumlee": 5060,
    "Svi Mykhailiuk": 6058,
    "Arnett Moultrie": 5061,
    "Keita Bates-Diop": 6059,
    "Chimezie Metu": 6060,
    "Perry Jones": 5062,
    "Alize Johnson": 6061,
    "Marquis Teague": 5063,
    "Tony Carr": 6062,
    "Festus Ezeli": 5064,
    "Vincent Edwards": 6063,
    "Jeffery Taylor": 5065,
    "Devon Hall": 6064,
    "Tomas Satoransky": 5066,
    "Shake Milton": 6065,
    "Bernard James": 5067,
    "Arnoldas Kulboka": 6066,
    "Jae Crowder": 5068,
    "Draymond Green": 5069,
    "Ray Spalding": 6067,
    "Kevin Hervey": 6068,
    "Orlando Johnson": 5070,
    "Thomas Welsh": 6069,
    "Quincy Acy": 5071,
    "George King": 6070,
    "Quincy Miller": 5072,
    "Kostas Antetokounmpo": 6071,
    "Khris Middleton": 5073,
    "Deonte Burton": 5399,
    "Will Barton": 5074,
    "Duncan Robinson": 6073,
    "Tyshawn Taylor": 5075,
    "Rawle Alkins": 6074,
    "Doron Lamb": 5076,
    "Trevon Duval": 6075,
    "Mike Scott": 6347,
    "Kenrich Williams": 6076,
    "Kim English": 5078,
    "Garlon Green": 6077,
    "Justin Hamilton": 5079,
    "Terry Larrier": 6078,
    "Darius Miller": 5080,
    "Rob Gray": 6079,
    "Ray Allen": 3080,
    "Kevin Murphy": 5081,
    "Devaughn Akoon-Purcell": 6080,
    "Kostas Papanikolaou": 5082,
    "Jordan Loyd": 6081,
    "Kyle O'Quinn": 5083,
    "Malik Newman": 6082,
    "Izzet Turkyilmaz": 5084,
    "Theo Pinson": 6083,
    "Marcus Camby": 3084,
    "Kris Joseph": 5085,
    "Ryan Broekhoff": 6084,
    "Ognjen Kuzmic": 5086,
    "Brandon Mccoy": 6085,
    "Furkan Aldemir": 5087,
    "Marcus Lee": 6086,
    "Tornike Shengelia": 5088,
    "Isaac Haas": 6087,
    "Darius Johnson-Odom": 5089,
    "Donte Grantham": 6088,
    "Tomislav Zubcic": 5090,
    "Trey Lewis": 6089,
    "Ilkan Karaman": 5091,
    "Joel Berry Ii": 6090,
    "Robbie Hummel": 5092,
    "Jeffrey Carroll": 6091,
    "Marcus Denmon": 5093,
    "Wenyen Gabriel": 6092,
    "Robert Sacre": 5094,
    "Doral Moore": 6093,
    "Allen Iverson": 3094,
    "Deng Adel": 6094,
    "Mirza Teletovic": 5095,
    "Tyler Davis": 6095,
    "Chris Copeland": 5096,
    "Marcus Derrickson": 6096,
    "Viacheslav Kravtsov": 5097,
    "Zach Lofton": 6097,
    "Pablo Prigioni": 5098,
    "Alexey Shved": 5099,
    "Markel Crawford": 6098,
    "Maalik Wayns": 5100,
    "Jordan Barnett": 6099,
    "Chris Smith": 5101,
    "Norvel Pelle": 6100,
    "Kent Bazemore": 5102,
    "Codi Miller-Mcintyre": 6101,
    "Jamar Smith": 5103,
    "Brandon Goodwin": 6102,
    "Steve Nash": 3103,
    "Micheal Eric": 5104,
    "Gabe York": 6103,
    "Brian Roberts": 5105,
    "B.J. Johnson": 6104,
    "Hollis Thompson": 5106,
    "Desi Rodriguez": 6105,
    "Scott Machado": 5107,
    "Tiwian Kendley": 6106,
    "Reeves Nelson": 5108,
    "Scoochie Smith": 6107,
    "Greg Somogyi": 5109,
    "Kaiser Gates": 6108,
    "Oscar Bellfield": 5110,
    "Drew Eubanks": 6109,
    "Henry Sims": 5111,
    "Robert Johnson": 6110,
    "John Shurna": 5112,
    "Elijah Stewart": 6111,
    "Antoine Walker": 3112,
    "Carleton Scott": 5113,
    "Daryl Macon": 6112,
    "Josh Akognon": 5114,
    "Braian Angola-Rodas": 6113,
    "Demonte Harper": 5115,
    "Kendrick Nunn": 6114,
    "Dallas Lauderdale": 5116,
    "Johnathan Williams": 6115,
    "Demetri Mccamey": 5117,
    "Yante Maten": 6116,
    "Erick Dampier": 3117,
    "Kyle Fogg": 5118,
    "Trevon Bluiett": 6117,
    "Kobe Bryant": 3118,
    "Carlon Brown": 5119,
    "Jaylen Adams": 6118,
    "Peja Stojakovic": 3119,
    "Rick Jackson": 5120,
    "Chris Chiozza": 6119,
    "Jermaine O'Neal": 3120,
    "Lance Goulbourne": 5121,
    "Jairus Lyles": 6120,
    "Ben Hansbrough": 5122,
    "Zydrunas Ilgauskas": 3121,
    "Gary Clark": 6121,
    "Devin Searcy": 5123,
    "Jaylen Barford": 6122,
    "Tyler Wilkerson": 5124,
    "Joe Chealey": 6123,
    "Wesley Witherspoon": 5125,
    "J.P. Macura": 6124,
    "Ronnie Aguilar": 5126,
    "Zach Smith": 6125,
    "Derek Fisher": 3125,
    "Andrea Bargnani": 4129,
    "Micah Downs": 5127,
    "Isaiah Wilkins": 6126,
    "Lamarcus Aldridge": 4130,
    "Dequan Jones": 5128,
    "Bonzie Colson": 6127,
    "Adam Morrison": 4131,
    "Michael Dunigan": 5129,
    "Billy Preston": 6128,
    "Tyrus Thomas": 4132,
    "Phil Jones": 5130,
    "Jonathan Stark": 6129,
    "Shelden Williams": 4133,
    "Jared Terrell": 6130,
    "Kevin Anderson": 5131,
    "Brandon Roy": 4134,
    "Angel Delgado": 6131,
    "Kevin Jones": 5132,
    "Randy Foye": 4135,
    "Yuta Watanabe": 6132,
    "Chris Johnson": 4839,
    "Rudy Gay": 4136,
    "Jordan Mclaughlin": 6133,
    "Hank Thorns": 5134,
    "Patrick O'Bryant": 4137,
    "Nuni Omot": 6134,
    "Diante Garrett": 5135,
    "Johnny Hamilton": 6135,
    "Tu Holloway": 5136,
    "Keenan Evans": 6136,
    "Dominique Morrison": 5137,
    "Jj Redick": 4139,
    "Justin Bibbs": 6137,
    "Chris Wright": 4947,
    "Hilton Armstrong": 4140,
    "Nick King": 6138,
    "Ryan Allen": 5139,
    "Thabo Sefolosha": 4141,
    "Jeff Roberson": 6139,
    "Vance Cooksey": 5140,
    "Ronnie Brewer": 4142,
    "Allonzo Trier": 6140,
    "Mustapha Farrakhan": 5141,
    "Justin Holiday": 5142,
    "Tyrius Walker": 6141,
    "Rodney Carney": 4144,
    "Devin Davis": 6142,
    "Shawne Williams": 4145,
    "Stefhon Hannah": 5143,
    "Mitch Creek": 6143,
    "Oleksiy Pecherov": 4146,
    "Steven Gray": 5144,
    "Matt Maloney": 3143,
    "Emanuel Terry": 6144,
    "Josh Owens": 5145,
    "Ding Yanyuhang": 6145,
    "Renaldo Balkman": 4148,
    "Willie Reed": 5146,
    "Ismaila Kane": 6146,
    "Cyril Awere": 5147,
    "Rajon Rondo": 4149,
    "Phillip Carr": 6147,
    "Marcus Williams": 4311,
    "Tony Mitchell": 5207,
    "Cameron Reynolds": 6148,
    "D'Aundray Brown": 5149,
    "Josh Boone": 4151,
    "Paul Watson": 6149,
    "Kyle Lowry": 4152,
    "Aron Baynes": 5150,
    "Ben Wallace": 3149,
    "Isaac Humphries": 6150,
    "Shannon Brown": 4153,
    "Brandon Sampson": 6151,
    "Tim Ohlbrecht": 5151,
    "Jordan Farmar": 4154,
    "Anthony Bennett": 5152,
    "Angel Rodriguez": 6152,
    "Victor Oladipo": 5153,
    "Sergio Rodriguez": 4155,
    "Raphiael Putney": 6153,
    "Otto Porter Jr.": 5154,
    "Tim Bond": 6154,
    "Maurice Ager": 4156,
    "Cody Zeller": 5155,
    "Haywood Highsmith": 6155,
    "Mardy Collins": 4157,
    "Alex Len": 5156,
    "Stephan Hicks": 6156,
    "Joel Freeland": 4158,
    "Nerlens Noel": 5157,
    "Dairis Bertans": 6157,
    "James White": 4159,
    "Ben Mclemore": 5158,
    "Cody Demps": 6158,
    "Steve Novak": 4160,
    "Kentavious Caldwell-Pope": 5159,
    "Dusty Hannahs": 6159,
    "Solomon Jones": 4161,
    "Trey Burke": 5160,
    "Jemerrio Jones": 6160,
    "Cj Mccollum": 5161,
    "Billy Garrett Jr.": 6161,
    "P.J. Tucker": 4163,
    "Michael Carter-Williams": 5162,
    "Tarik Phillip": 6162,
    "Craig Smith": 4164,
    "Steven Adams": 5163,
    "Zion Williamson": 6163,
    "Ja Morant": 6164,
    "Kelly Olynyk": 5164,
    "Rj Barrett": 6165,
    "Shabazz Muhammad": 5165,
    "De'Andre Hunter": 6166,
    "Darius Garland": 6167,
    "Jarrett Culver": 6168,
    "Daniel Gibson": 4170,
    "Coby White": 6169,
    "Jaxson Hayes": 6170,
    "Rui Hachimura": 6171,
    "Alexander Johnson": 4173,
    "Tim Thomas": 3170,
    "Cam Reddish": 6172,
    "Dee Brown": 4174,
    "Anthony Parker": 3171,
    "Cameron Johnson": 6173,
    "Paul Millsap": 4175,
    "Pj Washington": 6174,
    "Vladimir Veremeenko": 4176,
    "Tim Duncan": 3173,
    "Tyler Herro": 6175,
    "Leon Powe": 4177,
    "Chauncey Billups": 3174,
    "Romeo Langford": 6176,
    "Antonio Daniels": 3175,
    "Ryan Hollins": 4179,
    "Tony Battie": 3176,
    "Ron Mercer": 3177,
    "Adonal Foyle": 3178,
    "Tracy Mcgrady": 3179,
    "Edin Bavcic": 4183,
    "Giannis Antetokounmpo": 5185,
    "Lucas Nogueira": 5186,
    "Will Blalock": 4188,
    "Dennis Schroder": 5187,
    "Shane Larkin": 5188,
    "Louis Amundson": 4190,
    "Sergey Karasev": 5189,
    "Tony Snell": 5190,
    "Chris Quinn": 4192,
    "Gorgui Dieng": 5191,
    "Mason Plumlee": 5192,
    "Bobby Jackson": 3191,
    "Solomon Hill": 5193,
    "Tarence Kinsey": 4195,
    "Tim Hardaway Jr.": 5194,
    "John Thomas": 3193,
    "Reggie Bullock": 5195,
    "Pooh Jeter": 4197,
    "Andre Roberson": 5196,
    "Rudy Gobert": 5197,
    "Yakhouba Diawara": 4199,
    "Livio Jean-Charles": 5198,
    "Archie Goodwin": 5199,
    "Pops Mensah-Bonsu": 4201,
    "Nemanja Nedovic": 5200,
    "Allen Crabbe": 5201,
    "J.J. Barea": 4203,
    "Sekou Doumbouya": 6203,
    "Alex Abrines": 5202,
    "Chuma Okeke": 6204,
    "Carrick Felix": 5203,
    "Nickeil Alexander-Walker": 6205,
    "Isaiah Canaan": 5204,
    "Goga Bitadze": 6206,
    "Glen Rice Jr.": 5205,
    "Luka Samanic": 6207,
    "Ray Mccallum": 5206,
    "Marc Jackson": 3205,
    "Matisse Thybulle": 6208,
    "Brandon Clarke": 6209,
    "Nate Wolters": 5208,
    "Anthony Johnson": 3207,
    "Grant Williams": 6210,
    "Jeff Withey": 5209,
    "Darius Bazley": 6211,
    "Grant Jerrett": 5210,
    "Ty Jerome": 6212,
    "Jamaal Franklin": 5211,
    "Stephen Jackson": 3210,
    "Pierre Jackson": 5212,
    "Nassir Little": 6213,
    "Dylan Windler": 6214,
    "Ricky Ledo": 5213,
    "Cedric Henderson": 3212,
    "Mike Muscala": 5214,
    "Mfiondu Kabengele": 6215,
    "Marko Todorovic": 5215,
    "Jordan Poole": 6216,
    "Erick Green": 5216,
    "Keldon Johnson": 6217,
    "Kevin Porter Jr.": 6218,
    "Raul Neto": 5217,
    "Nicolas Claxton": 6219,
    "Ryan Kelly": 5218,
    "Kz Okpala": 6220,
    "Erik Murphy": 5219,
    "Antoine Hood": 4221,
    "Carsen Edwards": 6221,
    "James Ennis Iii": 5220,
    "Bruno Fernando": 6222,
    "Romero Osby": 5221,
    "Didi Louzada Silva": 6223,
    "Lorenzo Brown": 5222,
    "Cody Martin": 6224,
    "Colton Iverson": 5223,
    "Deividas Sirvydis": 6225,
    "Arsalan Kazemi": 5224,
    "Daniel Gafford": 6226,
    "Joffrey Lauvergne": 5225,
    "Alen Smailagic": 6227,
    "Peyton Siva": 5226,
    "Alex Oriakhi": 5227,
    "Justin James": 6228,
    "Deshaun Thomas": 5228,
    "Eric Paschall": 6229,
    "Bojan Dubljevic": 5229,
    "Admiral Schofield": 6230,
    "Mike Harris": 4230,
    "Janis Timma": 5230,
    "Gal Mekel": 5231,
    "Jaylen Nowell": 6231,
    "Luigi Datome": 5232,
    "Bol Bol": 6232,
    "Isaiah Roby": 6233,
    "Phil Pressey": 5233,
    "Talen Horton-Tucker": 6234,
    "Vitor Faverani": 5234,
    "Miroslav Raduljica": 5235,
    "Ignas Brazdeikis": 6235,
    "Elias Harris": 5236,
    "Terance Mann": 6236,
    "Ian Clark": 5237,
    "Quinndary Weatherspoon": 6237,
    "Pero Antic": 5238,
    "Jarrell Brantley": 6238,
    "Dee Bost": 5239,
    "Tremont Waters": 6239,
    "Renaldo Major": 4240,
    "Kevin Ollie": 3237,
    "Arinze Onuaku": 5240,
    "Jalen Mcdaniels": 6240,
    "Trent Lockett": 5241,
    "Justin Wright-Foreman": 6241,
    "E.J. Singler": 5242,
    "Marial Shayok": 6242,
    "Randolph Morris": 4242,
    "James Southerland": 5243,
    "Greg Oden": 4243,
    "Kyle Guy": 6243,
    "Brandon Davies": 5244,
    "Jaylen Hands": 6244,
    "Kevin Durant": 4244,
    "Seth Curry": 5245,
    "Jordan Bone": 6245,
    "Al Horford": 4245,
    "Eric Griffin": 5246,
    "Mike Conley": 4246,
    "Miye Oni": 6246,
    "Mickey Mcconnell": 5247,
    "Jeff Green": 4247,
    "Dewan Hernandez": 6247,
    "Toure' Murry": 5248,
    "Mike Bibby": 3245,
    "Vanja Marinkovic": 6248,
    "Matthew Dellavedova": 5249,
    "Jaylen Hoard": 6249,
    "Richard Howell": 5250,
    "Antawn Jamison": 3247,
    "Zach Norvell Jr.": 6250,
    "Carlos Morais": 5251,
    "Vince Carter": 3248,
    "Jalen Lecque": 6251,
    "Larry Drew Ii": 5252,
    "Adam Mokoka": 6252,
    "Robert Covington": 5253,
    "Jason Williams": 3250,
    "Bj Young": 5254,
    "Naz Reid": 6253,
    "Larry Hughes": 3251,
    "Jordan Henriquez": 5255,
    "Luguentz Dort": 6254,
    "Dirk Nowitzki": 3252,
    "Dewayne Dedmon": 5256,
    "John Konchar": 6255,
    "Paul Pierce": 3253,
    "Cameron Jones": 5257,
    "Dean Wade": 6256,
    "C.J. Leslie": 5258,
    "Bonzi Wells": 3254,
    "Jeremiah Martin": 6257,
    "Kalin Lucas": 5259,
    "Chris Silva": 6258,
    "Patrick Christopher": 5260,
    "Garrison Mathews": 6259,
    "Charlie Westbrook": 5261,
    "Vincent Poirier": 6260,
    "Jamychal Green": 5262,
    "Kyle Alexander": 6261,
    "Michael Lee": 5263,
    "William Howard": 6262,
    "Kenny Kadji": 5264,
    "Stanton Kidd": 6263,
    "Rasho Nesterovic": 3260,
    "Jorge Gutierrez": 5265,
    "Matt Thomas": 6264,
    "Deshawn Sims": 5266,
    "Jordan Caroline": 6265,
    "Damen Bell-Holter": 5267,
    "Zylan Cheatham": 6266,
    "Chris Babb": 5268,
    "Max Strus": 6267,
    "Kammron Taylor": 5269,
    "Tacko Fall": 6268,
    "Brian Skinner": 3265,
    "Javonte Green": 6269,
    "Rodney Mcgruder": 5270,
    "Nicolo Melli": 6270,
    "Dakota Mathias": 6271,
    "Al Harrington": 3268,
    "Luke Maye": 6272,
    "Josh Reaves": 6273,
    "Junior Cadougan": 5271,
    "Isaiah Pineiro": 6274,
    "Olek Czyz": 5272,
    "Caleb Martin": 6275,
    "Nazr Mohammed": 3272,
    "Trey Mckinney Jones": 5273,
    "Daquan Jeffries": 6276,
    "Reginald Becton": 5274,
    "Vic Law": 6277,
    "Vander Blue": 5275,
    "Marko Guduric": 6278,
    "Rashard Lewis": 3275,
    "Mac Koshwal": 5276,
    "Justin Robinson": 6279,
    "Khalif Wyatt": 5277,
    "Terence Davis": 6280,
    "Rodney Williams": 5278,
    "Kelan Martin": 6281,
    "David Lighty": 5279,
    "Tyler Cook": 6282,
    "Adonis Thomas": 5280,
    "Hassani Gravett": 6283,
    "James Nunnally": 5281,
    "Juwan Morgan": 6284,
    "Yi Jianlian": 4284,
    "Troy Daniels": 5282,
    "Armoni Brooks": 6285,
    "Abdul Gaddy": 5283,
    "Rafer Alston": 3282,
    "Corey Brewer": 3294,
    "Aric Holman": 6286,
    "Justin Brownlee": 5284,
    "Brandan Wright": 4286,
    "Lindell Wigginton": 6287,
    "Courtney Fells": 5285,
    "Joakim Noah": 4287,
    "Matt Mooney": 6288,
    "Myck Kabongo": 5286,
    "Spencer Hawes": 4288,
    "Moses Brown": 6289,
    "Dan Nwaelele": 5287,
    "Oshae Brissett": 6290,
    "Acie Law": 4289,
    "Sean Marks": 3287,
    "Sagaba Konate": 6291,
    "Thaddeus Young": 4290,
    "Casper Ware": 5289,
    "Devontae Cacok": 6292,
    "Julian Wright": 4291,
    "D.J. Stephens": 5290,
    "Charlie Brown": 6293,
    "Scotty Hopson": 5291,
    "Al Thornton": 4292,
    "Brian Bowen Ii": 6294,
    "Andrew Wiggins": 5292,
    "Rodney Stuckey": 4293,
    "Jakeenan Gant": 6295,
    "Jabari Parker": 5293,
    "Nick Young": 4294,
    "Eric Mika": 6296,
    "Joel Embiid": 5294,
    "Sean Williams": 4295,
    "Jalen Adams": 6297,
    "Aaron Gordon": 5295,
    "Marco Belinelli": 4296,
    "Kavell Bigby-Williams": 6298,
    "Javaris Crittenton": 4297,
    "Aubrey Dawkins": 6299,
    "Jason Smith": 4298,
    "Amir Hinton": 6300,
    "Daequan Cook": 4299,
    "V.J. King": 6301,
    "Lamar Peters": 6302,
    "Jared Dudley": 4300,
    "Kenny Wooten": 6303,
    "Wilson Chandler": 4301,
    "Jordan Murphy": 6304,
    "Rudy Fernandez": 4302,
    "Yudai Baba": 6305,
    "Morris Almond": 4303,
    "Javon Bess": 6306,
    "Aaron Brooks": 4304,
    "Mychal Mulder": 6307,
    "Arron Afflalo": 4305,
    "Robert Franks": 6308,
    "Tiago Splitter": 4306,
    "Ahmed Hill": 6309,
    "Brad Miller": 3305,
    "Alando Tucker": 4307,
    "Josh Perkins": 6310,
    "Ky Bowman": 6311,
    "Carl Landry": 4309,
    "Chris Clemons": 6312,
    "Mikki Moore": 3308,
    "Gabe Pruitt": 4310,
    "William Mcdowell-White": 6313,
    "Shamorie Ponds": 6314,
    "Amir Coffey": 6315,
    "Earl Boykins": 3311,
    "Christ Koumadje": 6316,
    "Glen Davis": 4313,
    "Isaiah Miles": 6317,
    "Josh Mcroberts": 4314,
    "Bryce Brown": 6318,
    "Kyrylo Fesenko": 4315,
    "Dant\u00e9 Exum": 5316,
    "Simi Shittu": 6319,
    "Marcus Smart": 5317,
    "John Egbunu": 6320,
    "Julius Randle": 5318,
    "Phil Booth": 6321,
    "Chris Richard": 4318,
    "Nik Stauskas": 5319,
    "Jared Harper": 6322,
    "Derrick Byars": 4319,
    "Noah Vonleh": 5320,
    "David Kramer": 6323,
    "Adam Haluska": 4320,
    "Elfrid Payton": 5321,
    "Norense Odiase": 6324,
    "Doug Mcdermott": 5322,
    "Tariq Owens": 6325,
    "Dario Saric": 5323,
    "Marques Bolden": 6326,
    "Damon Jones": 3322,
    "Zach Lavine": 5324,
    "Daulton Hommes": 6327,
    "Stephane Lasme": 4324,
    "T.J. Warren": 5325,
    "Dedric Lawson": 6328,
    "Marc Gasol": 4325,
    "Adreian Payne": 5326,
    "Elton Brand": 3324,
    "Juan Toscano-Anderson": 6329,
    "Jusuf Nurkic": 5327,
    "Aaron Gray": 4326,
    "Keljin Blevins": 6330,
    "James Young": 5328,
    "Jameson Curry": 4327,
    "Justin Simon": 6331,
    "Baron Davis": 3326,
    "Tyler Ennis": 5329,
    "Perrion Callandret": 6332,
    "Lamar Odom": 3327,
    "Renaldas Seibutis": 4329,
    "Gary Harris": 5330,
    "James Palmer Jr.": 6333,
    "Jonathan Bender": 3328,
    "Demetris Nichols": 4330,
    "Donta Hall": 6334,
    "Bruno Caboclo": 5331,
    "Mitch Mcgary": 5332,
    "Louis King": 6335,
    "Richard Hamilton": 3330,
    "Jordan Adams": 5333,
    "Todd Withers": 6336,
    "Andre Miller": 3331,
    "Rodney Hood": 5334,
    "Rayjon Tucker": 6337,
    "Ramon Sessions": 4333,
    "Shabazz Napier": 5335,
    "Shawn Marion": 3332,
    "Jon Davis": 6338,
    "Clint Capela": 5336,
    "Jason Terry": 3333,
    "Kavion Pippen": 6339,
    "Giorgos Printezis": 4335,
    "P.J. Hairston": 5337,
    "Tyus Battle": 6340,
    "D.J. Strawberry": 4336,
    "Bogdan Bogdanovic": 5338,
    "Barry Brown Jr.": 6341,
    "Mikolan Rakovic": 4337,
    "Cj Wilcox": 5339,
    "Devin Cannady": 6342,
    "Dominic Mcguire": 4338,
    "Corey Maggette": 3336,
    "Josh Huestis": 5340,
    "Cj Massinburg": 6343,
    "Joel Anthony": 4339,
    "Kyle Anderson": 5341,
    "Bj Taylor": 6344,
    "Damien Inglis": 5342,
    "Skyler Flatten": 6345,
    "Metta World Peace": 3339,
    "K.J. Mcdaniels": 5343,
    "Bubu Palo": 6346,
    "Jamario Moon": 4342,
    "Joe Harris": 5344,
    "Coby Karl": 4343,
    "James Posey": 3341,
    "Bennie Boatwright": 6348,
    "Cleanthony Early": 5345,
    "Mustafa Shakur": 4344,
    "Jarnell Stokes": 5346,
    "Trevor Lacey": 6349,
    "Matur Maker": 6350,
    "Johnny O'Bryant Iii": 5347,
    "Jeff Foster": 3344,
    "Deandre Daniels": 5348,
    "Kenny Gabriel": 6351,
    "Walker Russell Jr.": 4347,
    "Kenny Thomas": 3345,
    "Marcus Allen": 6352,
    "Spencer Dinwiddie": 5349,
    "Devean George": 3346,
    "Jerami Grant": 5350,
    "Gabe Vincent": 6353,
    "Andrei Kirilenko": 3347,
    "Glenn Robinson Iii": 5351,
    "Jontay Porter": 6354,
    "Nikola Jokic": 5352,
    "Anthony Edwards": 6355,
    "Nick Johnson": 5353,
    "James Wiseman": 6356,
    "Trey Johnson": 4352,
    "Edy Tavares": 5354,
    "Markel Brown": 5355,
    "C.J. Watson": 4354,
    "Dwight Powell": 5356,
    "Jordan Clarkson": 5357,
    "Russ Smith": 5358,
    "Michael Ruffin": 3355,
    "Lamar Patterson": 5359,
    "Thomas Gardner": 4358,
    "Cameron Bairstow": 5360,
    "Alec Brown": 5361,
    "Thanasis Antetokounmpo": 5362,
    "Vasilije Micic": 5363,
    "Mario West": 4362,
    "Alessandro Gentile": 5364,
    "Nemanja Dangubic": 5365,
    "Semaj Christon": 5366,
    "Devyn Marble": 5367,
    "Francisco Elson": 3364,
    "Louis Labeyrie": 5368,
    "Xavier Thames": 5369,
    "Jordan Mcrae": 5370,
    "Courtney Sims": 4369,
    "Cory Jefferson": 5371,
    "Damjan Rudez": 5372,
    "Anthony Tolliver": 4371,
    "Patric Young": 5373,
    "Eric Moreland": 5374,
    "Will Cherry": 5375,
    "Tyler Johnson": 5376,
    "Alex Kirk": 5377,
    "Shayne Whittington": 5378,
    "Bryce Cotton": 5379,
    "Sim Bhullar": 5380,
    "Darryl Watkins": 4380,
    "Jack Cooley": 5381,
    "Brock Motum": 5382,
    "Tarik Black": 5383,
    "Aaron Craft": 5384,
    "Doug Thomas": 4383,
    "Manu Ginobili": 3380,
    "James Michael Mcadoo": 5385,
    "Mitchell Watt": 5386,
    "Lance Allred": 4385,
    "C.J. Fair": 5387,
    "Blake Ahearn": 4386,
    "Langston Galloway": 5388,
    "Derrick Rose": 4387,
    "Travis Wear": 5389,
    "Khem Birch": 5390,
    "Michael Beasley": 4388,
    "Orlando Sanchez": 5391,
    "O.J. Mayo": 4389,
    "Lamelo Ball": 6395,
    "Brady Heslip": 5392,
    "Russell Westbrook": 4390,
    "Patrick Williams": 6396,
    "Joe Ingles": 5393,
    "Kevin Love": 4391,
    "Isaac Okoro": 6397,
    "Andre Dawkins": 5394,
    "Onyeka Okongwu": 6398,
    "Shawn Jones": 5395,
    "Chucky Atkins": 3391,
    "Killian Hayes": 6399,
    "Keith Appling": 5396,
    "Obi Toppin": 6400,
    "Deni Avdija": 6401,
    "Jabari Brown": 5397,
    "Roscoe Smith": 5398,
    "Jalen Smith": 6402,
    "Devin Vassell": 6403,
    "David Wear": 5400,
    "Tyrese Haliburton": 6404,
    "Anthony Carter": 3396,
    "Jamil Wilson": 5401,
    "Kira Lewis Jr.": 6405,
    "Joe Jackson": 5402,
    "Aaron Nesmith": 6406,
    "Casey Prather": 5403,
    "Cole Anthony": 6407,
    "Luke Hancock": 5404,
    "Isaiah Stewart": 6408,
    "Kenyon Martin": 3400,
    "Akil Mitchell": 5405,
    "Aleksej Pokusevski": 6409,
    "Justin Cobbs": 5406,
    "Darius Miles": 3402,
    "Josh Green": 6410,
    "Brian Qvale": 5407,
    "Saddiq Bey": 6411,
    "Marcus Fizer": 3403,
    "John Holland": 5408,
    "Precious Achiuwa": 6412,
    "Mike Miller": 3404,
    "Josh Davis": 3805,
    "Tyrese Maxey": 6413,
    "Dermarr Johnson": 3405,
    "Chris Crawford": 5410,
    "Zeke Nnaji": 6414,
    "Zoran Dragic": 5411,
    "Leandro Bolmaro": 6415,
    "Kadeem Batts": 5412,
    "Jamal Crawford": 3407,
    "R.J. Hampton": 6416,
    "Drew Crawford": 5413,
    "Joel Przybilla": 3408,
    "Immanuel Quickley": 6417,
    "Tim Frazier": 5414,
    "Keyon Dooling": 3409,
    "Payton Pritchard": 6418,
    "Christian Watford": 5415,
    "Udoka Azubuike": 6419,
    "Ronald Roberts": 5416,
    "Etan Thomas": 3411,
    "Jaden Mcdaniels": 6420,
    "Jakarr Sampson": 5417,
    "Malachi Flynn": 6421,
    "Josh Bostic": 5418,
    "Desmond Bane": 6422,
    "Jarell Eddie": 5419,
    "Tyrell Terry": 6423,
    "David Stockton": 5420,
    "Hedo Turkoglu": 3415,
    "Vernon Carey Jr.": 6424,
    "Michael Jenkins": 5421,
    "Daniel Oturu": 6425,
    "Talib Zanna": 5422,
    "Quentin Richardson": 3417,
    "Theo Maledon": 6426,
    "Richard Solomon": 5423,
    "Jamaal Magloire": 3418,
    "Xavier Tillman": 6427,
    "Jerrelle Benimon": 5424,
    "Tyler Bey": 6428,
    "Stephen Holt": 5425,
    "Vit Krejci": 6429,
    "Morris Peterson": 3420,
    "Drew Gordon": 5426,
    "Saben Lee": 6430,
    "Yuki Togashi": 5427,
    "Elijah Hughes": 6431,
    "Deshawn Stevenson": 3422,
    "Sean Kilpatrick": 5428,
    "Robert Woodard Ii": 6432,
    "Geron Johnson": 5429,
    "Tre Jones": 6433,
    "Jordan Vandenberg": 5430,
    "Nick Richards": 6434,
    "Jahmi'Us Ramsey": 6435,
    "Karl-Anthony Towns": 5432,
    "Primoz Brezec": 3426,
    "Marko Simonovic": 6436,
    "D'Angelo Russell": 5433,
    "Jordan Nwora": 6437,
    "Jahlil Okafor": 5434,
    "Cj Elleby": 6438,
    "Marko Jaric": 3429,
    "Yam Madar": 6439,
    "Nico Mannion": 6440,
    "Isaiah Joe": 6441,
    "Jake Voskuhl": 3432,
    "Skylar Mays": 6442,
    "Justinian Jessup": 6443,
    "Kj Martin Jr.": 6444,
    "Cassius Winston": 6445,
    "Cassius Stanley": 6446,
    "Eddie House": 3436,
    "Jay Scrubb": 6447,
    "Eduardo Najera": 3437,
    "Grant Riller": 6448,
    "Reggie Perry": 6449,
    "Paul Reed": 6450,
    "Jalen Harris": 6451,
    "Sam Merrill": 6452,
    "Michael Redd": 3442,
    "Mason Jones": 6453,
    "Brian Cardinal": 3443,
    "Devon Dotson": 6454,
    "Ty-Shon Alexander": 6455,
    "Mamadi Diakite": 6456,
    "Breein Tyree": 6457,
    "Jake Toolson": 6458,
    "Jason Hart": 3448,
    "Lamar Stevens": 6459,
    "Killian Tillie": 6460,
    "Sean Mcdermott": 6461,
    "Nathan Knight": 6462,
    "Jae'Sean Tate": 6463,
    "Trent Forrest": 6464,
    "Ashton Hagans": 6465,
    "Markus Howard": 6466,
    "Romaro Gill": 6467,
    "Facundo Campazzo": 6468,
    "Kristaps Porzingis": 5464,
    "Freddie Gillespie": 6469,
    "Mario Hezonja": 5465,
    "Devonte Patterson": 6470,
    "Willie Cauley-Stein": 5466,
    "Anthony Gill": 6471,
    "Emmanuel Mudiay": 5467,
    "Nate Hinton": 6472,
    "Stanley Johnson": 5468,
    "Keandre Cook": 6473,
    "Frank Kaminsky": 5469,
    "Nate Darling": 6474,
    "Justise Winslow": 5470,
    "Javin Delaurier": 6475,
    "Danilo Gallinari": 4468,
    "Myles Turner": 5471,
    "Xavier Sneed": 6476,
    "Eric Gordon": 4469,
    "Trey Lyles": 5472,
    "Charles Matthews": 6477,
    "Joe Alexander": 4470,
    "Raja Bell": 3467,
    "Devin Booker": 5473,
    "Jordan Bowden": 6478,
    "D.J. Augustin": 4471,
    "Nate Sestina": 6479,
    "Cameron Payne": 5474,
    "Brook Lopez": 4472,
    "Malik Fitts": 6480,
    "Kelly Oubre Jr.": 5475,
    "Jerryd Bayless": 4473,
    "Jordan Ford": 6481,
    "Terry Rozier": 5476,
    "Jason Thompson": 4474,
    "Eddie Gill": 3471,
    "Kaleb Wesson": 6482,
    "Rashad Vaughn": 5477,
    "Brandon Rush": 4475,
    "Brodric Thomas": 6483,
    "Sam Dekker": 5478,
    "Anthony Randolph": 4476,
    "Rayshaun Hammonds": 6484,
    "Jerian Grant": 5479,
    "Jahlil Tripp": 6485,
    "Delon Wright": 5480,
    "Robin Lopez": 4477,
    "Paul Eboua": 6486,
    "Justin Anderson": 5481,
    "Marreese Speights": 4478,
    "Ej Montgomery": 6487,
    "Roy Hibbert": 4479,
    "Bobby Portis": 5482,
    "Will Magnay": 6488,
    "Javale Mcgee": 4480,
    "Rondae Hollis-Jefferson": 5483,
    "Myles Powell": 6489,
    "J.J. Hickson": 4481,
    "Tyus Jones": 5484,
    "Jon Teske": 6490,
    "Alexis Ajinca": 4482,
    "Jarell Martin": 5485,
    "Yoeli Childs": 6491,
    "Nikola Milutinov": 5486,
    "Ryan Anderson": 4483,
    "Caleb Homesley": 6492,
    "Larry Nance Jr.": 5487,
    "Marlon Taylor": 6493,
    "Courtney Lee": 4484,
    "R.J. Hunter": 5488,
    "Ade Murkey": 6494,
    "Kosta Koufos": 4485,
    "Chris Mccullough": 5489,
    "Liangelo Ball": 6495,
    "Serge Ibaka": 4486,
    "Kevon Looney": 5490,
    "Anthony Lamb": 6496,
    "Nicolas Batum": 4487,
    "Karim Mane": 6497,
    "Cedi Osman": 5491,
    "George Hill": 4488,
    "Josh Hall": 6498,
    "Montrezl Harrell": 5492,
    "Naji Marshall": 6499,
    "Darrell Arthur": 4489,
    "Jordan Mickey": 5493,
    "Trevelin Queen": 6500,
    "Donte Greene": 4490,
    "Anthony Brown": 5494,
    "Ahmad Caver": 6501,
    "Dj White": 4491,
    "Guillermo Hernang\u00f3mez": 5495,
    "Dwayne Sutton": 6502,
    "J.R. Giddens": 4492,
    "Rakeem Christmas": 5496,
    "Tyler Hall": 6503,
    "Nikola Pekovic": 4493,
    "Richaun Holmes": 5497,
    "Kahlil Whitney": 6504,
    "Joey Dorsey": 4494,
    "Darrun Hilliard": 5498,
    "Tre Scott": 6505,
    "Walter Sharpe": 4495,
    "Juan Vaulet": 5499,
    "Shaq Buchanan": 6506,
    "Mario Chalmers": 4496,
    "Josh Richardson": 5500,
    "Trey Mourning": 6507,
    "Deandre Jordan": 4497,
    "Pat Connaughton": 5501,
    "Olivier Hanlan": 5502,
    "Luc Richard Mbah A Moute": 4498,
    "Joe Young": 5503,
    "Omer Asik": 4499,
    "Andrew Harrison": 5504,
    "Kyle Weaver": 4500,
    "Marcus Thornton": 4648,
    "Sonny Weems": 4501,
    "Norman Powell": 5506,
    "Ime Udoka": 3501,
    "Chris Douglas-Roberts": 4502,
    "Arturas Gudaitis": 5507,
    "Nathan Jawai": 4503,
    "Dakari Johnson": 5508,
    "Aaron White": 5509,
    "Patrick Ewing Jr.": 4505,
    "Marcus Eriksson": 5510,
    "Tyler Harvey": 5511,
    "Goran Dragic": 4507,
    "Malik Allen": 3507,
    "Satnam Singh": 5512,
    "Trent Plaisted": 4508,
    "Sir'Dominic Pointer": 5513,
    "Henry Walker": 4509,
    "Daniel Diez": 5514,
    "Malik Hairston": 4510,
    "Cady Lalanne": 5515,
    "Kwame Brown": 3511,
    "Branden Dawson": 5516,
    "Nikola Radicevic": 5517,
    "Tyson Chandler": 3512,
    "Shan Foster": 4513,
    "J.P. Tokoto": 5518,
    "Pau Gasol": 3513,
    "Darnell Jackson": 4514,
    "Dimitrios Agravanis": 5519,
    "Eddy Curry": 3514,
    "Luka Mitrovic": 5520,
    "Maarty Leunen": 4515,
    "Jason Richardson": 3515,
    "Tadija Dragicevic": 4516,
    "Luis Montero": 5521,
    "Shane Battier": 3516,
    "Cristiano Felicio": 5522,
    "Sasha Kaun": 4518,
    "Aaron Harrison": 5523,
    "James Gist": 4519,
    "Desagana Diop": 3518,
    "Boban Marjanovic": 5524,
    "Joe Crawford": 4520,
    "Duje Dukan": 5525,
    "Joe Johnson": 3520,
    "Jonathon Simmons": 5526,
    "Semih Erden": 4522,
    "Michale Kyser": 5527,
    "Vladimir Radmanovic": 3522,
    "Axel Toupane": 5528,
    "Richard Jefferson": 3523,
    "Ryan Boatright": 5529,
    "Bobby Brown": 4525,
    "Maurice Ndour": 5530,
    "Troy Murphy": 3524,
    "Cliff Alexander": 5531,
    "Steven Hunter": 3525,
    "Brandon Ashley": 5532,
    "Anthony Morrow": 4527,
    "Jj O'Brien": 5533,
    "Tony Parker": 3527,
    "Scottie Wilbekin": 5534,
    "Jamaal Tinsley": 3528,
    "Steven Hill": 4530,
    "Terran Petteway": 5535,
    "Hamed Haddadi": 4531,
    "Salah Mejri": 5536,
    "Jason Collins": 3530,
    "Brandon Heath": 4532,
    "Melvin Ejim": 5537,
    "Zach Randolph": 3531,
    "Rob Kurz": 4533,
    "Jonathan Holmes": 5538,
    "Brendan Haywood": 3532,
    "Treveon Graham": 5539,
    "Gerald Wallace": 3533,
    "Bryce Dejean-Jones": 5540,
    "Samuel Dalembert": 3534,
    "Corey Hawkins": 5541,
    "Michael Frazier": 5542,
    "Greg Whittington": 5543,
    "Tre Kelley": 4539,
    "Marcelo Huertas": 5544,
    "Darion Atkins": 5545,
    "Trenton Hassell": 3539,
    "Wesley Saunders": 5546,
    "Gilbert Arenas": 3540,
    "Robert Upshaw": 5547,
    "Brian Hamilton": 4543,
    "Sam Thompson": 5548,
    "Jason Washburn": 5549,
    "Kyle Casey": 5550,
    "Brian Scalabrine": 3544,
    "Nick Wiggins": 5551,
    "Kleon Penn": 5552,
    "James Mays": 4548,
    "Travis Trice Ii": 5553,
    "Mehmet Okur": 3547,
    "Marcus Hubbard": 4549,
    "Will Cummings": 5554,
    "Denzel Livingston": 5555,
    "Vernon Hamilton": 4551,
    "Earl Watson": 3549,
    "Chris Walker": 5556,
    "Cheyne Gadson": 4552,
    "Joshua Smith": 5557,
    "Bobby Simmons": 3551,
    "Jon Horford": 5558,
    "Shannon Scott": 5559,
    "Corey Webster": 5560,
    "Nnanna Egwu": 5561,
    "Loren Woods": 3555,
    "Jordan Sibert": 5562,
    "Coty Clarke": 5563,
    "Ron Howard": 4556,
    "Malcolm Miller": 5564,
    "Levi Randolph": 5565,
    "Corey Walden": 5566,
    "Cartier Martin": 4559,
    "Jaleel Roberts": 5567,
    "Chris Hunter": 4560,
    "Jaron Johnson": 5568,
    "Jarron Collins": 3562,
    "Blake Griffin": 4561,
    "Edgar Sosa": 5569,
    "Hasheem Thabeet": 4562,
    "Juwan Staten": 5570,
    "James Harden": 4563,
    "Marcus Simmons": 5571,
    "Tyreke Evans": 4564,
    "Jake Anderson": 5572,
    "Devin Sweetney": 5573,
    "Nick Minnerath": 5574,
    "Maurice Evans": 3568,
    "Omari Johnson": 5575,
    "Keifer Sykes": 5576,
    "Youssou Ndoye": 5577,
    "Charlie Bell": 3570,
    "Marshall Henderson": 5578,
    "Vince Hunter": 5579,
    "Michael Holyfield": 5580,
    "Lazeric Jones": 5581,
    "T.J. Mcconnell": 5582,
    "Christian Wood": 5583,
    "Jordan Bachynski": 5584,
    "Mike James": 5874,
    "Dez Wells": 5585,
    "Sampson Carter": 5586,
    "Kadeem Jack": 5587,
    "Quinn Cook": 5588,
    "Michael Qualls": 5589,
    "Alex Stepheson": 5590,
    "Mirza Begic": 5591,
    "Bo Mccalebb": 5592,
    "Carlos Arroyo": 3585,
    "Briante Weber": 5593,
    "Julian Washburn": 5595,
    "Michael Cobbins": 5596,
    "Eric Atkins": 5597,
    "Alan Williams": 5598,
    "Xavier Munford": 5599,
    "Ben Simmons": 5600,
    "Brandon Ingram": 5601,
    "Jaylen Brown": 5602,
    "Chris Andersen": 3598,
    "Yao Ming": 3599,
    "Mike Dunleavy": 3601,
    "Drew Gooden": 3602,
    "Nikoloz Tskitishvili": 3603,
    "Nene Hilario": 3605,
    "Chris Wilcox": 3606,
    "Amar'E Stoudemire": 3607,
    "Caron Butler": 3608,
    "Jared Jeffries": 3609,
    "Melvin Ely": 3610,
    "Ricky Rubio": 4610,
    "Jonny Flynn": 4611,
    "Stephen Curry": 4612,
    "Jordan Hill": 4613,
    "Demar Derozan": 4614,
    "Brandon Jennings": 4615,
    "Terrence Williams": 4616,
    "Gerald Henderson": 4617,
    "Tyler Hansbrough": 4618,
    "Earl Clark": 4619,
    "Tayshaun Prince": 3621,
    "Austin Daye": 4620,
    "Nenad Krstic": 3622,
    "James Johnson": 4621,
    "Jrue Holiday": 4622,
    "John Salmons": 3624,
    "Ty Lawson": 4623,
    "Jeff Teague": 4624,
    "Eric Maynor": 4625,
    "Dragan Bender": 5635,
    "Darren Collison": 4626,
    "Roger Mason Jr.": 3628,
    "Kris Dunn": 5636,
    "Victor Claver": 4627,
    "Buddy Hield": 5637,
    "Omri Casspi": 4628,
    "Jamal Murray": 5638,
    "Byron Mullens": 4629,
    "Dan Gadzuric": 3631,
    "Marquese Chriss": 5639,
    "Rodrigue Beaubois": 4630,
    "Carlos Boozer": 3632,
    "Jakob Poeltl": 5640,
    "Taj Gibson": 4631,
    "Thon Maker": 5641,
    "David Andersen": 3634,
    "Demarre Carroll": 4632,
    "Domantas Sabonis": 5642,
    "Wayne Ellington": 4633,
    "Taurean Prince": 5643,
    "Toney Douglas": 4634,
    "Georgios Papagiannis": 5644,
    "Christian Eyenga": 4635,
    "Denzel Valentine": 5645,
    "Jeff Ayres": 4636,
    "Juancho Hernang\u00f3mez": 5646,
    "Jermaine Taylor": 4637,
    "Flip Murray": 3639,
    "Guerschon Yabusele": 5647,
    "Dante Cunningham": 4638,
    "Wade Baldwin Iv": 5648,
    "Dajuan Summers": 4639,
    "Henry Ellenson": 5649,
    "Malik Beasley": 5650,
    "Matt Barnes": 3643,
    "Sam Young": 4641,
    "Caris Levert": 5651,
    "Jamal Sampson": 3644,
    "Dejuan Blair": 4642,
    "Deandre' Bembry": 5652,
    "Jon Brockman": 4643,
    "Malachi Richardson": 5653,
    "Ante Zizic": 5654,
    "Jonas Jerebko": 4644,
    "Darius Songaila": 3647,
    "Derrick Brown": 4645,
    "Timoth\u00e9 Luwawu-Cabarrot": 5655,
    "Jodie Meeks": 4646,
    "Brice Johnson": 5656,
    "Furkan Korkmaz": 5657,
    "Patrick Beverley": 4647,
    "Rasual Butler": 3650,
    "Pascal Siakam": 5658,
    "Skal Labissiere": 5659,
    "Chase Budinger": 4649,
    "Dejounte Murray": 5660,
    "Nick Calathes": 4650,
    "Luis Scola": 3653,
    "Damian Jones": 5661,
    "Danny Green": 4651,
    "Deyonta Davis": 5662,
    "Taylor Griffin": 4652,
    "Ivica Zubac": 5663,
    "Predrag Savovic": 3656,
    "Cheick Diallo": 5664,
    "Junior Harrington": 3657,
    "Tyler Ulis": 5665,
    "Rade Zagorac": 5666,
    "Malcolm Brogdon": 5667,
    "A.J. Price": 4657,
    "Chinanu Onuaku": 5668,
    "Jannero Pargo": 3660,
    "Nando De Colo": 4658,
    "Patrick Mccaw": 5669,
    "Robert Vaden": 4659,
    "David Michineau": 5670,
    "Patty Mills": 4660,
    "Reggie Evans": 3663,
    "Diamond Stone": 5671,
    "Ahmad Nivins": 4661,
    "Stephen Zimmerman Jr.": 5672,
    "Emir Preldzic": 4662,
    "Isaiah Whitehead": 5673,
    "Zhou Qi": 5674,
    "Lester Hudson": 4663,
    "Isaia Cordinier": 5675,
    "Demetrius Jackson": 5676,
    "Robert Dozier": 4665,
    "A.J. Hammons": 5677,
    "Trey Gilder": 4666,
    "Jake Layman": 5678,
    "Paul Zipser": 5679,
    "Antonio Anderson": 4669,
    "Michael Gbinije": 5680,
    "Devin Brown": 3673,
    "Tony Gaffney": 4670,
    "Georges Niang": 5681,
    "Ben Bentil": 5682,
    "Joel Bolomboy": 5683,
    "Petr Cornelie": 5684,
    "Dionte Christmas": 4674,
    "Kay Felder": 5685,
    "Marcus Paige": 5686,
    "Daniel Hamilton": 5687,
    "Garret Siler": 4676,
    "Wang Zhelin": 5688,
    "J.R. Bremer": 3681,
    "Abdel Nader": 5689,
    "Isaiah Cousins": 5690,
    "Tyrone Wallace": 5691,
    "Diamon Simpson": 4681,
    "Marshall Plumlee": 5692,
    "Garrett Temple": 4682,
    "Dorian Finney-Smith": 5693,
    "Mindaugas Kuzminskas": 5694,
    "Jerel Mcneal": 4684,
    "Ryan Arcidiacono": 5695,
    "Malcolm Delaney": 5696,
    "Alonzo Gee": 4686,
    "Okaro White": 5697,
    "Larry Owens": 4687,
    "Jonathan Gibson": 5698,
    "Nicolas Brussino": 5699,
    "Mike Wilks": 3692,
    "Marcus Landry": 4689,
    "Kyle Collinsworth": 5700,
    "Brandon Paul": 5701,
    "Raymond Sykes": 4691,
    "Mike Tobey": 5702,
    "Curtis Jerrells": 4692,
    "Tim Quarterman": 5703,
    "Ron Baker": 5704,
    "Wesley Matthews": 4694,
    "Jarrod Uthoff": 5705,
    "Chasson Randle": 5706,
    "Luke Nevill": 4696,
    "Patricio Garino": 5707,
    "Wayne Selden Jr.": 5708,
    "Troy Williams": 5709,
    "Yanick Moreira": 5710,
    "Lebron James": 3704,
    "Alex Poythress": 5711,
    "Darko Milicic": 3705,
    "Julian Jacobs": 5712,
    "Carmelo Anthony": 3706,
    "Anthony Barber": 5713,
    "Chris Bosh": 3707,
    "Quincy Ford": 5714,
    "Dwyane Wade": 3708,
    "Andrew Andrews": 5715,
    "Chris Kaman": 3709,
    "Rasheed Sulaimon": 5716,
    "Kirk Hinrich": 3710,
    "Nick Zeisloft": 5717,
    "T.J. Ford": 3711,
    "Matt Costello": 5718,
    "Sundiata Gaines": 4708,
    "Michael Sweetney": 3712,
    "Beau Beech": 5719,
    "Cedric Jackson": 4709,
    "Jarvis Hayes": 3713,
    "Yogi Ferrell": 5720,
    "Reggie Williams": 4710,
    "Mickael Pietrus": 3714,
    "Egidijus Mockevicius": 5721,
    "Othyus Jeffers": 4711,
    "Nick Collison": 3715,
    "Zach Auguste": 5722,
    "Kenny Hasbrouck": 4712,
    "Marcus Banks": 3716,
    "Stefan Jankovic": 5723,
    "Brian Butch": 4713,
    "Luke Ridnour": 3717,
    "Shawn Dawson": 5724,
    "Greg Stiemsma": 4714,
    "Shawn Long": 5725,
    "Oliver Lafayette": 4715,
    "Bryn Forbes": 5726,
    "John Wall": 4716,
    "Fred Vanvleet": 5727,
    "Evan Turner": 4717,
    "David West": 3721,
    "Danuel House Jr.": 5728,
    "Derrick Favors": 4718,
    "Sheldon Mac": 5729,
    "Sasha Pavlovic": 3722,
    "Wesley Johnson": 4719,
    "Daniel Ochefu": 5730,
    "Dahntay Jones": 3723,
    "Demarcus Cousins": 4720,
    "James Webb Iii": 5731,
    "Boris Diaw": 3724,
    "Ekpe Udoh": 4721,
    "Jalen Jones": 5732,
    "Greg Monroe": 4722,
    "Damion Lee": 5733,
    "Travis Outlaw": 3726,
    "Al-Farouq Aminu": 4723,
    "Elgin Cook": 5734,
    "Brian Cook": 3727,
    "Tianju He": 5735,
    "Gordon Hayward": 4724,
    "Carlos Delfino": 3728,
    "Keith Hornsby": 5736,
    "Paul George": 4725,
    "Jameel Warney": 5737,
    "Cole Aldrich": 4726,
    "Kendrick Perkins": 3730,
    "C.J. Williams": 5738,
    "Xavier Henry": 4727,
    "Leandro Barbosa": 3731,
    "Gary Payton Ii": 5739,
    "Ed Davis": 4728,
    "Josh Howard": 3732,
    "Isaiah Taylor": 5740,
    "Patrick Patterson": 4729,
    "Kyle Wiltjer": 5741,
    "Larry Sanders": 4730,
    "Jason Kapono": 3734,
    "Perry Ellis": 5742,
    "Luke Walton": 3735,
    "Luke Babbitt": 4731,
    "Scott Wood": 5743,
    "Gracin Bakumanya": 5744,
    "Derek Cooke Jr.": 5745,
    "Szymon Szewczyk": 3738,
    "Shaquille Harrison": 5746,
    "Derrick Jones Jr.": 5747,
    "D'Vauntes Smith-Rivera": 5748,
    "Steve Blake": 3741,
    "Thomas Walkup": 5749,
    "J.J. Avila": 5750,
    "Marcus Georges-Hunt": 5751,
    "Willie Green": 3744,
    "Trey Freeman": 5752,
    "Zaza Pachulia": 3745,
    "Nikola Jovanovic": 5753,
    "Alex Caruso": 5754,
    "Keith Bogans": 3746,
    "Kaleb Tarczewski": 5755,
    "Josh Magette": 5756,
    "Matt Bonner": 3748,
    "Nicolas Laprovittola": 5757,
    "Vashil Fernandez": 5758,
    "Mo Williams": 3750,
    "Jaleel Cousins": 5759,
    "Kellen Dunham": 5760,
    "Kevin Seraphin": 4748,
    "James Jones": 3752,
    "Ramon Galloway": 5761,
    "Eric Bledsoe": 4749,
    "David Nwaba": 5762,
    "Avery Bradley": 4750,
    "Kyle Korver": 3754,
    "Markelle Fultz": 5763,
    "James Anderson": 4751,
    "Craig Brackins": 4752,
    "Lonzo Ball": 5764,
    "Tommy Smith": 3756,
    "Elliot Williams": 4753,
    "Jayson Tatum": 5765,
    "Trevor Booker": 4754,
    "Josh Jackson": 5766,
    "Damion James": 4755,
    "De'Aaron Fox": 5767,
    "Dominique Jones": 4756,
    "Jonathan Isaac": 5768,
    "Lauri Markkanen": 5769,
    "Quincy Pondexter": 4757,
    "Jordan Crawford": 4758,
    "Greivis Vasquez": 4759,
    "Daniel Orton": 4760,
    "Marquis Daniels": 3764,
    "Lazar Hayward": 4761,
    "Udonis Haslem": 3765,
    "Tibor Pleiss": 4762,
    "Dexter Pittman": 4763,
    "Quinton Ross": 3767,
    "Hassan Whiteside": 4764,
    "Kirk Penney": 3768,
    "Armon Johnson": 4765,
    "Nemanja Bjelica": 4766,
    "Terrico White": 4767,
    "Darington Hobson": 4768,
    "Andy Rautins": 4769,
    "Landry Fields": 4770,
    "Josh Powell": 3774,
    "Lance Stephenson": 4771,
    "Jarvis Varnado": 4772,
    "Da'Sean Butler": 4773,
    "Devin Ebanks": 4774,
    "Jerome Jordan": 4775,
    "Paulo Prestes": 4776,
    "Gani Lawal": 4777,
    "Tiny Gallon": 4778,
    "Latavious Williams": 4779,
    "Ryan Richards": 4780,
    "Solomon Alabi": 4781,
    "Matt Carroll": 3785,
    "Magnum Rolle": 4782,
    "Luke Harangody": 4783,
    "Pape Sy": 4784,
    "Ronald Dupree": 3788,
    "Willie Warren": 4785,
    "Jeremy Evans": 4786,
    "Hamady Ndiaye": 4787,
    "Ryan Reid": 4788,
    "Derrick Caracter": 4789,
    "Stanley Robinson": 4790,
    "Dwayne Collins": 4791,
    "Ben Uzoh": 4792,
    "Brian Zoubek": 4793,
    "Timofey Mozgov": 4794,
    "Jeremy Lin": 4795,
    "Gary Neal": 4796,
    "Matt Janning": 4797,
    "Sherron Collins": 4798,
    "Samardo Samuels": 4799,
    "Ish Smith": 4800,
    "Ryan Thompson": 4801,
    "Jeff Adrien": 4802,
    "Eric Boateng": 4803,
    "Shane Edwards": 4804,
    "Gary Forbes": 4805,
    "Dwight Lewis": 4806,
    "Keith Mcleod": 3810,
    "Seth Tarver": 4807,
    "Eric Williams": 4808,
    "Vernon Goodridge": 4809,
    "Frank Ntilikina": 5821,
    "Drew Naymick": 4810,
    "Dennis Smith Jr.": 5822,
    "Russell Hicks": 4811,
    "Zach Collins": 5823,
    "Marcus Cousin": 4812,
    "Malik Monk": 5824,
    "Jon Scheyer": 4813,
    "Luke Kennard": 5825,
    "Stephen Dennis": 4814,
    "Donovan Mitchell": 5826,
    "Dwight Howard": 3818,
    "Kevin Palmer": 4815,
    "Bam Adebayo": 5827,
    "Emeka Okafor": 3819,
    "Evan Brock": 4816,
    "Ben Gordon": 3820,
    "Richard Delk": 4817,
    "Justin Patton": 5829,
    "Shaun Livingston": 3821,
    "Ricardo Marsh": 4818,
    "D.J. Wilson": 5830,
    "Devin Harris": 3822,
    "Patrick Sullivan": 4819,
    "Tj Leaf": 5831,
    "Josh Childress": 3823,
    "Tory Jackson": 4820,
    "John Collins": 5832,
    "Luol Deng": 3824,
    "Chris Kramer": 4821,
    "Harry Giles Iii": 5833,
    "Billy Rush": 4822,
    "Terrance Ferguson": 5834,
    "Andre Iguodala": 3826,
    "Mickell Gladness": 4823,
    "Jarrett Allen": 5835,
    "Luke Jackson": 3827,
    "Anthony Mason Jr.": 4824,
    "Og Anunoby": 5836,
    "James Florence": 4825,
    "Tyler Lydon": 5837,
    "Andris Biedrins": 3828,
    "Marqus Blakely": 4826,
    "Anzejs Pasecniks": 5838,
    "Manny Harris": 4827,
    "Sebastian Telfair": 3830,
    "Caleb Swanigan": 5839,
    "Tasmin Mitchell": 4828,
    "Kris Humphries": 3831,
    "Kyle Kuzma": 5840,
    "Jordan Eglseder": 4829,
    "Al Jefferson": 3832,
    "Tony Bradley": 5841,
    "Michael Washington": 4830,
    "Derrick White": 5842,
    "Tweety Carter": 4831,
    "Josh Smith": 3834,
    "Josh Hart": 5843,
    "Jerome Dyson": 4832,
    "Frank Jackson": 5844,
    "J.R. Smith": 3835,
    "Elijah Millsap": 4833,
    "Davon Reed": 5845,
    "Dorell Wright": 3836,
    "Wes Iwundu": 5846,
    "Zabian Dowdell": 4834,
    "Jameer Nelson": 3837,
    "Connor Atchley": 4835,
    "Frank Mason Iii": 5847,
    "Ivan Rabb": 5848,
    "Donald Sloan": 4836,
    "Matt Rogers": 4837,
    "Jonah Bolden": 5849,
    "Longar Longar": 4838,
    "Delonte West": 3841,
    "Semi Ojeleye": 5850,
    "Jordan Bell": 5851,
    "Tony Allen": 3842,
    "Kyrie Irving": 4840,
    "Jawun Evans": 5852,
    "Kevin Martin": 3843,
    "Dwayne Bacon": 5853,
    "Sasha Vujacic": 3844,
    "Tyler Dorsey": 5854,
    "Beno Udrih": 3845,
    "Thomas Bryant": 5855,
    "Isaiah Hartenstein": 5856,
    "Anderson Varejao": 3847,
    "Damyean Dotson": 5857,
    "Dillon Brooks": 5858,
    "Sterling Brown": 5859,
    "Ike Anigbogu": 5860,
    "Sindarius Thornwell": 5861,
    "Andre Emmett": 3852,
    "Vlatko Cancar": 5862,
    "Mathias Lessort": 5863,
    "Royal Ivey": 3854,
    "Monte Morris": 5864,
    "Chris Duhon": 3855,
    "Edmond Sumner": 5865,
    "Kadeem Allen": 5866,
    "Alec Peters": 5867,
    "Nigel Williams-Goss": 5868,
    "Jabari Bird": 5869,
    "Aleksandar Vezenkov": 5870,
    "Trevor Ariza": 3860,
    "Ognen Jaramaz": 5871,
    "Tim Pickett": 3861,
    "Jaron Blossomgame": 5872,
    "Alpha Kaba": 5873,
    "Milos Teodosic": 5875,
    "Antonio Blakeney": 5876,
    "Kennedy Meeks": 5877,
    "Matt Williams Jr.": 5878,
    "Yakuba Ouattara": 5879,
    "Daniel Theis": 5880,
    "Devin Robinson": 5881,
    "Johnathan Motley": 5882,
    "Gian Clavell": 5883,
    "Milton Doyle": 5884,
    "Jeremy Senglin": 5885,
    "Pj Dozier": 5886,
    "Jacob Wiley": 5887,
    "Dj Mbenga": 3877,
    "Ben Moore": 5888,
    "Isaiah Hicks": 5889,
    "Mangok Mathiang": 5890,
    "T.J. Williams": 5891,
    "Maxi Kleber": 5892,
    "Andres Nocioni": 3882,
    "Torrey Craig": 5893,
    "Chris Boucher": 5894,
    "Cameron Oliver": 5895,
    "Derrick Williams": 4883,
    "V.J. Beachem": 5896,
    "Tristan Thompson": 4884,
    "Jeremy Morgan": 5897,
    "Kobi Simmons": 5898,
    "Jonas Valanciunas": 4886,
    "Derrick Walton Jr.": 5899,
    "Jan Vesely": 4887,
    "Bronson Koenig": 5900,
    "Bismack Biyombo": 4888,
    "Jalen Moore": 5901,
    "Brandon Knight": 4889,
    "Charles Cooke": 5902,
    "Kemba Walker": 4890,
    "Luke Kornet": 5903,
    "Jimmer Fredette": 4891,
    "Alfonzo Mckinnie": 5904,
    "Klay Thompson": 4892,
    "Royce O'Neale": 5905,
    "Alec Burks": 4893,
    "Mike Young": 5906,
    "Markieff Morris": 4894,
    "Jamel Artis": 5907,
    "Marcus Morris Sr.": 4895,
    "Nigel Hayes": 5908,
    "Kawhi Leonard": 4896,
    "Xavier Rathan-Mayes": 5909,
    "Nikola Vucevic": 4897,
    "London Perrantes": 5910,
    "Damien Wilkins": 3900,
    "Iman Shumpert": 4898,
    "Troy Caupain": 5911,
    "Enes Kanter": 4899,
    "James Blackmon Jr.": 5912,
    "Andre Brown": 3902,
    "Chris Singleton": 4900,
    "Tyler Cavanaugh": 5913,
    "Tobias Harris": 4901,
    "Andre Barrett": 3904,
    "Naz Mitrou-Long": 5914,
    "Donatas Motiejunas": 4902,
    "Isaiah Briscoe": 5915,
    "Nolan Smith": 4903,
    "Peter Jok": 5916,
    "Kenneth Faried": 4904,
    "Andrew White Iii": 5917,
    "Nikola Mirotic": 4905,
    "Earl Barron": 3908,
    "L.J. Peak": 5918,
    "Reggie Jackson": 4906,
    "Rodney Purvis": 5919,
    "Amile Jefferson": 5920,
    "Marshon Brooks": 4907,
    "Matt Jones": 5921,
    "Jordan Hamilton": 4908,
    "Terry Henderson": 5922,
    "Jajuan Johnson": 4909,
    "Norris Cole": 4910,
    "Melo Trimble": 5923,
    "Cory Joseph": 4911,
    "Jordan Mathews": 5924,
    "Jimmy Butler": 4912,
    "Antonius Cleveland": 5925,
    "Bojan Bogdanovic": 4913,
    "Alex Hamilton": 5926,
    "Justin Harper": 4914,
    "Luke Petrasek": 5927,
    "Jacob Pullen": 5928,
    "Kyle Singler": 4915,
    "Jaylen Johnson": 5929,
    "Shelvin Mack": 4916,
    "Landry Nnoko": 5930,
    "Tyler Honeycutt": 4917,
    "Derek Willis": 5931,
    "Jordan Williams": 4918,
    "Amida Brimah": 5932,
    "Trey Thompkins": 4919,
    "Bryce Alford": 5933,
    "Chandler Parsons": 4920,
    "Rashawn Thomas": 5934,
    "Jeremy Tyler": 4921,
    "Erik Mccree": 5935,
    "Jon Leuer": 4922,
    "Devin Williams": 5936,
    "Andrew Bogut": 3927,
    "Jacorey Williams": 5937,
    "Darius Morris": 4923,
    "Taylor Braun": 5938,
    "Marvin Williams": 3928,
    "Malcolm Lee": 4924,
    "George De Paula": 5939,
    "Charles Jenkins": 4925,
    "Deron Williams": 3929,
    "Ladontae Henton": 5940,
    "Davis Bertans": 4926,
    "Chris Paul": 3930,
    "Durand Scott": 5941,
    "Josh Harrellson": 4927,
    "Raymond Felton": 3931,
    "Daniel Dixon": 5942,
    "Andrew Goudelock": 4928,
    "Martell Webster": 3932,
    "Torian Graham": 5943,
    "Travis Leslie": 4929,
    "Charlie Villanueva": 3933,
    "Reggie Hearn": 5944,
    "Keith Benson": 4930,
    "Channing Frye": 3934,
    "Davion Berry": 5945,
    "Josh Selby": 4931,
    "Isaac Hamilton": 5946,
    "Ike Diogu": 3935,
    "Lavoy Allen": 4932,
    "Tahjere Mccall": 5947,
    "Jon Diebler": 4933,
    "Andrew Bynum": 3936,
    "Kamari Murphy": 5948,
    "Vernon Macklin": 4934,
    "Trevor Thompson": 5949,
    "Deandre Liggins": 4935,
    "Ike Iroegbu": 5950,
    "Milan Macvan": 4936,
    "Sean May": 3939,
    "Myke Henry": 5951,
    "E'Twaun Moore": 4937,
    "Josh Gray": 5952,
    "Antoine Wright": 3941,
    "Chukwudiebere Maduabum": 4938,
    "Walt Lemon Jr.": 5953,
    "Tanguy Ngombo": 4939,
    "Joey Graham": 3942,
    "Jaylen Morris": 5954,
    "Ater Majok": 4940,
    "Danny Granger": 3943,
    "Le'Bryan Nash": 5955,
    "Adam Hanga": 4941,
    "Gerald Green": 3944,
    "Andre Ingram": 5956,
    "Isaiah Thomas": 4942,
    "Hakim Warrick": 3945,
    "Aaron Jackson": 5957,
    "Dennis Horner": 4943,
    "Deandre Ayton": 5958,
    "Jerry Smith": 4944,
    "Marvin Bagley Iii": 5959,
    "Nate Robinson": 3947,
    "Terrel Harris": 4945,
    "Jarrett Jack": 3948,
    "Gary Flowers": 4946,
    "Francisco Garcia": 3949,
    "Luther Head": 3950,
    "Edwin Ubiles": 4948,
    "Johan Petro": 3951,
    "Jarrid Famous": 4949,
    "Jason Maxiell": 3952,
    "Tyren Johnson": 4950,
    "Linas Kleiza": 3953,
    "Darnell Lazare": 4951,
    "Lawrence Hill": 4952,
    "Ian Mahinmi": 3954,
    "Adrian Oliver": 4953,
    "David Lee": 3956,
    "Jeremy Pargo": 4954,
    "Aaron Pettway": 4955,
    "Charles Garcia": 4956,
    "Zach Graham": 4957,
    "Brandon Bass": 3959,
    "Ivan Johnson": 4958,
    "C.J. Miles": 3960,
    "Brian Wanamaker": 4959,
    "Drew Neitzel": 4960,
    "Ersan Ilyasova": 3962,
    "Mike Tisdale": 4961,
    "Ronny Turiaf": 3963,
    "Xavier Silas": 4962,
    "Travis Diener": 3964,
    "Justin Dentmon": 4963,
    "Von Wafer": 3965,
    "Moses Ehambe": 4964,
    "Monta Ellis": 3966,
    "Carldell Johnson": 4965,
    "Lance Thomas": 4966,
    "Paul Carter": 4967,
    "Malcolm Thomas": 4968,
    "Brad Wanamaker": 4969,
    "Lou Williams": 3971,
    "Luke Zeller": 4970,
    "Omar Samhan": 4971,
    "Damian Saunders": 4972,
    "Mickael Gelabale": 3974,
    "Jerome Randle": 4973,
    "Andray Blatche": 3975,
    "Scottie Reynolds": 4974,
    "Ryan Gomes": 3976,
    "Adam Koch": 4975,
    "Zach Andrews": 4976,
    "Chris Daniels": 4977,
    "Orien Greene": 3979,
    "Jeremy Wise": 4978,
    "Dwight Buycks": 4979,
    "Jeremy Hazell": 4980,
    "Amir Johnson": 3982,
    "Billy White": 4981,
    "Marcin Gortat": 3983,
    "Tyrell Biggs": 4982,
    "Kyle Goldcamp": 4983,
    "Kenny Hayes": 4984,
    "Mychel Thompson": 4985,
    "Ibrahim Jaaber": 4986,
    "Fabricio Oberto": 3988,
    "Greg Smith": 4987,
    "Jose Calderon": 3989,
    "Marcus Lewis": 4988,
    "Ronnie Price": 3990,
    "Julian Khazzouh": 4989,
    "Tommy Mitchell": 4990,
    "Shavlik Randolph": 3992,
    "Gilbert Brown": 4991,
    "Anthony Goods": 4992,
    "Marcus Dove": 4993,
    "Alan Anderson": 3995,
    "Frank Hassell": 4995,
    "Isma'Il Muhammad": 4996,
    "Durrell Summers": 4997,
    "Will Bynum": 3999,
    "Courtney Fortson": 4998,
    "Cory Higgins": 4999
}
