# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CompleteSignRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, certificate=None, correlation_id=None, document_update_infos=None, max_signature_length=None, signing_location=None, transaction_id=None):
        """
        CompleteSignRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'certificate': 'str',
            'correlation_id': 'str',
            'document_update_infos': 'list[DocumentUpdateInfo]',
            'max_signature_length': 'str',
            'signing_location': 'str',
            'transaction_id': 'str'
        }

        self.attribute_map = {
            'certificate': 'certificate',
            'correlation_id': 'correlationId',
            'document_update_infos': 'documentUpdateInfos',
            'max_signature_length': 'maxSignatureLength',
            'signing_location': 'signingLocation',
            'transaction_id': 'transactionId'
        }

        self._certificate = certificate
        self._correlation_id = correlation_id
        self._document_update_infos = document_update_infos
        self._max_signature_length = max_signature_length
        self._signing_location = signing_location
        self._transaction_id = transaction_id

    @property
    def certificate(self):
        """
        Gets the certificate of this CompleteSignRequest.
        

        :return: The certificate of this CompleteSignRequest.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this CompleteSignRequest.
        

        :param certificate: The certificate of this CompleteSignRequest.
        :type: str
        """

        self._certificate = certificate

    @property
    def correlation_id(self):
        """
        Gets the correlation_id of this CompleteSignRequest.
        

        :return: The correlation_id of this CompleteSignRequest.
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id):
        """
        Sets the correlation_id of this CompleteSignRequest.
        

        :param correlation_id: The correlation_id of this CompleteSignRequest.
        :type: str
        """

        self._correlation_id = correlation_id

    @property
    def document_update_infos(self):
        """
        Gets the document_update_infos of this CompleteSignRequest.
        

        :return: The document_update_infos of this CompleteSignRequest.
        :rtype: list[DocumentUpdateInfo]
        """
        return self._document_update_infos

    @document_update_infos.setter
    def document_update_infos(self, document_update_infos):
        """
        Sets the document_update_infos of this CompleteSignRequest.
        

        :param document_update_infos: The document_update_infos of this CompleteSignRequest.
        :type: list[DocumentUpdateInfo]
        """

        self._document_update_infos = document_update_infos

    @property
    def max_signature_length(self):
        """
        Gets the max_signature_length of this CompleteSignRequest.
        

        :return: The max_signature_length of this CompleteSignRequest.
        :rtype: str
        """
        return self._max_signature_length

    @max_signature_length.setter
    def max_signature_length(self, max_signature_length):
        """
        Sets the max_signature_length of this CompleteSignRequest.
        

        :param max_signature_length: The max_signature_length of this CompleteSignRequest.
        :type: str
        """

        self._max_signature_length = max_signature_length

    @property
    def signing_location(self):
        """
        Gets the signing_location of this CompleteSignRequest.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :return: The signing_location of this CompleteSignRequest.
        :rtype: str
        """
        return self._signing_location

    @signing_location.setter
    def signing_location(self, signing_location):
        """
        Sets the signing_location of this CompleteSignRequest.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :param signing_location: The signing_location of this CompleteSignRequest.
        :type: str
        """

        self._signing_location = signing_location

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this CompleteSignRequest.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :return: The transaction_id of this CompleteSignRequest.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this CompleteSignRequest.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :param transaction_id: The transaction_id of this CompleteSignRequest.
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
