# What is Nodedge?

<div>

Nodedge is the first free and open-source graphical editor for engineering applications. It provides a comprehensive 
and intuitive environment for a variety of applications. With Nodedge, you can:
* design and **simulate dynamical systems** such as robotic, physical, and chemical systems
* **generate Python code** from your diagram-like models with a simple click
* interactively plot and edit the data generated by your simulation
* **plot and analyze log files** with common extensions like csv, mf4, mat, and others.

The user interface is designed for simplicity, allowing you to **sketch your program in a diagram-like flow** 
by drag-and-dropping graphic blocks. A set of built-in block libraries implements common functionalities like scalar and matrix operations, 
integration, differentiation, and many others. You can also implement your own custom blocks, reuse and 
share them with the community. 

Nodedge is **written in Python**, the number one programming language in the world for the number of users, and its code is fully 
transparent and **freely available on GitHub** for community collaboration and contributions. This ensures that Nodedge is 
constantly evolving and improving based on the latest needs of its users.
</div>
<br>

<center><img src="media/nodedge_interface.png" alt="nodedge_interface" width="500" /></center>
<br>


<h3>Physical simulation</h3>

The Nodedge simulation app allows you to simulate various types of systems and processes. 
These simulations can suit a variety of purposes, such as testing and analyzing the behavior of a physical model, 
predicting the outcomes of a chemical reaction, or studying the movements and actions of a robotic system.
To learn more about it, check out the [examples](resources.md#examples) provided.

<center>
<img src="media/simulator_icon.png" alt="nodedge_interface" height=150px/>
</center>

<h3>Data plotting and analysis</h3>

Nodedge provides you with an interactive plotting app, Dats. Within Dats, you can easily import the data generated by 
your simulation, plot, edit, and export it.
You can create new variables, also called signals, by modifying the existing ones, filtering, and combining them.
To learn more about it, check out the [examples](resources.md#examples) provided.

<center>
<img src="media/plotter_icon.png" alt="nodedge_interface" height=150px/>
</center>

<h3>Code generation</h3>

Nodedge supports the generation of standalone Python scripts from any graphical model.
In the near future, Nodedge has the goal to support code generation for various microcontroller targets. 
This means that users will be able to create their models graphically and then use Nodedge to convert those models into 
code that can be understood by off-the-shelf microcontrollers and uploaded to the hardware. 

<center>
<img src="media/code_generation_icon.png" alt="nodedge_interface" height=150px/>
</center>

# Roadmap

Nodedge development team has a lot of exciting features planned for the future! 
The project is actively being developed and there are plans to add support for a wide range of features.
If you wish to join our efforts, do not hesitate to contact us. Any help is welcome!

Our roadmap includes, and is not limited to:
* In Dats, add support for **hdf**, **tdms**, and **rosag** files
* In Nodedge, add support for matrix operation
* In Nodedge, add support for Python custom nodes. In a custom node, the user can enter a custom piece of Python code 
that runs within the current Nodedge model. The custom node can be saved to the nodes library and reused it in the future
* In Nodedge, add support for **integral and derivative nodes**
* In Nodedge, add support for the simulation of dynamic systems. In particular, add a widget for the selection of a solver 
and its configuration
* In Nodedge and Dats, add support for robotics-specific features, such as **embedded code generation** for common hardware platform, 
real-time data acquisition and inspection.
