"""
Type annotations for elb service client waiters.

[Open documentation](./waiters.md)

Usage::

    ```python
    import boto3

    from mypy_boto3_elb import ElasticLoadBalancingClient
    from mypy_boto3_elb.waiter import (
        AnyInstanceInServiceWaiter,
        InstanceDeregisteredWaiter,
        InstanceInServiceWaiter,
    )

    client: ElasticLoadBalancingClient = boto3.client("elb")

    any_instance_in_service_waiter: AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
    instance_deregistered_waiter: InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
    instance_in_service_waiter: InstanceInServiceWaiter = client.get_waiter("instance_in_service")
    ```
"""
from typing import List

from botocore.waiter import Waiter as Boto3Waiter

from .type_defs import InstanceTypeDef, WaiterConfigTypeDef

__all__ = ("AnyInstanceInServiceWaiter", "InstanceDeregisteredWaiter", "InstanceInServiceWaiter")

class AnyInstanceInServiceWaiter(Boto3Waiter):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.any_instance_in_service)[Show boto3-stubs documentation](./waiters.md#anyinstanceinservicewaiter)
    """

    def wait(
        self,
        LoadBalancerName: str,
        Instances: List["InstanceTypeDef"] = None,
        WaiterConfig: WaiterConfigTypeDef = None,
    ) -> None:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.AnyInstanceInServiceWaiter)
        [Show boto3-stubs documentation](./waiters.md#anyinstanceinservice)
        """

class InstanceDeregisteredWaiter(Boto3Waiter):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.instance_deregistered)[Show boto3-stubs documentation](./waiters.md#instancederegisteredwaiter)
    """

    def wait(
        self,
        LoadBalancerName: str,
        Instances: List["InstanceTypeDef"] = None,
        WaiterConfig: WaiterConfigTypeDef = None,
    ) -> None:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.InstanceDeregisteredWaiter)
        [Show boto3-stubs documentation](./waiters.md#instancederegistered)
        """

class InstanceInServiceWaiter(Boto3Waiter):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.instance_in_service)[Show boto3-stubs documentation](./waiters.md#instanceinservicewaiter)
    """

    def wait(
        self,
        LoadBalancerName: str,
        Instances: List["InstanceTypeDef"] = None,
        WaiterConfig: WaiterConfigTypeDef = None,
    ) -> None:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.72/reference/services/elb.html#ElasticLoadBalancing.Waiter.InstanceInServiceWaiter)
        [Show boto3-stubs documentation](./waiters.md#instanceinservice)
        """
