"use strict";
// tslint:disable: max-line-length
const core_1 = require("@aws-cdk/core");
const util_1 = require("../lib/util");
module.exports = {
    arnForParameterName: {
        'simple names': {
            'concrete parameterName and no physical name (sep is "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, 'myParam', undefined)), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/myParam']]
                });
                test.done();
            },
            'token parameterName and concrete physical name (no additional "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { physicalName: 'myParam' })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/', { Ref: 'Boom' }]]
                });
                test.done();
            },
            'token parameterName, explicit "/" separator'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { simpleName: true })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/', { Ref: 'Boom' }]]
                });
                test.done();
            }
        },
        'path names': {
            'concrete parameterName and no physical name (sep is "/")'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, '/foo/bar', undefined)), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter/foo/bar']]
                });
                test.done();
            },
            'token parameterName and concrete physical name (no sep)'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { physicalName: '/foo/bar' })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter', { Ref: 'Boom' }]]
                });
                test.done();
            },
            'token parameterName, explicit "" separator'(test) {
                const stack = new core_1.Stack();
                test.deepEqual(stack.resolve(util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' }), { simpleName: false })), {
                    'Fn::Join': ['', ['arn:', { Ref: 'AWS::Partition' }, ':ssm:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':parameter', { Ref: 'Boom' }]]
                });
                test.done();
            }
        },
        'fails if explicit separator is not defined and parameterName is a token'(test) {
            const stack = new core_1.Stack();
            test.throws(() => util_1.arnForParameterName(stack, core_1.Token.asString({ Ref: 'Boom' })), /Unable to determine ARN separator for SSM parameter since the parameter name is an unresolved token. Use "fromAttributes" and specify "simpleName" explicitly/);
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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