"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationCache = void 0;
const crypto = require("crypto");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class IntegrationCache {
    constructor() {
        this.integrations = {};
    }
    getIntegration(scope, config) {
        const configHash = this.integrationConfigHash(scope, config);
        const integration = this.integrations[configHash];
        return { configHash, integration };
    }
    saveIntegration(scope, config, integration) {
        const configHash = this.integrationConfigHash(scope, config);
        this.integrations[configHash] = integration;
    }
    integrationConfigHash(scope, config) {
        const stringifiedConfig = JSON.stringify(aws_cdk_lib_1.Stack.of(scope).resolve(config));
        const configHash = crypto.createHash('md5').update(stringifiedConfig).digest('hex');
        return configHash;
    }
}
exports.IntegrationCache = IntegrationCache;
//# sourceMappingURL=data:application/json;base64,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