"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const integration_1 = require("./integration");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
/**
 * (experimental) Supported CORS HTTP methods.
 *
 * @experimental
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    CorsHttpMethod["ANY"] = "*";
    CorsHttpMethod["DELETE"] = "DELETE";
    CorsHttpMethod["GET"] = "GET";
    CorsHttpMethod["HEAD"] = "HEAD";
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    CorsHttpMethod["PATCH"] = "PATCH";
    CorsHttpMethod["POST"] = "POST";
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod = exports.CorsHttpMethod || (exports.CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @experimental
     */
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @experimental
     */
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @experimental
     */
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @experimental
     */
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @experimental
     */
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @experimental
     */
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    /**
     * (experimental) Add a new VpcLink.
     *
     * @experimental
     */
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
    /**
     * @internal
     */
    _addIntegration(scope, config) {
        const { configHash, integration: existingIntegration } = this._integrationCache.getIntegration(scope, config);
        if (existingIntegration) {
            return existingIntegration;
        }
        const integration = new integration_1.HttpIntegration(scope, `HttpIntegration-${configHash}`, {
            httpApi: this,
            integrationType: config.type,
            integrationUri: config.uri,
            method: config.method,
            connectionId: config.connectionId,
            connectionType: config.connectionType,
            payloadFormatVersion: config.payloadFormatVersion,
            secureServerName: config.secureServerName,
            parameterMapping: config.parameterMapping,
        });
        this._integrationCache.saveIntegration(scope, config, integration);
        return integration;
    }
}
/**
 * (experimental) Create a new API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.httpApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        this.disableExecuteApiEndpoint = props === null || props === void 0 ? void 0 : props.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props === null || props === void 0 ? void 0 : props.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge === null || maxAge === void 0 ? void 0 : maxAge.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props === null || props === void 0 ? void 0 : props.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props === null || props === void 0 ? void 0 : props.defaultAuthorizer;
        this.defaultAuthorizationScopes = props === null || props === void 0 ? void 0 : props.defaultAuthorizationScopes;
        if (props === null || props === void 0 ? void 0 : props.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props === null || props === void 0 ? void 0 : props.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props === null || props === void 0 ? void 0 : props.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if ((props === null || props === void 0 ? void 0 : props.createDefaultStage) === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * (experimental) Import an existing HTTP API into this CDK app.
     *
     * @experimental
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Get the default endpoint for this API.
     *
     * @experimental
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * (experimental) Get the URL to the default stage of this API.
     *
     * Returns `undefined` if `createDefaultStage` is unset.
     *
     * @experimental
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * (experimental) Add a new stage.
     *
     * @experimental
     */
    addStage(id, options) {
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * (experimental) Add multiple routes that uses the same configuration.
     *
     * The routes all go to the same path, but for different
     * methods.
     *
     * @experimental
     */
    addRoutes(options) {
        var _b;
        const methods = (_b = options.methods) !== null && _b !== void 0 ? _b : [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            var _b, _c;
            const authorizationScopes = (_b = options.authorizationScopes) !== null && _b !== void 0 ? _b : this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: (_c = options.authorizer) !== null && _c !== void 0 ? _c : this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpApi", version: "2.0.0-alpha.2" };
//# sourceMappingURL=data:application/json;base64,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